/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle.util;

import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleRotation;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class AdvancedParticleData
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<AdvancedParticleData> DESERIALIZER = new ParticleOptions.Deserializer<AdvancedParticleData>(){

        public AdvancedParticleData fromCommand(ParticleType<AdvancedParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            double airDrag = reader.readDouble();
            reader.expect(' ');
            double red = reader.readDouble();
            reader.expect(' ');
            double green = reader.readDouble();
            reader.expect(' ');
            double blue = reader.readDouble();
            reader.expect(' ');
            double alpha = reader.readDouble();
            reader.expect(' ');
            String rotationMode = reader.readString();
            reader.expect(' ');
            double scale = reader.readDouble();
            reader.expect(' ');
            double yaw = reader.readDouble();
            reader.expect(' ');
            double pitch = reader.readDouble();
            reader.expect(' ');
            double roll = reader.readDouble();
            reader.expect(' ');
            boolean emissive = reader.readBoolean();
            reader.expect(' ');
            double duration = reader.readDouble();
            reader.expect(' ');
            double faceCameraAngle = reader.readDouble();
            reader.expect(' ');
            boolean canCollide = reader.readBoolean();
            ParticleRotation rotation = rotationMode.equals("face_camera") ? new ParticleRotation.FaceCamera((float)faceCameraAngle) : (rotationMode.equals("euler") ? new ParticleRotation.EulerAngles((float)yaw, (float)pitch, (float)roll) : new ParticleRotation.OrientVector(new Vec3(yaw, pitch, roll)));
            return new AdvancedParticleData(particleTypeIn, rotation, scale, red, green, blue, alpha, airDrag, duration, emissive, canCollide);
        }

        public AdvancedParticleData fromNetwork(ParticleType<AdvancedParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            double airDrag = buffer.readFloat();
            double red = buffer.readFloat();
            double green = buffer.readFloat();
            double blue = buffer.readFloat();
            double alpha = buffer.readFloat();
            String rotationMode = buffer.m_130277_();
            double scale = buffer.readFloat();
            double yaw = buffer.readFloat();
            double pitch = buffer.readFloat();
            double roll = buffer.readFloat();
            boolean emissive = buffer.readBoolean();
            double duration = buffer.readFloat();
            double faceCameraAngle = buffer.readFloat();
            boolean canCollide = buffer.readBoolean();
            ParticleRotation rotation = rotationMode.equals("face_camera") ? new ParticleRotation.FaceCamera((float)faceCameraAngle) : (rotationMode.equals("euler") ? new ParticleRotation.EulerAngles((float)yaw, (float)pitch, (float)roll) : new ParticleRotation.OrientVector(new Vec3(yaw, pitch, roll)));
            return new AdvancedParticleData(particleTypeIn, rotation, scale, red, green, blue, alpha, airDrag, duration, emissive, canCollide);
        }
    };
    private final ParticleType<? extends AdvancedParticleData> type;
    private final float airDrag;
    private final float red;
    private final float green;
    private final float blue;
    private final float alpha;
    private final ParticleRotation rotation;
    private final float scale;
    private final boolean emissive;
    private final float duration;
    private final boolean canCollide;
    private final ParticleComponent[] components;

    public AdvancedParticleData(ParticleType<? extends AdvancedParticleData> type, ParticleRotation rotation, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive, boolean canCollide) {
        this(type, rotation, scale, r, g, b, a, drag, duration, emissive, canCollide, new ParticleComponent[0]);
    }

    public AdvancedParticleData(ParticleType<? extends AdvancedParticleData> type, ParticleRotation rotation, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive, boolean canCollide, ParticleComponent[] components) {
        this.type = type;
        this.rotation = rotation;
        this.scale = (float)scale;
        this.red = (float)r;
        this.green = (float)g;
        this.blue = (float)b;
        this.alpha = (float)a;
        this.emissive = emissive;
        this.airDrag = (float)drag;
        this.duration = (float)duration;
        this.canCollide = canCollide;
        this.components = components;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        String rotationMode;
        float faceCameraAngle = 0.0f;
        float yaw = 0.0f;
        float pitch = 0.0f;
        float roll = 0.0f;
        if (this.rotation instanceof ParticleRotation.FaceCamera) {
            rotationMode = "face_camera";
            faceCameraAngle = ((ParticleRotation.FaceCamera)this.rotation).faceCameraAngle;
        } else if (this.rotation instanceof ParticleRotation.EulerAngles) {
            rotationMode = "euler";
            yaw = ((ParticleRotation.EulerAngles)this.rotation).yaw;
            pitch = ((ParticleRotation.EulerAngles)this.rotation).pitch;
            roll = ((ParticleRotation.EulerAngles)this.rotation).roll;
        } else {
            rotationMode = "orient";
            Vec3 vec = ((ParticleRotation.OrientVector)this.rotation).orientation;
            yaw = (float)vec.f_82479_;
            pitch = (float)vec.f_82480_;
            roll = (float)vec.f_82481_;
        }
        buffer.writeFloat(this.airDrag);
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
        buffer.writeFloat(this.alpha);
        buffer.m_130070_(rotationMode);
        buffer.writeFloat(this.scale);
        buffer.writeFloat(yaw);
        buffer.writeFloat(pitch);
        buffer.writeFloat(roll);
        buffer.writeBoolean(this.emissive);
        buffer.writeFloat(this.duration);
        buffer.writeFloat(faceCameraAngle);
        buffer.writeBoolean(this.canCollide);
    }

    public String m_5942_() {
        String rotationMode;
        float faceCameraAngle = 0.0f;
        float yaw = 0.0f;
        float pitch = 0.0f;
        float roll = 0.0f;
        if (this.rotation instanceof ParticleRotation.FaceCamera) {
            rotationMode = "face_camera";
            faceCameraAngle = ((ParticleRotation.FaceCamera)this.rotation).faceCameraAngle;
        } else if (this.rotation instanceof ParticleRotation.EulerAngles) {
            rotationMode = "euler";
            yaw = ((ParticleRotation.EulerAngles)this.rotation).yaw;
            pitch = ((ParticleRotation.EulerAngles)this.rotation).pitch;
            roll = ((ParticleRotation.EulerAngles)this.rotation).roll;
        } else {
            rotationMode = "orient";
            Vec3 vec = ((ParticleRotation.OrientVector)this.rotation).orientation;
            yaw = (float)vec.f_82479_;
            pitch = (float)vec.f_82480_;
            roll = (float)vec.f_82481_;
        }
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %s %.2f %.2f %.2f %.2f %b %.2f %.2f %b", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.airDrag), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.alpha), rotationMode, Float.valueOf(this.scale), Float.valueOf(yaw), Float.valueOf(pitch), Float.valueOf(roll), this.emissive, Float.valueOf(this.duration), Float.valueOf(faceCameraAngle), this.canCollide);
    }

    public ParticleType<? extends AdvancedParticleData> m_6012_() {
        return this.type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getRed() {
        return this.red;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getGreen() {
        return this.green;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getBlue() {
        return this.blue;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getAlpha() {
        return this.alpha;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getAirDrag() {
        return this.airDrag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ParticleRotation getRotation() {
        return this.rotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getScale() {
        return this.scale;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isEmissive() {
        return this.emissive;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getDuration() {
        return this.duration;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean getCanCollide() {
        return this.canCollide;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ParticleComponent[] getComponents() {
        return this.components;
    }

    public static Codec<AdvancedParticleData> CODEC(ParticleType<AdvancedParticleData> particleType) {
        return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.DOUBLE.fieldOf("scale").forGetter(AdvancedParticleData::getScale), (App)Codec.DOUBLE.fieldOf("r").forGetter(AdvancedParticleData::getRed), (App)Codec.DOUBLE.fieldOf("g").forGetter(AdvancedParticleData::getGreen), (App)Codec.DOUBLE.fieldOf("b").forGetter(AdvancedParticleData::getBlue), (App)Codec.DOUBLE.fieldOf("a").forGetter(AdvancedParticleData::getAlpha), (App)Codec.DOUBLE.fieldOf("drag").forGetter(AdvancedParticleData::getAirDrag), (App)Codec.DOUBLE.fieldOf("duration").forGetter(AdvancedParticleData::getDuration), (App)Codec.BOOL.fieldOf("emissive").forGetter(AdvancedParticleData::isEmissive), (App)Codec.BOOL.fieldOf("canCollide").forGetter(AdvancedParticleData::getCanCollide)).apply((Applicative)codecBuilder, (scale, r, g, b, a, drag, duration, emissive, canCollide) -> new AdvancedParticleData((ParticleType<? extends AdvancedParticleData>)particleType, new ParticleRotation.FaceCamera(0.0f), (double)scale, (double)r, (double)g, (double)b, (double)a, (double)drag, (double)duration, (boolean)emissive, (boolean)canCollide, new ParticleComponent[0])));
    }
}

