/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render;

import com.bobmowzie.mowziesmobs.client.model.tools.MathUtils;
import com.bobmowzie.mowziesmobs.client.model.tools.ModelPartMatrix;
import com.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;

public class MowzieRenderUtils {
    public static void matrixStackFromModel(PoseStack matrixStack, AdvancedModelRenderer modelRenderer) {
        AdvancedModelRenderer parent = modelRenderer.getParent();
        if (parent != null) {
            MowzieRenderUtils.matrixStackFromModel(matrixStack, parent);
        }
        modelRenderer.translateRotate(matrixStack);
    }

    public static Vec3 getWorldPosFromModel(Entity entity, float entityYaw, AdvancedModelRenderer modelRenderer) {
        PoseStack matrixStack = new PoseStack();
        matrixStack.m_85837_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        matrixStack.m_252781_(MathUtils.quatFromRotationXYZ(0.0f, -entityYaw + 180.0f, 0.0f, true));
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStack.m_252880_(0.0f, -1.5f, 0.0f);
        MowzieRenderUtils.matrixStackFromModel(matrixStack, modelRenderer);
        PoseStack.Pose matrixEntry = matrixStack.m_85850_();
        Matrix4f matrix4f = matrixEntry.m_252922_();
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vec.mul((Matrix4fc)matrix4f);
        return new Vec3((double)vec.x(), (double)vec.y(), (double)vec.z());
    }

    public static void translateRotateGeckolib(GeoBone bone, PoseStack matrixStackIn) {
        matrixStackIn.m_85837_((double)(bone.getPivotX() / 16.0f), (double)(bone.getPivotY() / 16.0f), (double)(bone.getPivotZ() / 16.0f));
        if (bone.getRotZ() != 0.0f) {
            matrixStackIn.m_252781_(Axis.f_252403_.m_252961_(bone.getRotZ()));
        }
        if (bone.getRotY() != 0.0f) {
            matrixStackIn.m_252781_(Axis.f_252436_.m_252961_(bone.getRotY()));
        }
        if (bone.getRotX() != 0.0f) {
            matrixStackIn.m_252781_(Axis.f_252529_.m_252961_(bone.getRotX()));
        }
        matrixStackIn.m_85841_(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public static void matrixStackFromModel(PoseStack matrixStack, GeoBone geoBone) {
        GeoBone parent = geoBone.getParent();
        if (parent != null) {
            MowzieRenderUtils.matrixStackFromModel(matrixStack, parent);
        }
        MowzieRenderUtils.translateRotateGeckolib(geoBone, matrixStack);
    }

    public static Vec3 getWorldPosFromModel(Entity entity, float entityYaw, GeoBone geoBone) {
        PoseStack matrixStack = new PoseStack();
        matrixStack.m_85837_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        matrixStack.m_252781_(MathUtils.quatFromRotationXYZ(0.0f, -entityYaw + 180.0f, 0.0f, true));
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStack.m_252880_(0.0f, -1.5f, 0.0f);
        MowzieRenderUtils.matrixStackFromModel(matrixStack, geoBone);
        PoseStack.Pose matrixEntry = matrixStack.m_85850_();
        Matrix4f matrix4f = matrixEntry.m_252922_();
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vec.mul((Matrix4fc)matrix4f);
        return new Vec3((double)vec.x(), (double)vec.y(), (double)vec.z());
    }

    public static void moveToPivotMirror(PoseStack stack, GeoCube cube) {
        Vec3 pivot = cube.pivot();
        stack.m_85837_(-pivot.m_7096_() / 16.0, pivot.m_7098_() / 16.0, pivot.m_7094_() / 16.0);
    }

    public static void translateAwayFromPivotPointMirror(PoseStack stack, GeoCube cube) {
        Vec3 pivot = cube.pivot();
        stack.m_85837_(pivot.m_7096_() / 16.0, -pivot.m_7098_() / 16.0, -pivot.m_7094_() / 16.0);
    }

    public static void moveToPivotMirror(PoseStack stack, GeoBone bone) {
        stack.m_85837_((double)(-bone.getPivotX() / 16.0f), (double)(bone.getPivotY() / 16.0f), (double)(bone.getPivotZ() / 16.0f));
    }

    public static void translateAwayFromPivotPointMirror(PoseStack stack, GeoBone bone) {
        stack.m_85837_((double)(bone.getPivotX() / 16.0f), (double)(-bone.getPivotY() / 16.0f), (double)(-bone.getPivotZ() / 16.0f));
    }

    public static void translateMirror(PoseStack stack, GeoBone bone) {
        stack.m_85837_((double)(bone.getPosX() / 16.0f), (double)(bone.getPosY() / 16.0f), (double)(bone.getPosZ() / 16.0f));
    }

    public static void rotateMirror(PoseStack stack, GeoBone bone) {
        if (bone.getRotZ() != 0.0f) {
            stack.m_252781_(Axis.f_252403_.m_252961_(-bone.getRotZ()));
        }
        if (bone.getRotY() != 0.0f) {
            stack.m_252781_(Axis.f_252436_.m_252961_(-bone.getRotY()));
        }
        if (bone.getRotX() != 0.0f) {
            stack.m_252781_(Axis.f_252529_.m_252961_(bone.getRotX()));
        }
    }

    public static void transformStackToModelPart(PoseStack stack, ModelPartMatrix part) {
        stack.m_85850_().m_252922_().identity();
        stack.m_85850_().m_252943_().identity();
        stack.m_85836_();
        stack.m_85850_().m_252922_().mul((Matrix4fc)part.getWorldXform());
        stack.m_85850_().m_252943_().mul((Matrix3fc)part.getWorldNormal());
    }
}

