/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability.abilities.player.geomancy;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoBone;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoModel;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.client.sound.IGeomancyRumbler;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ability.PlayerAbility;
import com.bobmowzie.mowziesmobs.server.capability.AbilityCapability;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityBlockSwapper;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityFallingBlock;
import com.bobmowzie.mowziesmobs.server.item.ItemEarthrendGauntlet;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.potion.EffectGeomancy;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.bobmowzie.mowziesmobs.server.tag.TagHandler;
import com.google.common.base.Supplier;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class TunnelingAbility
extends PlayerAbility
implements IGeomancyRumbler {
    private int doubleTapTimer = 0;
    public boolean prevUnderground;
    public BlockState justDug = Blocks.f_50493_.m_49966_();
    boolean underground = false;
    private float spinAmount = 0.0f;
    private float pitch = 0.0f;
    private int timeUnderground = 0;
    private int timeAboveGround = 0;
    private InteractionHand whichHand;
    private ItemStack gauntletStack;
    private boolean isRumbling;
    private static final RawAnimation FALL_ANIM = RawAnimation.begin().thenPlayAndHold("tunneling_fall");
    private static final RawAnimation DRILL_ANIM = RawAnimation.begin().thenLoop("tunneling_drill");

    public TunnelingAbility(AbilityType<Player, ? extends Ability> abilityType, Player user) {
        super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionInfinite(AbilitySection.AbilitySectionType.ACTIVE)});
    }

    @Override
    public void tickNotUsing() {
        super.tickNotUsing();
        if (this.doubleTapTimer > 0) {
            --this.doubleTapTimer;
        }
    }

    public void playGauntletAnimation() {
        if (this.getUser() != null && !this.getLevel().m_5776_() && this.gauntletStack != null && this.gauntletStack.m_41720_() == ItemHandler.EARTHREND_GAUNTLET.get()) {
            Player player = (Player)this.getUser();
            ((ItemEarthrendGauntlet)((Object)ItemHandler.EARTHREND_GAUNTLET.get())).triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)this.gauntletStack, (ServerLevel)((ServerLevel)player.m_9236_())), "controller", "open");
        }
    }

    public void stopGauntletAnimation() {
        if (this.getUser() != null && !this.getLevel().m_5776_() && this.gauntletStack != null && this.gauntletStack.m_41720_() == ItemHandler.EARTHREND_GAUNTLET.get()) {
            Player player = (Player)this.getUser();
            ((ItemEarthrendGauntlet)((Object)ItemHandler.EARTHREND_GAUNTLET.get())).triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)this.gauntletStack, (ServerLevel)((ServerLevel)player.m_9236_())), "controller", "idle");
        }
    }

    @Override
    public void start() {
        super.start();
        this.underground = false;
        this.prevUnderground = false;
        if (((Player)this.getUser()).m_20096_()) {
            ((Player)this.getUser()).m_5997_(0.0, (double)0.8f, 0.0);
        }
        this.whichHand = ((Player)this.getUser()).m_7655_();
        this.gauntletStack = ((Player)this.getUser()).m_21211_();
        if (((Player)this.getUser()).m_9236_().m_5776_()) {
            this.spinAmount = 0.0f;
            this.pitch = 0.0f;
        }
        if (this.getLevel().m_5776_()) {
            MowziesMobs.PROXY.playGeomancyRumbleSound(this);
        }
    }

    public boolean damageGauntlet() {
        ItemStack stack = ((Player)this.getUser()).m_21211_();
        if (stack.m_41720_() == ItemHandler.EARTHREND_GAUNTLET.get()) {
            InteractionHand handIn = ((Player)this.getUser()).m_7655_();
            if (stack.m_41773_() + 5 < stack.m_41776_()) {
                stack.m_41622_(5, (LivingEntity)((Player)this.getUser()), p -> p.m_21190_(handIn));
                return true;
            }
            if (((Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHREND_GAUNTLET.breakable.get()).booleanValue()) {
                stack.m_41622_(5, (LivingEntity)((Player)this.getUser()), p -> p.m_21190_(handIn));
            }
            return false;
        }
        return false;
    }

    public void restoreGauntlet(ItemStack stack) {
        if (stack.m_41720_() == ItemHandler.EARTHREND_GAUNTLET.get() && !((Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHREND_GAUNTLET.breakable.get()).booleanValue()) {
            stack.m_41721_(Math.max(stack.m_41773_() - 1, 0));
        }
    }

    @Override
    public void tick() {
        super.tick();
        AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)this.getUser());
        if (abilityCapability == null) {
            return;
        }
        if (abilityCapability.getActiveAbility() == null || abilityCapability.getActiveAbility().getAbilityType() != AbilityHandler.SPAWN_PILLAR_ABILITY && abilityCapability.getActiveAbility().getAbilityType() != AbilityHandler.TUNNELING_ABILITY) {
            Player player = (Player)this.getUser();
            for (ItemStack stack : player.m_150109_().f_35974_) {
                this.restoreGauntlet(stack);
            }
            for (ItemStack stack : player.m_150109_().f_35976_) {
                this.restoreGauntlet(stack);
            }
        }
    }

    @Override
    public void tickUsing() {
        boolean usingGauntlet;
        super.tickUsing();
        ((Player)this.getUser()).m_150110_().f_35935_ = false;
        this.underground = !((Player)this.getUser()).m_9236_().m_45976_(EntityBlockSwapper.EntityBlockSwapperTunneling.class, ((Player)this.getUser()).m_20191_().m_82400_(0.3)).isEmpty();
        Vec3 lookVec = ((Player)this.getUser()).m_20154_();
        float tunnelSpeed = 0.3f;
        ItemStack stack = ((Player)this.getUser()).m_21211_();
        boolean bl = usingGauntlet = stack.m_41720_() == ItemHandler.EARTHREND_GAUNTLET.get();
        if (this.underground) {
            ++this.timeUnderground;
            if (usingGauntlet && this.damageGauntlet()) {
                ((Player)this.getUser()).m_20256_(lookVec.m_82541_().m_82490_((double)tunnelSpeed));
            } else {
                ((Player)this.getUser()).m_20256_(lookVec.m_82542_(0.3, 0.0, 0.3).m_82520_(0.0, 1.0, 0.0).m_82541_().m_82490_((double)tunnelSpeed));
            }
            List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby((LivingEntity)this.getUser(), 2.0, 2.0, 2.0, 2.0);
            for (LivingEntity entityHit : entitiesHit) {
                DamageSource damageSource = ((Player)this.getUser()).m_269291_().m_269075_((Player)this.getUser());
                entityHit.m_6469_(damageSource, 3.0f * ((Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHREND_GAUNTLET.attackMultiplier.get()).floatValue());
            }
        } else {
            ++this.timeAboveGround;
            ((Player)this.getUser()).m_20256_(((Player)this.getUser()).m_20184_().m_82492_(0.0, 0.07, 0.0));
            if (((Player)this.getUser()).m_20184_().m_7098_() < -1.3) {
                ((Player)this.getUser()).m_20334_(((Player)this.getUser()).m_20184_().m_7096_(), -1.3, ((Player)this.getUser()).m_20184_().m_7094_());
            }
        }
        if (this.underground && (this.prevUnderground || lookVec.f_82480_ < 0.0) && this.timeAboveGround > 5 || this.getTicksInUse() > 1 && usingGauntlet && lookVec.f_82480_ < 0.0 && stack.m_41773_() + 5 < stack.m_41776_()) {
            Vec3 userCenter = ((Player)this.getUser()).m_20182_().m_82520_(0.0, (double)(((Player)this.getUser()).m_20206_() / 2.0f), 0.0);
            float radius = 2.0f;
            AABB aabb = new AABB((double)(-radius), (double)(-radius), (double)(-radius), (double)radius, (double)radius, (double)radius);
            aabb = aabb.m_82383_(userCenter);
            int i = 0;
            while ((double)i < ((Player)this.getUser()).m_20184_().m_82553_() * 4.0) {
                int x = (int)Math.floor(aabb.f_82288_);
                while ((double)x <= Math.floor(aabb.f_82291_)) {
                    int y = (int)Math.floor(aabb.f_82289_);
                    while ((double)y <= Math.floor(aabb.f_82292_)) {
                        int z = (int)Math.floor(aabb.f_82290_);
                        while ((double)z <= Math.floor(aabb.f_82293_)) {
                            Vec3 posVec = new Vec3((double)x, (double)y, (double)z);
                            if (!(posVec.m_82520_(0.5, 0.5, 0.5).m_82546_(userCenter).m_82556_() > (double)(radius * radius))) {
                                Vec3 motionScaled = ((Player)this.getUser()).m_20184_().m_82541_().m_82490_((double)i);
                                posVec = posVec.m_82549_(motionScaled);
                                BlockPos pos = new BlockPos((int)posVec.f_82479_, (int)posVec.f_82480_, (int)posVec.f_82481_);
                                BlockState blockState = ((Player)this.getUser()).m_9236_().m_8055_(pos);
                                if (EffectGeomancy.checkBlock(blockState, TagHandler.GEOMANCY_TUNNELABLE) && blockState.m_60734_() != Blocks.f_50752_) {
                                    this.justDug = blockState;
                                    if (!this.getLevel().f_46443_) {
                                        EntityBlockSwapper.EntityBlockSwapperTunneling swapper = new EntityBlockSwapper.EntityBlockSwapperTunneling((EntityType<? extends EntityBlockSwapper.EntityBlockSwapperTunneling>)((EntityType)EntityHandler.BLOCK_SWAPPER_TUNNELING.get()), this.getLevel(), pos, Blocks.f_50016_.m_49966_(), 15, false, false, (LivingEntity)this.getUser());
                                        this.getLevel().m_7967_((Entity)swapper);
                                    }
                                }
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++i;
            }
        }
        this.isRumbling = this.underground;
        if (!this.prevUnderground && this.underground) {
            this.timeUnderground = 0;
            ((Player)this.getUser()).m_5496_((SoundEvent)((Supplier)MMSounds.EFFECT_GEOMANCY_BREAK_MEDIUM.get(this.rand.nextInt(3))).get(), 1.0f, 0.9f + this.rand.nextFloat() * 0.1f);
            if (((Player)this.getUser()).m_9236_().f_46443_) {
                AdvancedParticleBase.spawnParticle(((Player)this.getUser()).m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING2.get()), (float)((Player)this.getUser()).m_20185_(), (float)((Player)this.getUser()).m_20186_() + 0.02f, (float)((Player)this.getUser()).m_20189_(), 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, 10.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(10.0f, 30.0f), false)});
            }
            this.playGauntletAnimation();
        }
        if (this.prevUnderground && !this.underground) {
            this.timeAboveGround = 0;
            ((Player)this.getUser()).m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK.get(), 1.0f, 0.9f + this.rand.nextFloat() * 0.1f);
            if (((Player)this.getUser()).m_9236_().f_46443_) {
                AdvancedParticleBase.spawnParticle(((Player)this.getUser()).m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING2.get()), (float)((Player)this.getUser()).m_20185_(), (float)((Player)this.getUser()).m_20186_() + 0.02f, (float)((Player)this.getUser()).m_20189_(), 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, 10.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(10.0f, 30.0f), false)});
            }
            if (this.timeUnderground > 10) {
                ((Player)this.getUser()).m_20256_(((Player)this.getUser()).m_20184_().m_82490_(10.0));
            } else {
                ((Player)this.getUser()).m_20256_(((Player)this.getUser()).m_20184_().m_82542_(3.0, 7.0, 3.0));
            }
            for (int i = 0; i < 6; ++i) {
                if (this.justDug == null) {
                    this.justDug = Blocks.f_50493_.m_49966_();
                }
                EntityFallingBlock fallingBlock = new EntityFallingBlock((EntityType)EntityHandler.FALLING_BLOCK.get(), ((Player)this.getUser()).m_9236_(), 80, this.justDug);
                fallingBlock.m_6034_(((Player)this.getUser()).m_20185_(), ((Player)this.getUser()).m_20186_() + 1.0, ((Player)this.getUser()).m_20189_());
                fallingBlock.m_20334_(((Player)this.getUser()).m_217043_().m_188501_() * 0.8f - 0.4f, 0.4f + ((Player)this.getUser()).m_217043_().m_188501_() * 0.8f, ((Player)this.getUser()).m_217043_().m_188501_() * 0.8f - 0.4f);
                ((Player)this.getUser()).m_9236_().m_7967_((Entity)fallingBlock);
            }
            this.stopGauntletAnimation();
        }
        this.prevUnderground = this.underground;
    }

    @Override
    public void end() {
        super.end();
        this.stopGauntletAnimation();
    }

    @Override
    public boolean canUse() {
        return super.canUse() && (Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHREND_GAUNTLET.enableTunneling.get() != false;
    }

    @Override
    protected boolean canContinueUsing() {
        boolean usingGauntlet;
        ItemStack stack = ((Player)this.getUser()).m_21211_();
        boolean bl = usingGauntlet = stack.m_41720_() == ItemHandler.EARTHREND_GAUNTLET.get();
        if (this.whichHand == null) {
            return false;
        }
        boolean canContinueUsing = (this.getTicksInUse() <= 1 || !((Player)this.getUser()).m_20096_() && (!((Player)this.getUser()).m_20069_() || usingGauntlet) || this.underground) && ((Player)this.getUser()).m_21120_(this.whichHand).m_41720_() == ItemHandler.EARTHREND_GAUNTLET.get() && super.canContinueUsing();
        return canContinueUsing;
    }

    @Override
    public boolean preventsItemUse(ItemStack stack) {
        if (stack.m_41720_() == ItemHandler.EARTHREND_GAUNTLET.get()) {
            return false;
        }
        return super.preventsItemUse(stack);
    }

    @Override
    public <E extends GeoEntity> PlayState animationPredicate(AnimationState<E> e, GeckoPlayer.Perspective perspective) {
        e.getController().transitionLength(4);
        if (perspective == GeckoPlayer.Perspective.THIRD_PERSON) {
            float yMotionThreshold;
            float f = yMotionThreshold = this.getUser() == Minecraft.m_91087_().f_91074_ ? 1.0f : 2.0f;
            if (!this.underground && ((Player)this.getUser()).m_21211_().m_41720_() != ItemHandler.EARTHREND_GAUNTLET.get() && ((Player)this.getUser()).m_20184_().m_7098_() < (double)yMotionThreshold) {
                e.getController().setAnimation(FALL_ANIM);
            } else {
                e.getController().setAnimation(DRILL_ANIM);
            }
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void codeAnimations(MowzieGeoModel<? extends GeoEntity> model, float partialTick) {
        super.codeAnimations(model, partialTick);
        float faceMotionController = 1.0f - model.getControllerValueInverted("FaceVelocityController");
        Vec3 moveVec = ((Player)this.getUser()).m_20184_().m_82541_();
        this.pitch = (float)Mth.m_14139_((double)(0.3 * (double)partialTick), (double)this.pitch, (double)moveVec.m_7098_());
        MowzieGeoBone com = model.getMowzieBone("CenterOfMass");
        com.setRotX((float)(-1.5707963267948966 + 1.5707963267948966 * (double)this.pitch) * faceMotionController);
        float spinSpeed = 0.35f;
        if (faceMotionController < 1.0f && (double)this.spinAmount < 6.2731853071795864 && (double)this.spinAmount > 0.01) {
            float f = (float)((Math.PI * 2 - (double)this.spinAmount) / (Math.PI * 2));
            f = (float)Math.pow(f, 0.5);
            this.spinAmount += partialTick * spinSpeed * f;
            if ((double)this.spinAmount > Math.PI * 2) {
                this.spinAmount = 0.0f;
            }
        } else {
            this.spinAmount += faceMotionController * partialTick * spinSpeed;
            this.spinAmount = (float)((double)this.spinAmount % (Math.PI * 2));
        }
        MowzieGeoBone waist = model.getMowzieBone("Waist");
        waist.addRotY(-this.spinAmount);
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag compound = super.writeNBT();
        if (this.isUsing() && this.whichHand != null) {
            compound.m_128405_("whichHand", this.whichHand.ordinal());
        }
        return compound;
    }

    @Override
    public void readNBT(Tag nbt) {
        super.readNBT(nbt);
        if (this.isUsing()) {
            CompoundTag compound = (CompoundTag)nbt;
            this.whichHand = InteractionHand.values()[compound.m_128451_("whichHand")];
        }
    }

    @Override
    public void onFall(LivingFallEvent event) {
        super.onFall(event);
        if (event.getEntity() == this.getUser() && this.isUsing()) {
            event.setDamageMultiplier(0.0f);
        }
    }

    @Override
    public boolean isRumbling() {
        return this.isRumbling && this.isUsing();
    }

    @Override
    public boolean isFinishedRumbling() {
        return !this.isUsing();
    }

    @Override
    public float getRumblerX() {
        return (float)((Player)this.getUser()).m_20185_();
    }

    @Override
    public float getRumblerY() {
        return (float)((Player)this.getUser()).m_20186_();
    }

    @Override
    public float getRumblerZ() {
        return (float)((Player)this.getUser()).m_20189_();
    }
}

