/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.item;

import com.bobmowzie.mowziesmobs.client.render.item.RenderUmvuthanaMaskArmor;
import com.bobmowzie.mowziesmobs.client.render.item.RenderUmvuthanaMaskItem;
import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.PlayerCapability;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthana;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaCraneToPlayer;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaFollowerToPlayer;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.MaskType;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.item.ItemSolVisage;
import com.bobmowzie.mowziesmobs.server.item.MowzieArmorItem;
import com.bobmowzie.mowziesmobs.server.item.UmvuthanaMask;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ItemUmvuthanaMask
extends MowzieArmorItem
implements UmvuthanaMask,
GeoItem {
    private final MaskType type;
    private static final UmvuthanaMaskMaterial UMVUTHANA_MASK_MATERIAL = new UmvuthanaMaskMaterial();
    public String controllerName = "controller";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation UMVUTHANA_ANIM = RawAnimation.begin().thenLoop("umvuthana");
    private static final RawAnimation PLAYER_ANIM = RawAnimation.begin().thenLoop("player");

    public ItemUmvuthanaMask(MaskType type, Item.Properties properties) {
        super(UMVUTHANA_MASK_MATERIAL, ArmorItem.Type.HELMET, properties);
        this.type = type;
    }

    public MobEffect getPotion() {
        return this.type.potion;
    }

    public boolean m_6832_(ItemStack itemStack, ItemStack materialItemStack) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ItemStack headStack = (ItemStack)player.m_150109_().f_35975_.get(3);
        if (headStack.m_41720_() instanceof ItemSolVisage) {
            boolean didSpawn;
            if (((Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.SOL_VISAGE.breakable.get()).booleanValue() && !player.m_7500_()) {
                headStack.m_41622_(2, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            if (didSpawn = this.spawnUmvuthana(this.type, stack, player, (float)stack.m_41773_() / (float)stack.m_41776_())) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
        }
        return super.m_7203_(world, player, hand);
    }

    private boolean spawnUmvuthana(MaskType mask, ItemStack stack, Player player, float durability) {
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)player, CapabilityHandler.PLAYER_CAPABILITY);
        if (playerCapability != null && playerCapability.getPackSize() < (Integer)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.SOL_VISAGE.maxFollowers.get()) {
            player.m_5496_((SoundEvent)MMSounds.ENTITY_UMVUTHI_BELLY.get(), 1.5f, 1.0f);
            player.m_5496_((SoundEvent)MMSounds.ENTITY_UMVUTHANA_BLOWDART.get(), 1.5f, 0.5f);
            double angle = player.m_6080_();
            if (angle < 0.0) {
                angle += 360.0;
            }
            EntityUmvuthanaFollowerToPlayer umvuthana = mask == MaskType.FAITH ? new EntityUmvuthanaCraneToPlayer((EntityType<? extends EntityUmvuthanaCraneToPlayer>)((EntityType)EntityHandler.UMVUTHANA_CRANE_TO_PLAYER.get()), player.m_9236_(), player) : new EntityUmvuthanaFollowerToPlayer((EntityType<? extends EntityUmvuthanaFollowerToPlayer>)((EntityType)EntityHandler.UMVUTHANA_FOLLOWER_TO_PLAYER.get()), player.m_9236_(), player);
            if (!player.m_9236_().f_46443_) {
                if (mask != MaskType.FAITH) {
                    int weapon = mask != MaskType.FURY ? umvuthana.randomizeWeapon() : 0;
                    umvuthana.setWeapon(weapon);
                }
                umvuthana.m_19890_(player.m_20185_() + 1.0 * Math.sin(-angle * (Math.PI / 180)), player.m_20186_() + 1.5, player.m_20189_() + 1.0 * Math.cos(-angle * (Math.PI / 180)), (float)angle, 0.0f);
                umvuthana.setActive(false);
                umvuthana.active = false;
                player.m_9236_().m_7967_((Entity)umvuthana);
                double vx = 0.5 * Math.sin(-angle * Math.PI / 180.0);
                double vy = 0.5;
                double vz = 0.5 * Math.cos(-angle * Math.PI / 180.0);
                umvuthana.m_20334_(vx, vy, vz);
                umvuthana.m_21153_((1.0f - durability) * umvuthana.m_21233_());
                umvuthana.setMask(mask);
                umvuthana.setStoredMask(stack.m_41777_());
                if (stack.m_41788_()) {
                    umvuthana.m_6593_(stack.m_41786_());
                }
            }
            return true;
        }
        return false;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer itemRenderer = new RenderUmvuthanaMaskItem();
            private GeoArmorRenderer<?> armorRenderer;

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.armorRenderer == null) {
                    this.armorRenderer = new RenderUmvuthanaMaskArmor();
                }
                if (equipmentSlot == EquipmentSlot.HEAD) {
                    this.armorRenderer.prepForRender((Entity)entityLiving, itemStack, equipmentSlot, original);
                }
                return this.armorRenderer;
            }

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.itemRenderer;
            }
        });
    }

    public MaskType getMaskType() {
        return this.type;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        String s = ChatFormatting.m_126649_((String)stack.m_41786_().getString());
        return new ResourceLocation("mowziesmobs", "textures/item/umvuthana_mask_" + this.type.name + ".png").toString();
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".text.0")).m_6270_(ItemHandler.TOOLTIP_STYLE));
        tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".text.1")).m_6270_(ItemHandler.TOOLTIP_STYLE));
    }

    @Override
    public ConfigHandler.ArmorConfig getConfig() {
        return ConfigHandler.COMMON.TOOLS_AND_ABILITIES.UMVUTHANA_MASK.armorConfig;
    }

    public <P extends Item> PlayState predicate(AnimationState<P> event) {
        Entity entity = (Entity)event.getData(DataTickets.ENTITY);
        if (entity instanceof EntityUmvuthana) {
            event.getController().setAnimation(UMVUTHANA_ANIM);
        } else {
            event.getController().setAnimation(PLAYER_ANIM);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, this.controllerName, 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private static class UmvuthanaMaskMaterial
    implements ArmorMaterial {
        private UmvuthanaMaskMaterial() {
        }

        public int m_266425_(ArmorItem.Type equipmentSlotType) {
            return ArmorMaterials.LEATHER.m_266425_(equipmentSlotType);
        }

        public int m_7366_(ArmorItem.Type equipmentSlotType) {
            return (int)((float)ArmorMaterials.LEATHER.m_7366_(ArmorItem.Type.HELMET) * ConfigHandler.COMMON.TOOLS_AND_ABILITIES.UMVUTHANA_MASK.armorConfig.damageReductionMultiplierValue);
        }

        public int m_6646_() {
            return ArmorMaterials.LEATHER.m_6646_();
        }

        public SoundEvent m_7344_() {
            return ArmorMaterials.LEATHER.m_7344_();
        }

        public Ingredient m_6230_() {
            return null;
        }

        public String m_6082_() {
            return "umvuthana_mask";
        }

        public float m_6651_() {
            return ArmorMaterials.LEATHER.m_6651_() * ConfigHandler.COMMON.TOOLS_AND_ABILITIES.UMVUTHANA_MASK.armorConfig.toughnessMultiplierValue;
        }

        public float m_6649_() {
            return ArmorMaterials.LEATHER.m_6649_();
        }
    }
}

