/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.charm;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class CrystalHeartItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"heart").stat(StatData.builder((String)"amount").initialValue(2.0, 6.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> (int)MathUtils.round((double)value, (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-1435881).borderBottom(-8585216).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).build()).loot(LootData.builder().entry(LootCollections.ANTHROPOGENIC).build()).build();
    }

    public void wornTick(LivingEntity entity, ItemStack stack) {
        Player player;
        block3: {
            block2: {
                if (!(entity instanceof Player)) break block2;
                player = (Player)entity;
                if (this.canUseAbility(stack, "heart")) break block3;
            }
            return;
        }
        EntityUtils.applyAttribute((LivingEntity)player, (ItemStack)stack, (Attribute)Attributes.f_22276_, (float)((float)this.getAbilityValue(stack, "heart", "amount")), (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
    }

    public void onUnequip(LivingEntity entity, ItemStack stack) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack currentStack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.CRYSTAL_HEART.get()));
        if (!currentStack.m_41619_()) {
            return;
        }
        EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Attribute)Attributes.f_22276_, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
        if (player.m_21223_() > player.m_21233_()) {
            player.m_21153_(player.m_21233_());
        }
    }

    @Mod.EventBusSubscriber
    public static class CrystalHeartEvent {
        @SubscribeEvent
        public static void onLivingHealEvent(LivingHealEvent event) {
            CrystalHeartItem relic;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)event.getEntity(), (Item)((Item)ModItems.CRYSTAL_HEART.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof CrystalHeartItem) || !(relic = (CrystalHeartItem)item).canUseAbility(stack, "heart")) {
                return;
            }
            float maxHealth = player.m_21233_();
            if ((double)player.m_217043_().m_188501_() <= Math.max(0.1, (double)((maxHealth - player.m_21223_()) / maxHealth))) {
                relic.spreadExperience((LivingEntity)player, stack, 1);
            }
        }
    }
}

