/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.elements;

import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.lib.Assembly;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.SliderState;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Axis;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Position;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Rectangle;
import net.creeperhost.polylib.helpers.MathUtil;
import org.jetbrains.annotations.NotNull;

public class GuiSlider
extends GuiElement<GuiSlider> {
    private final Axis axis;
    private SliderState state = SliderState.create(0.1);
    private GuiElement<?> slider;
    private double outOfBoundsDist = 50.0;
    private GuiElement<?> scrollableElement;
    private int dragButton = 0;
    private int scrollDragButton = 2;
    private boolean middleClickScroll = false;
    public boolean invertDragScroll = false;
    private boolean dragging = false;
    private double slideStartPos = 0.0;
    private Position clickPos = Position.create(0.0, 0.0);
    private boolean scrollableDragging = false;

    public GuiSlider(@NotNull GuiParent<?> parent, Axis axis) {
        super(parent);
        this.axis = axis;
        this.installSlider(new GuiElement(this));
        this.bindSliderLength();
        this.bindSliderWidth();
    }

    public GuiSlider(@NotNull GuiParent<?> parent, Axis axis, GuiElement<?> slider) {
        super(parent);
        this.axis = axis;
        this.installSlider(slider);
    }

    public GuiSlider setSliderState(SliderState state) {
        this.state = state;
        return this;
    }

    public GuiSlider setScrollableElement(GuiElement<?> scrollableElement) {
        return this.setScrollableElement(scrollableElement, true);
    }

    public GuiSlider setScrollableElement(GuiElement<?> scrollableElement, boolean middleClickScroll) {
        this.scrollableElement = scrollableElement;
        this.middleClickScroll = middleClickScroll;
        return this;
    }

    public GuiSlider installSlider(GuiElement<?> slider) {
        if (slider.getParent() != this) {
            throw new IllegalStateException("slider element must be a child of the GuiSlider it is being installed in");
        }
        if (this.slider != null) {
            this.removeChild(this.slider);
        }
        this.slider = slider;
        switch (this.axis) {
            case X: {
                slider.constrain(GeoParam.LEFT, Constraint.relative(this.get(GeoParam.LEFT), () -> (this.getValue(GeoParam.WIDTH) - slider.getValue(GeoParam.WIDTH)) * this.state.getPos()));
                break;
            }
            case Y: {
                slider.constrain(GeoParam.TOP, Constraint.relative(this.get(GeoParam.TOP), () -> (this.getValue(GeoParam.HEIGHT) - slider.getValue(GeoParam.HEIGHT)) * this.state.getPos()));
            }
        }
        return this;
    }

    public GuiSlider bindSliderLength() {
        switch (this.axis) {
            case X: {
                ((GuiElement)this.slider.constrain(GeoParam.RIGHT, null)).constrain(GeoParam.WIDTH, Constraint.dynamic(() -> this.getValue(GeoParam.WIDTH) * this.state.sliderRatio()));
                break;
            }
            case Y: {
                ((GuiElement)this.slider.constrain(GeoParam.BOTTOM, null)).constrain(GeoParam.HEIGHT, Constraint.dynamic(() -> this.getValue(GeoParam.HEIGHT) * this.state.sliderRatio()));
            }
        }
        return this;
    }

    public GuiSlider bindSliderWidth() {
        switch (this.axis) {
            case X: {
                ((GuiElement)((GuiElement)this.slider.constrain(GeoParam.HEIGHT, null)).constrain(GeoParam.TOP, Constraint.match(this.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, Constraint.match(this.get(GeoParam.BOTTOM)));
                break;
            }
            case Y: {
                ((GuiElement)((GuiElement)this.slider.constrain(GeoParam.WIDTH, null)).constrain(GeoParam.LEFT, Constraint.match(this.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, Constraint.match(this.get(GeoParam.RIGHT)));
            }
        }
        return this;
    }

    public GuiElement<?> getSlider() {
        return this.slider;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public GuiSlider setOutOfBoundsDist(double outOfBoundsDist) {
        this.outOfBoundsDist = outOfBoundsDist;
        return this;
    }

    public GuiSlider setDragButton(int dragButton) {
        this.dragButton = dragButton;
        return this;
    }

    public GuiSlider setScrollDragButton(int scrollDragButton) {
        this.scrollDragButton = scrollDragButton;
        return this;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.dragging = false;
        this.clickPos = Position.create(mouseX, mouseY);
        this.slideStartPos = this.state.getPos();
        if (button == this.dragButton && this.isMouseOver()) {
            if (!this.slider.isMouseOver()) {
                this.clickPos = Position.create(this.slider.xCenter(), this.slider.yCenter());
                this.handleDrag(mouseX, mouseY);
            }
            this.dragging = true;
            return true;
        }
        if (button == this.scrollDragButton && this.scrollableElement != null && this.scrollableElement.isMouseOver()) {
            this.scrollableDragging = true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button, boolean consumed) {
        this.scrollableDragging = false;
        this.dragging = false;
        return super.mouseReleased(mouseX, mouseY, button, consumed);
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        if (this.dragging || this.scrollableDragging && this.scrollableElement != null) {
            this.handleDrag(mouseX, mouseY);
        }
        super.mouseMoved(mouseX, mouseY);
    }

    private void handleDrag(double mouseX, double mouseY) {
        Rectangle rect;
        Position mousePos = Position.create(mouseX, mouseY);
        Rectangle rectangle = rect = this.dragging || this.scrollableElement == null ? this.getRectangle() : this.scrollableElement.getRectangle();
        if (this.dragging && this.outOfBoundsDist >= -1.0 && rect.distance(this.axis.opposite(), mousePos) > this.outOfBoundsDist) {
            this.state.setPos(this.slideStartPos);
            return;
        }
        double travel = rect.size(this.axis) - this.slider.getRectangle().size(this.axis);
        if (travel <= 0.0) {
            return;
        }
        double clickPos = this.clickPos.get(this.axis);
        double currentPos = mousePos.get(this.axis);
        double movement = (currentPos - clickPos) / travel;
        if (this.scrollableDragging) {
            movement *= this.invertDragScroll ? this.state.sliderRatio() : -this.state.sliderRatio();
        }
        this.state.setPos(MathUtil.clamp(this.slideStartPos + movement, 0.0, 1.0));
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        if (this.isMouseOver() || this.scrollableElement != null && this.scrollableElement.isMouseOver()) {
            if (!this.state.canScroll(this.axis)) {
                return false;
            }
            this.state.setPos(MathUtil.clamp(this.state.getPos() + this.state.scrollSpeed() * -scroll, 0.0, 1.0));
            return true;
        }
        return false;
    }

    public static Assembly<GuiRectangle, GuiSlider> vanillaScrollBar(GuiElement<?> parent, Axis axis) {
        GuiRectangle background = GuiRectangle.vanillaSlot(parent);
        GuiSlider slider = new GuiSlider(background, axis);
        Constraints.bind(slider, background, 1.0);
        slider.installSlider(GuiRectangle.planeButton(slider)).bindSliderLength().bindSliderWidth();
        GuiRectangle sliderHighlight = (GuiRectangle)new GuiRectangle(slider.getSlider()).fill(1342224127).setEnabled(() -> slider.getSlider().isMouseOver());
        Constraints.bind(sliderHighlight, slider.getSlider());
        return new Assembly<GuiRectangle, GuiSlider>(background, slider).addParts(sliderHighlight);
    }
}

