/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.client.event;

import dev.xylonity.knightlib.api.bossbar.BossBarContext;
import dev.xylonity.knightlib.api.camera.CameraShakeManager;
import dev.xylonity.knightlib.api.music.IBossMusicProvider;
import dev.xylonity.knightlib.api.scheduler.TickScheduler;
import dev.xylonity.knightlib.client.blockentity.renderer.GreatChaliceRenderer;
import dev.xylonity.knightlib.client.particle.StarsetParticle;
import dev.xylonity.knightlib.client.projectile.renderer.GreatChaliceStarsetRingRenderer;
import dev.xylonity.knightlib.impl.internal.BossBarApi;
import dev.xylonity.knightlib.impl.internal.BossBarLinks;
import dev.xylonity.knightlib.impl.internal.BossMusicManager;
import dev.xylonity.knightlib.impl.internal.BossMusicRegistry;
import dev.xylonity.knightlib.registry.KnightLibBlockEntities;
import dev.xylonity.knightlib.registry.KnightLibEntities;
import dev.xylonity.knightlib.registry.KnightLibParticles;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class KnightLibClientEvents {

    @Mod.EventBusSubscriber(modid="knightlib", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class KnightLibClientForgeBus {
        @SubscribeEvent(priority=EventPriority.LOW)
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            BossMusicManager.clientTick(minecraft);
            ClientLevel level = minecraft.f_91073_;
            if (level == null) {
                return;
            }
            TickScheduler.clean();
            TickScheduler.incrementTick((Level)level);
            TickScheduler.processClientTasks((Level)level);
            TickScheduler.processCommonTasks((Level)level);
        }

        @SubscribeEvent
        public static void onLevelTick(TickEvent.LevelTickEvent e) {
            if (e.phase == TickEvent.Phase.END && e.level.m_5776_()) {
                CameraShakeManager.clear();
            }
        }

        @SubscribeEvent
        public static void onCamera(ViewportEvent.ComputeCameraAngles e) {
            Entity entity = e.getCamera().m_90592_();
            if (entity instanceof Player) {
                Player p = (Player)entity;
                CameraShakeManager.applyShakeIfPresent(p, e.getCamera());
            }
        }

        @SubscribeEvent
        public static void onEntityJoin(EntityJoinLevelEvent e) {
            if (!e.getLevel().m_5776_()) {
                return;
            }
            Entity entity = e.getEntity();
            if (entity instanceof IBossMusicProvider) {
                IBossMusicProvider prov = (IBossMusicProvider)entity;
                BossMusicRegistry.register(prov);
            }
        }

        @SubscribeEvent
        public static void onEntityLeave(EntityLeaveLevelEvent e) {
            if (!e.getLevel().m_5776_()) {
                return;
            }
            Entity entity = e.getEntity();
            if (entity instanceof IBossMusicProvider) {
                IBossMusicProvider prov = (IBossMusicProvider)entity;
                BossMusicRegistry.unregister(prov);
            }
        }

        @SubscribeEvent
        public static void onWorldUnload(LevelEvent.Unload e) {
            if (e.getLevel().m_5776_()) {
                BossMusicRegistry.clear();
                BossMusicManager.clear();
            }
        }

        @SubscribeEvent
        public static void onReload(RegisterClientReloadListenersEvent e) {
            BossMusicRegistry.clear();
            BossMusicManager.clear();
        }

        @SubscribeEvent
        public static void onBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
            LerpingBossEvent boss = event.getBossEvent();
            Optional<BossBarApi.BossBarEntry> match = BossBarApi.match(boss);
            if (match.isEmpty()) {
                return;
            }
            GuiGraphics gui = event.getGuiGraphics();
            int x = event.getX();
            int y = event.getY();
            event.setCanceled(true);
            BossBarLinks.Ref reference = BossBarLinks.INSTANCE.get(boss.m_18860_());
            Entity entity = reference != null ? reference.resolve() : null;
            BossBarApi.BossBarEntry entry = match.get();
            BossBarContext ctx = new BossBarContext(boss, entity, reference != null ? reference.entityType : null);
            if (entry.renderer() != null) {
                entry.renderer().render(gui, ctx, x, y);
            } else if (entry.legacyRenderer() != null) {
                entry.legacyRenderer().render(gui, boss, x, y);
            }
            if (entry.extraYPadding() != 0) {
                event.setIncrement(event.getIncrement() + entry.extraYPadding());
            }
        }
    }

    @Mod.EventBusSubscriber(modid="knightlib", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class KnightLibClientModBus {
        @SubscribeEvent
        public static void registerEntityRenderers(FMLClientSetupEvent event) {
            EntityRenderers.m_174036_(KnightLibEntities.GREAT_CHALICE_STARSET_RING.get(), GreatChaliceStarsetRingRenderer::new);
            BlockEntityRenderers.m_173590_(KnightLibBlockEntities.GREAT_CHALICE.get(), GreatChaliceRenderer::new);
        }

        @SubscribeEvent
        public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)KnightLibParticles.STARSET.get(), StarsetParticle.Provider::new);
        }
    }
}

