/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.util.DataUtil;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.util.ExtraCodecs;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public final class BlueprintExtraCodecs {
    public static final Codec<Function<ICondition.IContext, Either<ICondition[], JsonArray>>> CONDITIONS = ExtraCodecs.f_252400_.flatXmap(element -> {
        if (!(element instanceof JsonArray)) {
            return DataResult.error(() -> "Conditions must be an array");
        }
        JsonArray array = (JsonArray)element;
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            if (array.get(i) instanceof JsonObject) continue;
            return DataResult.error(() -> "Conditions must be an array of JsonObjects");
        }
        return DataResult.success(DataUtil.memoize(context -> {
            ICondition[] iConditions = new ICondition[size];
            try {
                for (int i = 0; i < size; ++i) {
                    ICondition condition = CraftingHelper.getCondition((JsonObject)((JsonObject)array.get(i)));
                    if (!condition.test(context)) {
                        return Either.right((Object)array);
                    }
                    iConditions[i] = condition;
                }
            }
            catch (JsonParseException exception) {
                Blueprint.LOGGER.error("Failed to lazy deserialize conditions: {}", (Object)array, (Object)exception);
                return Either.right((Object)new JsonArray());
            }
            return Either.left((Object)iConditions);
        }));
    }, function -> {
        Either conditions = (Either)function.apply(ICondition.IContext.EMPTY);
        Optional unstableConditions = conditions.right();
        if (unstableConditions.isPresent()) {
            return DataResult.success((Object)((JsonArray)unstableConditions.get()));
        }
        try {
            return DataResult.success((Object)CraftingHelper.serialize((ICondition[])((ICondition[])conditions.left().get())));
        }
        catch (JsonParseException exception) {
            return DataResult.error(exception::getMessage);
        }
    });
}

