/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.registry;

import com.google.gson.JsonArray;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.common.codec.BlueprintExtraCodecs;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.holdersets.CompositeHolderSet;
import net.minecraftforge.registries.holdersets.HolderSetType;
import net.minecraftforge.registries.holdersets.ICustomHolderSet;

public final class BlueprintHolderSets {
    public static final DeferredRegister<HolderSetType> HOLDER_SET_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.HOLDER_SET_TYPES, (String)"blueprint");
    public static final RegistryObject<HolderSetType> CONDITIONAL = HOLDER_SET_TYPES.register("conditional", () -> ConditionalHolderSet::codec);

    public static <T> ConditionalHolderSet<T> conditional(HolderSet<T> value, ICondition ... conditions) {
        Either either = Either.left((Object)conditions);
        return new ConditionalHolderSet<T>(null, context -> either, value);
    }

    public static class ConditionalHolderSet<T>
    extends CompositeHolderSet<T> {
        private final HolderLookup.RegistryLookup<T> registryLookup;
        private final Function<ICondition.IContext, Either<ICondition[], JsonArray>> conditions;

        public static <T> Codec<? extends ICustomHolderSet<T>> codec(ResourceKey<? extends Registry<T>> registryKey, Codec<Holder<T>> holderCodec, boolean forceList) {
            return RecordCodecBuilder.create(builder -> builder.group((App)RegistryOps.retrieveRegistryLookup((ResourceKey)registryKey).forGetter(set -> set.registryLookup), (App)BlueprintExtraCodecs.CONDITIONS.fieldOf("conditions").forGetter(set -> set.conditions), (App)HolderSetCodec.m_206685_((ResourceKey)registryKey, (Codec)holderCodec, (boolean)forceList).fieldOf("value").forGetter(set -> (HolderSet)set.getComponents().get(0))).apply((Applicative)builder, ConditionalHolderSet::new));
        }

        public ConditionalHolderSet(HolderLookup.RegistryLookup<T> registryLookup, Function<ICondition.IContext, Either<ICondition[], JsonArray>> conditions, HolderSet<T> value) {
            super(List.of(value));
            this.registryLookup = registryLookup;
            this.conditions = conditions;
        }

        public HolderSetType type() {
            return (HolderSetType)CONDITIONAL.get();
        }

        protected Set<Holder<T>> createSet() {
            final HolderLookup.RegistryLookup<T> registryLookup = this.registryLookup;
            if (registryLookup == null) {
                return Set.of();
            }
            ICondition.IContext context = new ICondition.IContext(){

                public <CT> Map<ResourceLocation, Collection<Holder<CT>>> getAllTags(ResourceKey<? extends Registry<CT>> registryKey) {
                    return registryKey == registryLookup.m_254879_() ? registryLookup.m_214063_().collect(Collectors.toMap(key -> key.m_205839_().f_203868_(), key -> key.m_203614_().collect(Collectors.toSet()))) : Map.of();
                }
            };
            return this.conditions.apply(context).left().isPresent() ? this.getComponents().stream().flatMap(HolderSet::m_203614_).collect(Collectors.toUnmodifiableSet()) : Set.of();
        }
    }
}

