/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.gui;

import com.github.alexmodguy.alexscaves.client.gui.SpelunkeryTableScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.StringDecomposer;

public class SpelunkeryTableWordButton
extends AbstractWidget {
    public static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves", "textures/gui/spelunkery_table.png");
    private SpelunkeryTableScreen parent;
    private Font font;
    private Component glyphText;
    private Component normalText;

    public SpelunkeryTableWordButton(SpelunkeryTableScreen parent, Font font, int x, int y, int height, int width, Component text) {
        super(x, y, height, width, text);
        this.parent = parent;
        this.font = font;
        this.normalText = text.m_6879_().m_130948_(Style.f_131099_);
        this.glyphText = text.m_6881_().m_130948_(SpelunkeryTableScreen.GLYPH_FONT);
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.parent.hasTablet()) {
            return;
        }
        float revealWordsAmount = this.parent.getRevealWordsAmount(Minecraft.m_91087_().m_91296_());
        int textColor = this.f_93623_ ? 0x404040 : 0xBFBFBF;
        int revealTextColor = this.parent.isTargetWord(this) ? this.parent.getHighlightColor() : 0xBFBFBF;
        int alpha = (int)((1.0f - revealWordsAmount) * 255.0f);
        int r = textColor >> 16 & 0xFF;
        int g = textColor >> 8 & 0xFF;
        int b = textColor & 0xFF;
        int revealAlpha = (int)(revealWordsAmount * 255.0f);
        int revealR = revealTextColor >> 16 & 0xFF;
        int revealG = revealTextColor >> 8 & 0xFF;
        int revealB = revealTextColor & 0xFF;
        if (alpha >= 1) {
            this.drawEquidistantWord(this.font, guiGraphics, this.glyphText, this.m_252754_(), this.m_252907_(), FastColor.ARGB32.m_13660_((int)alpha, (int)r, (int)g, (int)b));
        }
        if (revealAlpha >= 1) {
            this.drawEquidistantWord(this.font, guiGraphics, this.normalText, this.m_252754_(), this.m_252907_(), FastColor.ARGB32.m_13660_((int)revealAlpha, (int)revealR, (int)revealG, (int)revealB));
        }
    }

    protected void m_168797_(NarrationElementOutput output) {
    }

    public int m_252754_() {
        return super.m_252754_() + this.parent.getGuiLeft();
    }

    public void m_252865_(int x) {
        super.m_252865_(x - this.parent.getGuiLeft());
    }

    public int m_252907_() {
        return super.m_252907_() + this.parent.getGuiTop();
    }

    public void m_253211_(int y) {
        super.m_253211_(y - this.parent.getGuiTop());
    }

    public void m_5716_(double x, double y) {
        if (this.parent.hasPaper()) {
            this.parent.onClickWord(this);
            this.f_93623_ = false;
        }
    }

    public void m_7435_(SoundManager soundManager) {
    }

    public Component getNormalText() {
        return this.normalText;
    }

    public void renderTranslationText(int tickCount, int textColor, GuiGraphics guiGraphics, Font font, float magnifyingXMin, float magnifyingXMax, float magnifyingYMin, float magnifyingYMax) {
        if (!this.f_93623_) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280588_((int)magnifyingXMin, (int)magnifyingYMin, (int)magnifyingXMax, (int)magnifyingYMax);
            float age = (float)(Math.sin(((float)tickCount + Minecraft.m_91087_().m_91296_()) * 0.2f) + 1.0) * 0.5f;
            int alpha = (int)(Mth.m_14036_((float)age, (float)0.1f, (float)1.0f) * 255.0f);
            int r = textColor >> 16 & 0xFF;
            int g = textColor >> 8 & 0xFF;
            int b = textColor & 0xFF;
            this.drawEquidistantWord(font, guiGraphics, this.normalText, this.m_252754_(), this.m_252907_(), FastColor.ARGB32.m_13660_((int)alpha, (int)r, (int)g, (int)b));
            guiGraphics.m_280618_();
            guiGraphics.m_280168_().m_85849_();
        }
    }

    private void drawEquidistantWord(Font font, GuiGraphics guiGraphics, Component component, int x, int y, int color) {
        int letterWidth = 6;
        StringDecomposer.m_14328_((FormattedText)component, (Style)Style.f_131099_, (position, style, j) -> {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)String.valueOf((char)j)).m_130948_(style), x + letterWidth * position, y, color, false);
            return true;
        });
    }
}

