/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity.layer;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.ClientProxy;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import com.github.alexmodguy.alexscaves.server.potion.DarknessIncarnateEffect;
import com.github.alexthe666.citadel.client.shader.PostEffectRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class ACPotionEffectLayer
extends RenderLayer {
    private static final ResourceLocation TEXTURE_BUBBLE = new ResourceLocation("alexscaves:textures/entity/deep_one/bubble.png");
    private static final ResourceLocation TEXTURE_WATER = new ResourceLocation("textures/block/water_still.png");
    public static final ResourceLocation INSIDE_BUBBLE_TEXTURE = new ResourceLocation("alexscaves", "textures/misc/inside_bubble.png");
    public static final ResourceLocation TEXTURE_DARKNESS = new ResourceLocation("alexscaves", "textures/entity/darkness_incarnate.png");
    public static final ResourceLocation TEXTURE_SUGAR_RUSH = new ResourceLocation("alexscaves", "textures/entity/sugar_rush.png");
    private RenderLayerParent parent;

    public ACPotionEffectLayer(RenderLayerParent parent) {
        super(parent);
        this.parent = parent;
    }

    public static void renderBubbledFirstPerson(PoseStack poseStack) {
        poseStack.m_85836_();
        ACPotionEffectLayer.renderBubbledFluid(Minecraft.m_91087_(), poseStack, TEXTURE_BUBBLE, false);
        ACPotionEffectLayer.renderBubbledFluid(Minecraft.m_91087_(), poseStack, INSIDE_BUBBLE_TEXTURE, true);
        poseStack.m_85849_();
    }

    public static void renderBubbledFluid(Minecraft p110726, PoseStack poseStack, ResourceLocation texture, boolean translate) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        BlockPos blockpos = BlockPos.m_274561_((double)p110726.f_91074_.m_20185_(), (double)p110726.f_91074_.m_20188_(), (double)p110726.f_91074_.m_20189_());
        float f = LightTexture.m_234316_((DimensionType)p110726.f_91074_.m_9236_().m_6042_(), (int)p110726.f_91074_.m_9236_().m_46803_(blockpos));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)f, (float)f, (float)f, (float)(translate ? 0.3f : 1.0f));
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        if (translate) {
            float f7 = -p110726.f_91074_.m_146908_() / 64.0f;
            float f8 = p110726.f_91074_.m_146909_() / 64.0f;
            bufferbuilder.m_252986_(matrix4f, -1.0f, -1.0f, -0.5f).m_7421_(4.0f + f7, 4.0f + f8).m_5752_();
            bufferbuilder.m_252986_(matrix4f, 1.0f, -1.0f, -0.5f).m_7421_(0.0f + f7, 4.0f + f8).m_5752_();
            bufferbuilder.m_252986_(matrix4f, 1.0f, 1.0f, -0.5f).m_7421_(0.0f + f7, 0.0f + f8).m_5752_();
            bufferbuilder.m_252986_(matrix4f, -1.0f, 1.0f, -0.5f).m_7421_(4.0f + f7, 0.0f + f8).m_5752_();
        } else {
            float min = -0.5f;
            float max = 1.5f;
            bufferbuilder.m_252986_(matrix4f, -1.0f, -1.0f, -0.5f).m_7421_(max, max).m_5752_();
            bufferbuilder.m_252986_(matrix4f, 1.0f, -1.0f, -0.5f).m_7421_(min, max).m_5752_();
            bufferbuilder.m_252986_(matrix4f, 1.0f, 1.0f, -0.5f).m_7421_(min, min).m_5752_();
            bufferbuilder.m_252986_(matrix4f, -1.0f, 1.0f, -0.5f).m_7421_(max, min).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public void m_6494_(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, Entity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.m_21023_((MobEffect)ACEffectRegistry.IRRADIATED.get()) && ((Boolean)AlexsCaves.CLIENT_CONFIG.radiationGlowEffect.get()).booleanValue()) {
                PostEffectRegistry.renderEffectForNextTick((ResourceLocation)ClientProxy.IRRADIATED_SHADER);
                int level = living.m_21124_((MobEffect)ACEffectRegistry.IRRADIATED.get()).m_19564_() + 1;
                VertexConsumer ivertexbuilder = bufferIn.m_6299_(level >= 4 ? ACRenderTypes.getBlueRadiationGlow(this.m_117347_(entity)) : ACRenderTypes.getRadiationGlow(this.m_117347_(entity)));
                float alpha = level >= 4 ? 0.9f : Math.min((float)level * 0.33f, 1.0f);
                poseStack.m_85836_();
                this.m_117386_().m_7695_(poseStack, ivertexbuilder, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)((LivingEntity)entity), (float)0.0f), 1.0f, 1.0f, 1.0f, alpha);
                poseStack.m_85849_();
            }
            if (living.m_21023_((MobEffect)ACEffectRegistry.BUBBLED.get()) && living.m_6084_()) {
                float bodyYaw = Mth.m_14189_((float)partialTicks, (float)living.f_20884_, (float)living.f_20883_);
                poseStack.m_85836_();
                float size = (float)Math.ceil(Math.max(living.m_20206_(), living.m_20205_()));
                poseStack.m_85837_(0.0, 1.4 - (double)(size * 0.5f), 0.0);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - bodyYaw));
                poseStack.m_85841_(1.1f, 1.1f, 1.1f);
                float waterAnimOffset = (float)Math.round((double)ageInTicks * 0.4) % 16.0f;
                ACPotionEffectLayer.renderBubble(living, partialTicks, poseStack, bufferIn.m_6299_(ACRenderTypes.getBubbledCull(TEXTURE_WATER)), size - 0.1f, packedLightIn, size * 0.5f, size * 0.5f * 0.0625f, -0.0625f * waterAnimOffset, true);
                ACPotionEffectLayer.renderBubble(living, partialTicks, poseStack, bufferIn.m_6299_(ACRenderTypes.getBubbledNoCull(TEXTURE_BUBBLE)), size, packedLightIn, 1.0f, 1.0f, 0.0f, false);
                poseStack.m_85849_();
            }
            if (living.m_21023_((MobEffect)ACEffectRegistry.DARKNESS_INCARNATE.get()) && ((Boolean)AlexsCaves.CLIENT_CONFIG.radiationGlowEffect.get()).booleanValue() && living.m_6084_()) {
                VertexConsumer ivertexbuilder = bufferIn.m_6299_(ACRenderTypes.m_110473_((ResourceLocation)this.m_117347_(entity)));
                poseStack.m_85836_();
                float alpha = DarknessIncarnateEffect.getIntensity(living, partialTicks, 25.0f);
                this.m_117386_().m_7695_(poseStack, ivertexbuilder, 0, LivingEntityRenderer.m_115338_((LivingEntity)((LivingEntity)entity), (float)0.0f), 0.0f, 0.0f, 0.0f, alpha);
                poseStack.m_85849_();
            }
            if (living.m_21023_((MobEffect)ACEffectRegistry.SUGAR_RUSH.get()) && this.m_117386_() instanceof HumanoidModel) {
                VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE_SUGAR_RUSH));
                this.m_117386_().m_7695_(poseStack, ivertexbuilder, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)((LivingEntity)entity), (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    private static void renderBubble(LivingEntity entity, float partialTicks, PoseStack poseStack, VertexConsumer consumer, float size, int packedLight, float textureScaleXZ, float textureScaleY, float uvOffset, boolean water) {
        Matrix4f cubeAt = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        float cubeStart = size * -0.5f;
        float cubeEnd = size * 0.5f;
        ACPotionEffectLayer.renderCubeFace(entity, cubeAt, matrix3f, consumer, packedLight, cubeStart, cubeEnd, cubeStart, cubeEnd, cubeEnd, cubeEnd, cubeEnd, cubeEnd, textureScaleXZ, textureScaleY, uvOffset, water);
        ACPotionEffectLayer.renderCubeFace(entity, cubeAt, matrix3f, consumer, packedLight, cubeStart, cubeEnd, cubeEnd, cubeStart, cubeStart, cubeStart, cubeStart, cubeStart, textureScaleXZ, textureScaleY, uvOffset, water);
        ACPotionEffectLayer.renderCubeFace(entity, cubeAt, matrix3f, consumer, packedLight, cubeEnd, cubeEnd, cubeEnd, cubeStart, cubeStart, cubeEnd, cubeEnd, cubeStart, textureScaleXZ, textureScaleY, uvOffset, water);
        ACPotionEffectLayer.renderCubeFace(entity, cubeAt, matrix3f, consumer, packedLight, cubeStart, cubeStart, cubeStart, cubeEnd, cubeStart, cubeEnd, cubeEnd, cubeStart, textureScaleXZ, textureScaleY, uvOffset, water);
        ACPotionEffectLayer.renderCubeFace(entity, cubeAt, matrix3f, consumer, packedLight, cubeStart, cubeEnd, cubeStart, cubeStart, cubeStart, cubeStart, cubeEnd, cubeEnd, textureScaleXZ, textureScaleY, uvOffset, water);
        ACPotionEffectLayer.renderCubeFace(entity, cubeAt, matrix3f, consumer, packedLight, cubeStart, cubeEnd, cubeEnd, cubeEnd, cubeEnd, cubeEnd, cubeStart, cubeStart, textureScaleXZ, textureScaleY, uvOffset, water);
    }

    private static void renderCubeFace(LivingEntity entity, Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer vertexConsumer, int packedLightIn, float f1, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float textureScaleXZ, float textureScaleY, float uvOffset, boolean water) {
        int colorA;
        int overlayCoords = OverlayTexture.f_118083_;
        int colorR = 255;
        int colorG = 255;
        int colorB = 255;
        int n = colorA = water ? 200 : 255;
        if (water) {
            int waterColorAt = ((Biome)entity.m_9236_().m_204166_(entity.m_20183_()).get()).m_47560_();
            colorR = waterColorAt >> 16 & 0xFF;
            colorG = waterColorAt >> 8 & 0xFF;
            colorB = waterColorAt & 0xFF;
        }
        vertexConsumer.m_252986_(matrix4f, f1, f3, f5).m_6122_(colorR, colorG, colorB, colorA).m_7421_(0.0f, textureScaleY + uvOffset).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, f2, f3, f6).m_6122_(colorR, colorG, colorB, colorA).m_7421_(textureScaleXZ, textureScaleY + uvOffset).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, f2, f4, f7).m_6122_(colorR, colorG, colorB, colorA).m_7421_(textureScaleXZ, uvOffset).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, f1, f4, f8).m_6122_(colorR, colorG, colorB, colorA).m_7421_(0.0f, uvOffset).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
    }
}

