/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GingerbreadDoorBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);

    public GingerbreadDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext context) {
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        boolean flag = (Boolean)blockState.m_61143_((Property)OPEN) == false;
        boolean flag1 = blockState.m_61143_(HINGE) == DoorHingeSide.RIGHT;
        switch (direction) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState state, LevelAccessor levelAccessor, BlockPos otherPos, BlockPos blockPos) {
        return !blockState.m_60710_((LevelReader)levelAccessor, otherPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(blockState, direction, state, levelAccessor, otherPos, blockPos);
    }

    public boolean m_7357_(BlockState blockState, BlockGetter getter, BlockPos blockPos, PathComputationType type) {
        switch (type) {
            case LAND: {
                return (Boolean)blockState.m_61143_((Property)OPEN);
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return (Boolean)blockState.m_61143_((Property)OPEN);
            }
        }
        return false;
    }

    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return (Boolean)state.m_61143_((Property)OPEN) != false ? BlockPathTypes.DOOR_WOOD_CLOSED : BlockPathTypes.DOOR_OPEN;
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        Level level = context.m_43725_();
        boolean flag = level.m_276867_(blockpos);
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HINGE, (Comparable)this.getHinge(context))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(flag));
    }

    private DoorHingeSide getHinge(BlockPlaceContext context) {
        Level blockgetter = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_8125_();
        BlockPos blockpos1 = blockpos.m_7494_();
        Direction direction1 = direction.m_122428_();
        BlockPos blockpos2 = blockpos.m_121945_(direction1);
        BlockState blockstate = blockgetter.m_8055_(blockpos2);
        BlockPos blockpos3 = blockpos1.m_121945_(direction1);
        BlockState blockstate1 = blockgetter.m_8055_(blockpos3);
        Direction direction2 = direction.m_122427_();
        BlockPos blockpos4 = blockpos.m_121945_(direction2);
        BlockState blockstate2 = blockgetter.m_8055_(blockpos4);
        BlockPos blockpos5 = blockpos1.m_121945_(direction2);
        BlockState blockstate3 = blockgetter.m_8055_(blockpos5);
        int i = (blockstate.m_60838_((BlockGetter)blockgetter, blockpos2) ? -1 : 0) + (blockstate1.m_60838_((BlockGetter)blockgetter, blockpos3) ? -1 : 0) + (blockstate2.m_60838_((BlockGetter)blockgetter, blockpos4) ? 1 : 0) + (blockstate3.m_60838_((BlockGetter)blockgetter, blockpos5) ? 1 : 0);
        boolean flag = blockstate.m_60713_((Block)this);
        boolean flag1 = blockstate2.m_60713_((Block)this);
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = direction.m_122429_();
                int k = direction.m_122431_();
                Vec3 vec3 = context.m_43720_();
                double d0 = vec3.f_82479_ - (double)blockpos.m_123341_();
                double d1 = vec3.f_82481_ - (double)blockpos.m_123343_();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        blockState = (BlockState)blockState.m_61122_((Property)OPEN);
        level.m_7731_(blockPos, blockState, 10);
        this.playSound((Entity)player, level, blockPos, (Boolean)blockState.m_61143_((Property)OPEN));
        level.m_142346_((Entity)player, this.isOpen(blockState) ? GameEvent.f_157796_ : GameEvent.f_157793_, blockPos);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.m_61143_((Property)OPEN);
    }

    public void setOpen(@javax.annotation.Nullable Entity entity, Level level, BlockState state, BlockPos blockPos, boolean open) {
        if (state.m_60713_((Block)this) && (Boolean)state.m_61143_((Property)OPEN) != open) {
            level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            this.playSound(entity, level, blockPos, open);
            level.m_142346_(entity, open ? GameEvent.f_157796_ : GameEvent.f_157793_, blockPos);
        }
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos1, boolean idk) {
        boolean flag = level.m_276867_(blockPos);
        if (!this.m_49966_().m_60713_(block) && flag != (Boolean)blockState.m_61143_((Property)POWERED)) {
            if (flag != (Boolean)blockState.m_61143_((Property)OPEN)) {
                this.playSound(null, level, blockPos, flag);
                level.m_142346_(null, flag ? GameEvent.f_157796_ : GameEvent.f_157793_, blockPos);
            }
            level.m_7731_(blockPos, (BlockState)((BlockState)blockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }

    public boolean m_7898_(BlockState blockState, LevelReader reader, BlockPos blockPos) {
        BlockPos blockpos = blockPos.m_7495_();
        BlockState blockstate = reader.m_8055_(blockpos);
        return blockstate.m_60783_((BlockGetter)reader, blockpos, Direction.UP);
    }

    private void playSound(@javax.annotation.Nullable Entity entity, Level level, BlockPos blockPos, boolean open) {
        level.m_245803_(entity, blockPos, open ? SoundEvents.f_243707_ : SoundEvents.f_244543_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return mirror == Mirror.NONE ? blockState : (BlockState)blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING))).m_61122_(HINGE);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{FACING, OPEN, HINGE, POWERED});
    }
}

