/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.ACSoundTypes;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PeppermintBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private final VoxelShape shapeUp;
    private final VoxelShape shapeDown;
    private final VoxelShape shapeEast;
    private final VoxelShape shapeWest;
    private final VoxelShape shapeSouth;
    private final VoxelShape shapeNorth;

    public PeppermintBlock(double distFromEdge, double height) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283761_).m_60999_().m_60978_(2.0f).m_60918_(ACSoundTypes.HARD_CANDY).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.UP));
        this.shapeUp = Block.m_49796_((double)distFromEdge, (double)0.0, (double)distFromEdge, (double)(16.0 - distFromEdge), (double)height, (double)(16.0 - distFromEdge));
        this.shapeDown = Block.m_49796_((double)distFromEdge, (double)(16.0 - height), (double)distFromEdge, (double)(16.0 - distFromEdge), (double)16.0, (double)(16.0 - distFromEdge));
        this.shapeEast = Block.m_49796_((double)0.0, (double)distFromEdge, (double)distFromEdge, (double)height, (double)(16.0 - distFromEdge), (double)(16.0 - distFromEdge));
        this.shapeWest = Block.m_49796_((double)(16.0 - height), (double)distFromEdge, (double)distFromEdge, (double)16.0, (double)(16.0 - distFromEdge), (double)(16.0 - distFromEdge));
        this.shapeSouth = Block.m_49796_((double)distFromEdge, (double)distFromEdge, (double)0.0, (double)(16.0 - distFromEdge), (double)(16.0 - distFromEdge), (double)height);
        this.shapeNorth = Block.m_49796_((double)distFromEdge, (double)distFromEdge, (double)(16.0 - height), (double)(16.0 - distFromEdge), (double)(16.0 - distFromEdge), (double)16.0);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(state, direction, state1, levelAccessor, blockPos, blockPos1);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case UP: {
                return this.shapeUp;
            }
            case DOWN: {
                return this.shapeDown;
            }
            case EAST: {
                return this.shapeEast;
            }
            case WEST: {
                return this.shapeWest;
            }
            case NORTH: {
                return this.shapeNorth;
            }
            case SOUTH: {
                return this.shapeSouth;
            }
        }
        return this.shapeUp;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level levelaccessor = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)FACING, (Comparable)context.m_43719_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{WATERLOGGED, FACING});
    }

    public PushReaction getPistonPushReaction(BlockState blockState) {
        return PushReaction.DESTROY;
    }
}

