/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block.blockentity;

import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.BeholderEyeEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACAdvancementTriggerRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BeholderBlockEntity
extends BlockEntity {
    private int prevUsingEntityId = -1;
    private int currentlyUsingEntityId = -1;
    private float eyeYRot;
    private float prevEyeYRot;
    private float eyeXRot;
    private float prevEyeXRot;
    public int age;
    public int soundCooldown = 40;

    public BeholderBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACBlockEntityRegistry.BEHOLDER.get(), pos, state);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, BeholderBlockEntity entity) {
        entity.prevEyeXRot = entity.eyeXRot;
        entity.prevEyeYRot = entity.eyeYRot;
        ++entity.age;
        Entity currentlyUsing = entity.getUsingEntity();
        if (currentlyUsing == null) {
            entity.eyeXRot = Mth.m_14121_((float)entity.eyeXRot, (float)0.0f, (float)10.0f);
            entity.eyeYRot += 1.0f;
        } else {
            entity.eyeXRot = Mth.m_14121_((float)entity.eyeXRot, (float)currentlyUsing.m_146909_(), (float)10.0f);
            entity.eyeYRot = Mth.m_14121_((float)entity.eyeYRot, (float)currentlyUsing.m_146908_(), (float)10.0f);
        }
        if (entity.soundCooldown-- <= 0) {
            entity.soundCooldown = level.f_46441_.m_188503_(100) + 100;
            Vec3 vec3 = entity.m_58899_().m_252807_();
            level.m_6263_((Player)null, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, entity.currentlyUsingEntityId == -1 ? (SoundEvent)ACSoundRegistry.BEHOLDER_IDLE.get() : (SoundEvent)ACSoundRegistry.BEHOLDER_VIEW_IDLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (!level.f_46443_ && entity.prevUsingEntityId != entity.currentlyUsingEntityId) {
            level.m_7260_(entity.m_58899_(), entity.m_58900_(), entity.m_58900_(), 2);
            entity.prevUsingEntityId = entity.currentlyUsingEntityId;
        }
    }

    public float getEyeXRot(float partialTicks) {
        return this.prevEyeXRot + (this.eyeXRot - this.prevEyeXRot) * partialTicks;
    }

    public Entity getUsingEntity() {
        return this.currentlyUsingEntityId == -1 ? null : this.f_58857_.m_6815_(this.currentlyUsingEntityId);
    }

    public float getEyeYRot(float partialTicks) {
        return this.prevEyeYRot + (this.eyeYRot - this.prevEyeYRot) * partialTicks;
    }

    public void startObserving(Level level, Player player) {
        BeholderEyeEntity beholderEyeEntity = (BeholderEyeEntity)((EntityType)ACEntityRegistry.BEHOLDER_EYE.get()).m_20615_(level);
        double dist = Math.sqrt(this.m_58899_().m_123331_((Vec3i)player.m_20183_()));
        if (dist > 1000.0) {
            ACAdvancementTriggerRegistry.BEHOLDER_FAR_AWAY.triggerForEntity((Entity)player);
        }
        Vec3 vec = this.m_58899_().m_252807_().m_82520_(0.0, -0.15, 0.0);
        beholderEyeEntity.m_146884_(vec);
        beholderEyeEntity.setUsingPlayerUUID(player.m_20148_());
        beholderEyeEntity.m_146922_(player.m_146908_());
        level.m_7967_((Entity)beholderEyeEntity);
        this.currentlyUsingEntityId = beholderEyeEntity.m_19879_();
        player.m_5661_((Component)Component.m_237115_((String)"item.alexscaves.occult_gem.start_observing"), true);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.currentlyUsingEntityId = tag.m_128451_("UsingEntityID");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("UsingEntityID", this.currentlyUsingEntityId);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        if (packet != null && packet.m_131708_() != null) {
            this.currentlyUsingEntityId = packet.m_131708_().m_128451_("UsingEntityID");
        }
    }

    public boolean isFirstPersonView(Entity cameraEntity) {
        return cameraEntity != null && cameraEntity instanceof BeholderEyeEntity && cameraEntity.m_20183_().equals((Object)this.m_58899_());
    }
}

