/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.server.enchantment.ACEnchantmentRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityDataRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.GumWormEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.GumWormSegmentEntity;
import com.github.alexmodguy.alexscaves.server.item.CandyCaneHookItem;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.Nullable;

public class CandyCaneHookEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Integer> OWNER_ID = SynchedEntityData.m_135353_(CandyCaneHookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> REELING = SynchedEntityData.m_135353_(CandyCaneHookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> OFFHAND = SynchedEntityData.m_135353_(CandyCaneHookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static EntityDataAccessor<Optional<Vec3>> HOOKED_POSITION = SynchedEntityData.m_135353_(CandyCaneHookEntity.class, (EntityDataSerializer)((EntityDataSerializer)ACEntityDataRegistry.OPTIONAL_VEC_3.get()));
    private static final EntityDataAccessor<Integer> HOOKED_ENTITY_ID = SynchedEntityData.m_135353_(CandyCaneHookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> HOOKED_ENTITY_UUID = SynchedEntityData.m_135353_(CandyCaneHookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(CandyCaneHookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> RESISTS_GRAVITY = SynchedEntityData.m_135353_(CandyCaneHookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;
    private boolean wasReeling = false;

    public CandyCaneHookEntity(EntityType type, Level level) {
        super(type, level);
    }

    public CandyCaneHookEntity(Player player, Level level, ItemStack itemstack, boolean offhand) {
        this((EntityType)ACEntityRegistry.CANDY_CANE_HOOK.get(), level);
        this.m_5602_((Entity)player);
        float f = player.m_146909_();
        int i = offhand ? (player.m_5737_() == HumanoidArm.RIGHT ? -1 : 1) : (player.m_5737_() == HumanoidArm.LEFT ? -1 : 1);
        float f1 = player.m_146908_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        Vec3 armOffset = new Vec3((double)((float)i * -0.45f), 0.0, 0.25).m_82524_((float)(-Math.toRadians(f1)));
        double d0 = player.m_20185_() - (double)f3 * 0.7;
        double d1 = player.m_20188_();
        double d2 = player.m_20189_() - (double)f2 * 0.7;
        this.m_7678_(d0 + armOffset.f_82479_, d1, d2 + armOffset.f_82481_, f1, f);
        Vec3 vec3 = new Vec3((double)(-f3), (double)Mth.m_14036_((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = vec3.m_82553_();
        double launchDist = 0.5 + (double)itemstack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.FAR_FLUNG.get()) * 0.2;
        vec3 = vec3.m_82542_(launchDist / d3 + 0.5 + this.f_19796_.m_188583_() * 0.0045, launchDist / d3 + 0.5 + this.f_19796_.m_188583_() * 0.0045, launchDist / d3 + 0.5 + this.f_19796_.m_188583_() * 0.0045);
        this.m_20256_(vec3);
        this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)vec3.m_165924_()) * 57.2957763671875));
        this.setOffhand(offhand);
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        this.setDamage((float)itemstack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.SHARP_CANE.get()) * 3.0f);
        if (itemstack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.STRAIGHT_HOOK.get()) > 0) {
            this.f_19804_.m_135381_(RESISTS_GRAVITY, (Object)true);
        }
    }

    public CandyCaneHookEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType)ACEntityRegistry.CANDY_CANE_HOOK.get(), world);
        this.m_20331_(true);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_6453_(double x, double y, double z, float yr, float xr, int steps, boolean b) {
        this.lx = x;
        this.ly = y;
        this.lz = z;
        this.lyr = yr;
        this.lxr = xr;
        this.lSteps = steps;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_6001_(double lerpX, double lerpY, double lerpZ) {
        this.lxd = lerpX;
        this.lyd = lerpY;
        this.lzd = lerpZ;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(OWNER_ID, (Object)-1);
        this.m_20088_().m_135372_(REELING, (Object)false);
        this.m_20088_().m_135372_(OFFHAND, (Object)false);
        this.m_20088_().m_135372_(HOOKED_POSITION, Optional.empty());
        this.m_20088_().m_135372_(HOOKED_ENTITY_ID, (Object)-1);
        this.m_20088_().m_135372_(HOOKED_ENTITY_UUID, Optional.empty());
        this.m_20088_().m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(RESISTS_GRAVITY, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        Entity owner = this.m_19749_();
        Entity hooked = this.getHookedEntity();
        Player playerOwner = this.getPlayerOwner();
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(OWNER_ID, (Object)(owner == null ? -1 : owner.m_19879_()));
            this.f_19804_.m_135381_(HOOKED_ENTITY_ID, (Object)(hooked == null ? -1 : hooked.m_19879_()));
            boolean reelingFromHook = this.isOwnerHoldingHook(false);
            if (!this.isReeling() && reelingFromHook || playerOwner != null && playerOwner.m_6144_()) {
                this.setReeling(true);
            }
            if (this.isReeling() && !reelingFromHook) {
                this.setReeling(false);
            }
            if (this.isReeling() && this.f_19797_ > 5) {
                this.f_19794_ = true;
                if (owner != null) {
                    Vec3 moveTo = owner.m_146892_().m_82546_(this.m_20182_());
                    if (moveTo.m_82553_() > 1.0) {
                        moveTo = moveTo.m_82541_();
                    } else if (moveTo.m_82553_() < (double)0.85f) {
                        this.m_146870_();
                    }
                    this.m_20256_(moveTo);
                } else {
                    this.m_146870_();
                }
            } else if (hooked != null) {
                if (!hooked.m_6084_()) {
                    this.setReeling(true);
                } else if (hooked instanceof GumWormEntity) {
                    GumWormEntity gumWorm = (GumWormEntity)hooked;
                    int i = 0;
                    if (playerOwner != null) {
                        if (this.getHandLaunchedFrom() == InteractionHand.MAIN_HAND) {
                            i = playerOwner.m_5737_() == HumanoidArm.RIGHT ? 1 : -1;
                        } else if (this.getHandLaunchedFrom() == InteractionHand.OFF_HAND) {
                            i = playerOwner.m_5737_() == HumanoidArm.LEFT ? 1 : -1;
                        }
                    }
                    this.setHookedPosition(gumWorm.getHookPosition(i));
                } else {
                    this.setHookedPosition(hooked.m_20182_().m_82520_(0.0, (double)(hooked.m_20206_() * 0.5f), 0.0));
                }
            } else {
                AABB scanForHookTo = this.m_20191_().m_82400_(1.0);
                Entity favoredToHookTo = null;
                for (Entity entity : this.m_9236_().m_6249_((Entity)this, scanForHookTo, Entity::m_6084_)) {
                    Entity entity1;
                    Entity entity2;
                    if (entity instanceof GumWormSegmentEntity) {
                        GumWormSegmentEntity gumWormSegment = (GumWormSegmentEntity)entity;
                        entity2 = gumWormSegment.getHeadEntity();
                    } else {
                        entity2 = entity;
                    }
                    if ((entity1 = entity2) == null || entity1 instanceof CandyCaneHookEntity || entity1 instanceof Projectile || owner != null && (entity1.m_7306_(owner) || favoredToHookTo != null && !(entity1.m_20270_((Entity)this) < favoredToHookTo.m_20270_((Entity)this)) && (!(entity1 instanceof GumWormEntity) || favoredToHookTo instanceof GumWormEntity))) continue;
                    favoredToHookTo = entity1;
                }
                if (favoredToHookTo != null) {
                    this.setHookedEntityUUID(favoredToHookTo.m_20148_());
                    if (this.getDamage() != 0.0f) {
                        DamageSource damageSource = this.m_269291_().m_269390_((Entity)this, owner);
                        favoredToHookTo.m_6469_(damageSource, this.getDamage());
                    }
                }
            }
            Vec3 hookedPosition = this.getHookedPosition();
            if (!this.isReeling() && hookedPosition != null) {
                this.m_146884_(hookedPosition);
            }
            if (hookedPosition == null && this.m_20096_()) {
                this.setHookedPosition(this.m_20182_());
            }
        }
        if (this.m_9236_().f_46443_) {
            if (this.lSteps > 0) {
                double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
                double d6 = this.m_20186_() + (this.ly - this.m_20186_()) / (double)this.lSteps;
                double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
                this.m_146922_(Mth.m_14177_((float)((float)this.lyr)));
                this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
                --this.lSteps;
                this.m_6034_(d5, d6, d7);
            } else {
                this.m_20090_();
            }
        } else {
            this.m_20090_();
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
        if (hooked instanceof GumWormEntity) {
            GumWormEntity gumWorm = (GumWormEntity)hooked;
            if (playerOwner != null && !this.isReeling() && !playerOwner.m_6144_()) {
                Entity d6 = gumWorm.getRidingSegment();
                if (d6 instanceof GumWormSegmentEntity) {
                    GumWormSegmentEntity gumWormSegment = (GumWormSegmentEntity)d6;
                    if (!playerOwner.m_20365_((Entity)gumWorm)) {
                        Vec3 ridePosition = gumWormSegment.getRiderPosition((Entity)playerOwner);
                        Vec3 moveVec = ridePosition.m_82546_(playerOwner.m_20182_());
                        if (!playerOwner.m_20159_()) {
                            gumWorm.onMounted();
                        }
                        if (!this.m_9236_().f_46443_ && moveVec.m_82553_() < 4.0) {
                            playerOwner.m_20329_((Entity)gumWormSegment);
                        } else {
                            if (moveVec.m_82553_() >= 1.0) {
                                moveVec = moveVec.m_82541_();
                            }
                            playerOwner.m_20256_(playerOwner.m_20184_().m_82490_((double)0.8f).m_82549_(moveVec));
                        }
                    }
                }
                gumWorm.setHookId(this.isOffhand(), this.m_19879_());
                Vec3 vec3 = gumWorm.m_20182_().m_82520_(0.0, (double)(0.5f * gumWorm.m_20205_()), 0.0).m_82546_(this.m_20182_());
                double d0 = vec3.m_165924_();
                float reelMultiX = this.isReeling() ? -1.0f : 1.0f;
                float reelAddY = this.isReeling() ? 180.0f : 0.0f;
                this.m_146926_(CandyCaneHookEntity.m_37273_((float)this.f_19860_, (float)(reelMultiX * (float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875))));
                this.m_146922_(CandyCaneHookEntity.m_37273_((float)this.f_19859_, (float)(reelAddY + (float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875))));
            }
        }
        if (this.getHookedPosition() == null || this.isReeling()) {
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(this.m_20096_() ? 0.5 : (double)0.9f));
        } else {
            this.m_20256_(Vec3.f_82478_);
        }
        if (!this.wasReeling && this.isReeling()) {
            this.wasReeling = this.isReeling();
            if (this.isOwnerHoldingHook(true)) {
                this.fling();
            }
        }
    }

    public void fling() {
        Vec3 flingFrom = this.getHookedPosition();
        Entity hooked = this.getHookedEntity();
        Entity owner = this.m_19749_();
        if (owner != null && flingFrom != null) {
            if (hooked == null) {
                Vec3 newDelta = flingFrom.m_82546_(owner.m_20182_()).m_82490_((double)0.2f);
                if (newDelta.m_82553_() > 1.0) {
                    newDelta = newDelta.m_82490_(1.0);
                }
                owner.m_20256_(newDelta.m_82520_(0.0, 0.2, 0.0).m_82549_(owner.m_20184_()));
            } else if (!(hooked instanceof GumWormEntity)) {
                Vec3 newDelta = owner.m_20182_().m_82546_(hooked.m_20182_()).m_82490_((double)0.2f);
                if (newDelta.m_82553_() > 1.0) {
                    newDelta = newDelta.m_82490_(1.0);
                }
                hooked.m_20256_(newDelta.m_82520_(0.0, 0.2, 0.0).m_82549_(hooked.m_20184_()));
            }
        }
    }

    protected void m_37283_() {
        Vec3 vec3 = this.m_20184_();
        if (vec3.m_82553_() > (double)0.1f) {
            double d0 = vec3.m_165924_();
            float reelMultiX = this.isReeling() ? -1.0f : 1.0f;
            float reelAddY = this.isReeling() ? 180.0f : 0.0f;
            this.m_146926_(CandyCaneHookEntity.m_37273_((float)this.f_19860_, (float)(reelMultiX * (float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875))));
            this.m_146922_(CandyCaneHookEntity.m_37273_((float)this.f_19859_, (float)(reelAddY + (float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875))));
        }
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        this.m_20256_(Vec3.f_82478_);
        this.setHookedPosition(entityHitResult.m_82450_());
        Entity entity = entityHitResult.m_82443_();
        if (entity instanceof GumWormSegmentEntity) {
            GumWormSegmentEntity gumWormSegment = (GumWormSegmentEntity)entity;
            entity = gumWormSegment.getHeadEntity();
        }
        this.setHookedEntityUUID(entity.m_20148_());
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        BlockState blockstate = this.m_9236_().m_8055_(blockHitResult.m_82425_());
        blockstate.m_60669_(this.m_9236_(), blockstate, blockHitResult, (Projectile)this);
        if (!this.m_9236_().f_46443_) {
            this.m_20256_(Vec3.f_82478_);
            this.setHookedPosition(blockHitResult.m_82450_());
        }
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        this.postReel();
        super.m_142687_(removalReason);
    }

    protected float m_7139_() {
        return this.isReeling() || (Boolean)this.f_19804_.m_135370_(RESISTS_GRAVITY) != false && this.m_20184_().m_165924_() > (double)0.05f ? 0.0f : 0.08f;
    }

    public InteractionHand getHandLaunchedFrom() {
        boolean offhand = this.isOffhand();
        return offhand ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    public boolean isOwnerHoldingHook(boolean ignoreReeling) {
        Player player;
        ItemStack itemStack;
        Entity entity = this.m_19749_();
        if (entity instanceof Player && (itemStack = (player = (Player)entity).m_21120_(this.getHandLaunchedFrom())).m_41720_() instanceof CandyCaneHookItem) {
            UUID hookUUID = CandyCaneHookItem.getLaunchedHookUUID(itemStack);
            return hookUUID != null && hookUUID.equals(this.m_20148_()) && (ignoreReeling || CandyCaneHookItem.isReelingIn(itemStack));
        }
        return true;
    }

    public void postReel() {
        Player player;
        ItemStack itemStack;
        Entity entity = this.m_19749_();
        if (entity instanceof Player && (itemStack = (player = (Player)entity).m_21120_(this.getHandLaunchedFrom())).m_41720_() instanceof CandyCaneHookItem) {
            CandyCaneHookItem.setLastLaunchedHookUUID(itemStack, null);
        }
    }

    private boolean isOffhand() {
        return (Boolean)this.f_19804_.m_135370_(OFFHAND);
    }

    public void setOffhand(boolean offhand) {
        this.f_19804_.m_135381_(OFFHAND, (Object)offhand);
    }

    public boolean isReeling() {
        return (Boolean)this.f_19804_.m_135370_(REELING);
    }

    public void setReeling(boolean reeling) {
        this.f_19804_.m_135381_(REELING, (Object)reeling);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public Entity m_19749_() {
        Entity prev = super.m_19749_();
        if ((Integer)this.f_19804_.m_135370_(OWNER_ID) != -1) {
            return this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(OWNER_ID)).intValue());
        }
        return prev;
    }

    public void m_5602_(@javax.annotation.Nullable Entity owner) {
        super.m_5602_(owner);
        this.f_19804_.m_135381_(OWNER_ID, (Object)(owner == null ? -1 : owner.m_19879_()));
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setReeling(tag.m_128471_("Reeling"));
        if (tag.m_128441_("HookedEntityUUID")) {
            this.setHookedEntityUUID(tag.m_128342_("HookedEntityUUID"));
        }
        this.setOffhand(tag.m_128471_("Offhand"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Reeling", this.isReeling());
        if (this.getHookedEntityUUID() != null) {
            tag.m_128362_("HookedEntityUUID", this.getHookedEntityUUID());
        }
        tag.m_128379_("Offhand", this.isOffhand());
    }

    public Entity getHookedEntity() {
        if (!this.m_9236_().f_46443_) {
            UUID id = this.getHookedEntityUUID();
            return id == null ? null : ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        int id = (Integer)this.f_19804_.m_135370_(HOOKED_ENTITY_ID);
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    public void setHookedEntityId(int id) {
        this.f_19804_.m_135381_(HOOKED_ENTITY_ID, (Object)id);
    }

    @Nullable
    public Vec3 getHookedPosition() {
        return ((Optional)this.f_19804_.m_135370_(HOOKED_POSITION)).orElse(null);
    }

    public void setHookedPosition(@Nullable Vec3 vec3) {
        this.f_19804_.m_135381_(HOOKED_POSITION, Optional.ofNullable(vec3));
    }

    @javax.annotation.Nullable
    public UUID getHookedEntityUUID() {
        return ((Optional)this.f_19804_.m_135370_(HOOKED_ENTITY_UUID)).orElse(null);
    }

    public void setHookedEntityUUID(@javax.annotation.Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(HOOKED_ENTITY_UUID, Optional.ofNullable(uniqueId));
    }

    @javax.annotation.Nullable
    public Player getPlayerOwner() {
        if (this.m_9236_().f_46443_ && (Integer)this.f_19804_.m_135370_(OWNER_ID) != -1) {
            Entity entity = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(OWNER_ID)).intValue());
            return entity instanceof Player ? (Player)entity : null;
        }
        Entity entity = this.m_19749_();
        return entity instanceof Player ? (Player)entity : null;
    }
}

