/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalRandomlySwimGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.HullbreakerInspectMobGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.HullbreakerMeleeGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.VerticalSwimmingMoveControl;
import com.github.alexmodguy.alexscaves.server.entity.item.SubmarineEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.HullbreakerPartEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.KaijuMob;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;

public class HullbreakerEntity
extends WaterAnimal
implements IAnimatedEntity,
KaijuMob {
    public static final Animation ANIMATION_PUZZLE = Animation.create((int)60);
    public static final Animation ANIMATION_BITE = Animation.create((int)20);
    public static final Animation ANIMATION_BASH = Animation.create((int)25);
    public static final Animation ANIMATION_DIE = Animation.create((int)50);
    private static final EntityDataAccessor<Integer> INTEREST_LEVEL = SynchedEntityData.m_135353_(HullbreakerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Predicate<LivingEntity> GLOWING_TARGET = mob -> {
        SubmarineEntity sub;
        Entity patt4037$temp;
        return mob.m_20072_() && (mob.m_21023_(MobEffects.f_19619_) || mob.m_6095_().m_204039_(ACTagRegistry.GLOWING_ENTITIES) || mob.m_20159_() && (patt4037$temp = mob.m_20202_()) instanceof SubmarineEntity && (sub = (SubmarineEntity)patt4037$temp).areLightsOn());
    };
    public final HullbreakerPartEntity headPart;
    public final HullbreakerPartEntity tail1Part;
    public final HullbreakerPartEntity tail2Part;
    public final HullbreakerPartEntity tail3Part;
    public final HullbreakerPartEntity tail4Part;
    private final HullbreakerPartEntity[] allParts;
    private Animation currentAnimation;
    private int animationTick;
    private float landProgress;
    private float prevLandProgress;
    private float fishPitch = 0.0f;
    private float prevFishPitch = 0.0f;
    private float pulseAmount;
    private float prevPulseAmount;
    private float[] yawBuffer = new float[128];
    private int yawPointer = -1;
    private int blockBreakCooldown = 0;
    private boolean collectedLoot = false;
    private List<ItemStack> deathItems = new ArrayList<ItemStack>();

    public HullbreakerEntity(EntityType entityType, Level level) {
        super(entityType, level);
        this.headPart = new HullbreakerPartEntity(this, (Entity)this, 3.0f, 2.0f);
        this.tail1Part = new HullbreakerPartEntity(this, (Entity)this, 2.0f, 2.0f);
        this.tail2Part = new HullbreakerPartEntity(this, (Entity)this.tail1Part, 2.0f, 1.5f);
        this.tail3Part = new HullbreakerPartEntity(this, (Entity)this.tail2Part, 2.5f, 1.5f);
        this.tail4Part = new HullbreakerPartEntity(this, (Entity)this.tail3Part, 1.5f, 1.0f);
        this.allParts = new HullbreakerPartEntity[]{this.headPart, this.tail1Part, this.tail2Part, this.tail3Part, this.tail4Part};
        this.f_21342_ = new VerticalSwimmingMoveControl((Mob)this, 0.7f, 30.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(INTEREST_LEVEL, (Object)0);
    }

    public static boolean checkHullbreakerSpawnRules(EntityType<? extends LivingEntity> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource randomSource) {
        return level.m_6425_(pos).m_205070_(FluidTags.f_13131_) && pos.m_123342_() < level.m_5736_() - 25;
    }

    public int m_5792_() {
        return 1;
    }

    public boolean m_7296_(int i) {
        return i >= this.m_5792_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new HullbreakerMeleeGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new HullbreakerInspectMobGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AnimalRandomlySwimGoal((Mob)this, 10, 35, 15, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 16.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.m_20072_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            Vec3 delta = this.m_20184_();
            this.m_6478_(MoverType.SELF, delta);
            this.m_20256_(delta.m_82490_(0.9));
        } else {
            super.m_7023_(travelVector);
        }
    }

    protected void m_5625_(float f) {
    }

    public ItemEntity m_19983_(ItemStack stack) {
        ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), stack);
        if (itementity != null) {
            if (this.headPart != null) {
                Vec3 yOnlyViewVector = new Vec3(this.m_20252_((float)1.0f).f_82479_, 0.0, this.m_20252_((float)1.0f).f_82481_);
                Vec3 mouth = this.headPart.m_20182_().m_82549_(yOnlyViewVector.m_82490_(-0.5)).m_82520_(0.0, 0.5, 0.0);
                itementity.m_146884_(mouth);
                itementity.m_20256_(yOnlyViewVector.m_82520_((double)(this.f_19796_.m_188501_() * 0.2f - 0.1f), (double)(this.f_19796_.m_188501_() * 0.2f - 0.1f), (double)(this.f_19796_.m_188501_() * 0.2f - 0.1f)).m_82541_().m_82490_((double)(0.8f + this.m_9236_().f_46441_.m_188501_() * 0.3f)));
            }
            itementity.m_146915_(true);
            itementity.m_32060_();
        }
        this.m_9236_().m_7967_((Entity)itementity);
        return itementity;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        this.setAnimation(ANIMATION_DIE);
        this.m_146926_(0.0f);
        this.m_5616_(this.m_146908_());
        if (!this.m_9236_().f_46443_) {
            if (!this.collectedLoot) {
                this.populateDeathLootForHullbreaker();
            }
            if (this.getAnimation() == ANIMATION_DIE && this.getAnimationTick() > 10 && this.getAnimationTick() % 7 == 0 && this.collectedLoot && !this.deathItems.isEmpty()) {
                ItemStack randomItem = (ItemStack)Util.m_214621_(this.deathItems, (RandomSource)this.m_217043_());
                this.m_19983_(randomItem.m_41777_());
                this.deathItems.remove(randomItem);
            }
        }
        if (this.getAnimation() == ANIMATION_DIE && this.getAnimationTick() > 45 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private void populateDeathLootForHullbreaker() {
        ResourceLocation resourcelocation = this.m_5743_();
        DamageSource damageSource = this.m_21225_();
        if (damageSource != null) {
            LootTable loottable = this.m_9236_().m_7654_().m_278653_().m_278676_(resourcelocation);
            LootParams.Builder lootparams$builder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)damageSource).m_287289_(LootContextParams.f_81458_, (Object)damageSource.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)damageSource.m_7640_());
            if (this.f_20888_ != null) {
                lootparams$builder = lootparams$builder.m_287286_(LootContextParams.f_81456_, (Object)this.f_20888_).m_287239_(this.f_20888_.m_36336_());
            }
            LootParams lootparams = lootparams$builder.m_287235_(LootContextParamSets.f_81415_);
            loottable.m_287276_(lootparams, this.m_287233_(), this.deathItems::add);
        }
        this.collectedLoot = true;
    }

    protected void m_7625_(DamageSource damageSource, boolean b) {
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.45f * dimensions.f_20378_;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11938_;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22281_, 16.0);
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        super.m_142687_(removalReason);
        if (this.allParts != null) {
            for (HullbreakerPartEntity part : this.allParts) {
                part.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    public void m_8119_() {
        double waterHeight;
        boolean grounded;
        this.tickMultipart();
        super.m_8119_();
        this.f_20883_ = Mth.m_14148_((float)this.f_20884_, (float)this.f_20883_, (float)this.m_21529_());
        this.prevLandProgress = this.landProgress;
        this.prevFishPitch = this.fishPitch;
        this.prevPulseAmount = this.pulseAmount;
        float targetFishPitch = Mth.m_14036_((float)((float)this.m_20184_().f_82480_ * 2.0f), (float)-1.4f, (float)1.4f) * -57.295776f;
        if (!this.m_6084_()) {
            targetFishPitch = 0.0f;
        }
        this.fishPitch = Mth.m_14148_((float)this.fishPitch, (float)targetFishPitch, (float)2.5f);
        boolean bl = grounded = this.m_20096_() && !this.m_20072_();
        if (grounded && this.landProgress < 5.0f) {
            this.landProgress += 1.0f;
        }
        if (!grounded && this.landProgress > 0.0f) {
            this.landProgress -= 1.0f;
        }
        float pulseBy = (float)this.getInterestLevel() * 0.45f;
        this.pulseAmount += pulseBy;
        if (!this.m_9236_().f_46443_ && (waterHeight = this.getFluidTypeHeight((FluidType)ForgeMod.WATER_TYPE.get())) > 0.0 && waterHeight < (double)(this.m_20206_() - 1.0f)) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.05, 0.0));
        }
        if (this.getAnimation() == ANIMATION_BASH && this.getAnimationTick() > 10 && this.getAnimationTick() <= 20) {
            this.breakBlock();
        }
        if (this.blockBreakCooldown > 0) {
            --this.blockBreakCooldown;
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public float getFishPitch(float partialTick) {
        return this.prevFishPitch + (this.fishPitch - this.prevFishPitch) * partialTick;
    }

    public float getLandProgress(float partialTicks) {
        return (this.prevLandProgress + (this.landProgress - this.prevLandProgress) * partialTicks) * 0.2f;
    }

    public float getPulseAmount(float partialTicks) {
        return (this.prevPulseAmount + (this.pulseAmount - this.prevPulseAmount) * partialTicks) * 0.2f;
    }

    public int getInterestLevel() {
        return (Integer)this.f_19804_.m_135370_(INTEREST_LEVEL);
    }

    public void setInterestLevel(int level) {
        this.f_19804_.m_135381_(INTEREST_LEVEL, (Object)level);
    }

    public int m_21529_() {
        return 5;
    }

    public void breakBlock() {
        if (this.blockBreakCooldown-- > 0) {
            return;
        }
        boolean flag = false;
        AABB damageBox = this.headPart.m_20191_().m_82400_((double)1.2f).m_82383_(this.m_20171_(this.m_146909_(), this.m_146908_()));
        if (!this.m_9236_().f_46443_ && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this) && this.m_5448_() instanceof Player) {
            for (int a = (int)Math.round(damageBox.f_82288_); a <= (int)Math.round(damageBox.f_82291_); ++a) {
                for (int b = (int)Math.round(damageBox.f_82289_) - 1; b <= (int)Math.round(damageBox.f_82292_) + 1 && b <= 127; ++b) {
                    for (int c = (int)Math.round(damageBox.f_82290_); c <= (int)Math.round(damageBox.f_82293_); ++c) {
                        Block block;
                        BlockPos pos = new BlockPos(a, b, c);
                        BlockState state = this.m_9236_().m_8055_(pos);
                        if (state.m_60795_() || state.m_60808_((BlockGetter)this.m_9236_(), pos).m_83281_() || state.m_204336_(ACTagRegistry.UNMOVEABLE) || !(state.m_60734_().m_7325_() <= 15.0f) || (block = state.m_60734_()) == Blocks.f_50016_) continue;
                        this.m_20256_(this.m_20184_().m_82542_((double)0.6f, 1.0, (double)0.6f));
                        flag = true;
                        this.m_9236_().m_46961_(pos, true);
                        if (!state.m_204336_(BlockTags.f_13047_)) continue;
                        this.m_9236_().m_46597_(pos, Blocks.f_49990_.m_49966_());
                    }
                }
            }
        }
        if (flag) {
            this.blockBreakCooldown = 3;
        }
    }

    private void tickMultipart() {
        if (this.yawPointer == -1) {
            for (int i = 0; i < this.yawBuffer.length; ++i) {
                this.yawBuffer[i] = this.f_20883_;
            }
        }
        if (++this.yawPointer == this.yawBuffer.length) {
            this.yawPointer = 0;
        }
        this.yawBuffer[this.yawPointer] = this.f_20883_;
        Vec3[] avector3d = new Vec3[this.allParts.length];
        for (int j = 0; j < this.allParts.length; ++j) {
            avector3d[j] = new Vec3(this.allParts[j].m_20185_(), this.allParts[j].m_20186_(), this.allParts[j].m_20189_());
        }
        Vec3 center = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() * 0.5f), 0.0);
        this.headPart.setPosCenteredY(this.rotateOffsetVec(new Vec3(0.0, 0.0, 3.5), this.fishPitch + this.m_146909_(), this.m_6080_()).m_82549_(center));
        this.tail1Part.setPosCenteredY(this.rotateOffsetVec(new Vec3(this.swimDegree(1.0f, 4.0f), 0.0, -3.5), this.fishPitch, this.getYawFromBuffer(2, 1.0f)).m_82549_(center));
        this.tail2Part.setPosCenteredY(this.rotateOffsetVec(new Vec3(this.swimDegree(1.0f, 3.0f), 0.0, -2.0), this.fishPitch, this.getYawFromBuffer(4, 1.0f)).m_82549_(this.tail1Part.centeredPosition()));
        this.tail3Part.setPosCenteredY(this.rotateOffsetVec(new Vec3(this.swimDegree(2.0f, 2.0f), 0.0, (double)-2.65f), this.fishPitch, this.getYawFromBuffer(6, 1.0f)).m_82549_(this.tail2Part.centeredPosition()));
        this.tail4Part.setPosCenteredY(this.rotateOffsetVec(new Vec3(this.swimDegree(1.5f, 1.0f), 0.0, -3.0), this.fishPitch, this.getYawFromBuffer(8, 1.0f)).m_82549_(this.tail3Part.centeredPosition()));
        for (int l = 0; l < this.allParts.length; ++l) {
            this.allParts[l].f_19854_ = avector3d[l].f_82479_;
            this.allParts[l].f_19855_ = avector3d[l].f_82480_;
            this.allParts[l].f_19856_ = avector3d[l].f_82481_;
            this.allParts[l].f_19790_ = avector3d[l].f_82479_;
            this.allParts[l].f_19791_ = avector3d[l].f_82480_;
            this.allParts[l].f_19792_ = avector3d[l].f_82481_;
        }
    }

    private double swimDegree(float width, float sinOffset) {
        double move = Math.cos(this.f_267362_.m_267756_() * 0.33f + sinOffset) * (double)this.f_267362_.m_267731_() * (double)width * (double)0.8f;
        double idle = Math.sin(((float)this.f_19797_ + AlexsCaves.PROXY.getPartialTicks()) * 0.05f + sinOffset) * (double)width * 0.5;
        return (move + idle * (double)(1.0f - this.f_267362_.m_267731_())) * (double)(1.0f - this.getLandProgress(AlexsCaves.PROXY.getPartialTicks()));
    }

    private Vec3 rotateOffsetVec(Vec3 offset, float xRot, float yRot) {
        return offset.m_82496_(-xRot * ((float)Math.PI / 180)).m_82524_(-yRot * ((float)Math.PI / 180));
    }

    public float getYawFromBuffer(int pointer, float partialTick) {
        int i = this.yawPointer - pointer & 0x7F;
        int j = this.yawPointer - pointer - 1 & 0x7F;
        float d0 = this.yawBuffer[j];
        float d1 = this.yawBuffer[i] - d0;
        return d0 + d1 * partialTick;
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(this.m_20186_() - this.f_19855_), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 3.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.allParts;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268524_)) {
            amount *= 0.65f;
        }
        return super.m_6469_(source, amount);
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PUZZLE, ANIMATION_BITE, ANIMATION_BASH, ANIMATION_DIE};
    }

    protected SoundEvent m_7515_() {
        return this.m_20072_() ? (SoundEvent)ACSoundRegistry.HULLBREAKER_IDLE.get() : (SoundEvent)ACSoundRegistry.HULLBREAKER_LAND_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return this.m_20072_() ? (SoundEvent)ACSoundRegistry.HULLBREAKER_HURT.get() : (SoundEvent)ACSoundRegistry.HULLBREAKER_LAND_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return this.m_20072_() ? (SoundEvent)ACSoundRegistry.HULLBREAKER_DEATH.get() : (SoundEvent)ACSoundRegistry.HULLBREAKER_LAND_DEATH.get();
    }

    protected float m_6121_() {
        return super.m_6121_() + 2.0f;
    }
}

