/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.AdvancedPathNavigateNoTeleport;
import com.github.alexmodguy.alexscaves.server.entity.item.CrushedBlockEntity;
import com.github.alexmodguy.alexscaves.server.entity.item.FallingTreeBlockEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.DinosaurEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.SauropodPartEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.KaijuMob;
import com.github.alexmodguy.alexscaves.server.entity.util.LuxtructosaurusLegSolver;
import com.github.alexmodguy.alexscaves.server.entity.util.MovingBlockData;
import com.github.alexmodguy.alexscaves.server.entity.util.ShakesScreen;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.ITallWalker;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class SauropodBaseEntity
extends DinosaurEntity
implements ShakesScreen,
IAnimatedEntity,
KaijuMob,
ITallWalker {
    protected static final EntityDataAccessor<Boolean> WALKING = SynchedEntityData.m_135353_(SauropodBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)15);
    public static final Animation ANIMATION_ROAR = Animation.create((int)60);
    public static final Animation ANIMATION_EPIC_DEATH = Animation.create((int)120);
    public static final Animation ANIMATION_SUMMON = Animation.create((int)120);
    public static final Animation ANIMATION_STOMP = Animation.create((int)50);
    public static final Animation ANIMATION_SPEW_FLAMES = Animation.create((int)80);
    public static final Animation ANIMATION_JUMP = Animation.create((int)45);
    public static final Animation ANIMATION_LEFT_KICK = Animation.create((int)20);
    public static final Animation ANIMATION_RIGHT_KICK = Animation.create((int)20);
    public static final Animation ANIMATION_LEFT_WHIP = Animation.create((int)40);
    public static final Animation ANIMATION_RIGHT_WHIP = Animation.create((int)40);
    public static final Animation ANIMATION_EAT_LEAVES = Animation.create((int)100);
    private static final int STOMP_CRUSH_HEIGHT = 6;
    public LuxtructosaurusLegSolver legSolver = new LuxtructosaurusLegSolver(0.2f, 2.0f, 1.2f, 1.9f, 2.0f);
    private Animation currentAnimation;
    private int animationTick;
    private final SauropodPartEntity[] allParts;
    public final SauropodPartEntity neckPart1;
    public final SauropodPartEntity neckPart2;
    public final SauropodPartEntity neckPart3;
    public final SauropodPartEntity headPart;
    public final SauropodPartEntity tailPart1;
    public final SauropodPartEntity tailPart2;
    public final SauropodPartEntity tailPart3;
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;
    private float prevWalkAnimPosition;
    private float walkAnimPosition;
    private float prevWalkAnimSpeed;
    private float walkAnimSpeed;
    private double lastStompX;
    private double lastStompZ;
    private float prevLegBackAmount = 0.0f;
    private float legBackAmount = 0.0f;
    private float prevRaiseArmsAmount = 0.0f;
    private float raiseArmsAmount = 0.0f;
    protected float neckXRot;
    protected float neckYRot;
    protected float tailXRot;
    protected float tailYRot;
    private float prevScreenShakeAmount;
    protected float screenShakeAmount;
    private float[] yawBuffer = new float[128];
    private int yawPointer = -1;
    private float lastYawBeforeWhip;
    public boolean turningFast;
    private boolean wasPreviouslyChild;
    private int stepSoundCooldown = 0;

    public SauropodBaseEntity(EntityType entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.f_21342_ = new SauropodMoveHelper();
        this.neckPart1 = new SauropodPartEntity(this, (Entity)this, 3.0f, 3.0f);
        this.neckPart2 = new SauropodPartEntity(this, (Entity)this.neckPart1, 2.0f, 2.0f);
        this.neckPart3 = new SauropodPartEntity(this, (Entity)this.neckPart2, 2.0f, 1.5f);
        this.headPart = new SauropodPartEntity(this, (Entity)this.neckPart3, 2.0f, 2.0f);
        this.tailPart1 = new SauropodPartEntity(this, (Entity)this, 3.0f, 2.0f);
        this.tailPart2 = new SauropodPartEntity(this, (Entity)this.tailPart1, 2.5f, 1.5f);
        this.tailPart3 = new SauropodPartEntity(this, (Entity)this.tailPart2, 2.0f, 1.0f);
        this.allParts = new SauropodPartEntity[]{this.neckPart1, this.neckPart2, this.neckPart3, this.headPart, this.tailPart1, this.tailPart2, this.tailPart3};
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WALKING, (Object)false);
    }

    protected PathNavigation m_6037_(Level level) {
        return new AdvancedPathNavigateNoTeleport((Mob)this, level);
    }

    public boolean isFakeEntity() {
        return this.f_19803_;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        this.prevRaiseArmsAmount = this.raiseArmsAmount;
        this.prevScreenShakeAmount = this.screenShakeAmount;
        this.legSolver.update((LivingEntity)this, this.f_20883_, this.m_6134_());
        if (this.shouldRaiseArms() && this.raiseArmsAmount < 5.0f) {
            this.raiseArmsAmount += 1.0f;
        }
        if (!this.shouldRaiseArms() && this.raiseArmsAmount > 0.0f) {
            this.raiseArmsAmount -= 1.0f;
        }
        if (this.screenShakeAmount > 0.0f) {
            this.screenShakeAmount = Math.max(0.0f, this.screenShakeAmount - 0.3f);
        }
        if (this.getAnimation() != ANIMATION_LEFT_WHIP && this.getAnimation() != ANIMATION_RIGHT_WHIP) {
            this.f_20883_ = Mth.m_14148_((float)this.f_20884_, (float)this.m_146908_(), (float)(this.turningFast ? 10.0f : 2.0f));
            this.lastYawBeforeWhip = this.m_146908_();
        } else {
            float negative = this.getAnimation() == ANIMATION_RIGHT_WHIP ? -1.0f : 1.0f;
            float target = 0.0f;
            if (this.getAnimationTick() > 10) {
                float f = (float)(this.getAnimationTick() - 10) / 30.0f;
                target = f * 230.0f;
            }
            this.f_20883_ = (float)this.getAnimationTick() > 30.0f ? Mth.m_14148_((float)this.f_20884_, (float)this.lastYawBeforeWhip, (float)15.0f) : Mth.m_14148_((float)this.f_20884_, (float)(this.lastYawBeforeWhip + negative * target), (float)90.0f);
        }
        this.tickMultipart();
        this.tickWalking();
        if (this.m_9236_().f_46443_) {
            if (this.lSteps > 0) {
                double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
                double d6 = this.m_20186_() + (this.ly - this.m_20186_()) / (double)this.lSteps;
                double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
                this.m_146922_(Mth.m_14177_((float)((float)this.lyr)));
                this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
                --this.lSteps;
                this.m_6034_(d5, d6, d7);
            } else {
                this.m_20090_();
            }
        }
        if ((this.getAnimation() == ANIMATION_STOMP && this.getAnimationTick() > 25 && this.getAnimationTick() < 35 || this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() > 5 && this.getAnimationTick() < 45) && this.screenShakeAmount <= 2.0f) {
            this.screenShakeAmount = 2.0f;
        }
        if (this.wasPreviouslyChild != this.m_6162_()) {
            this.wasPreviouslyChild = this.m_6162_();
            this.m_6210_();
            for (SauropodPartEntity sauropodPartEntity : this.allParts) {
                sauropodPartEntity.m_6210_();
            }
        }
    }

    private void tickWalking() {
        this.prevWalkAnimPosition = this.walkAnimPosition;
        this.prevWalkAnimSpeed = this.walkAnimSpeed;
        this.prevLegBackAmount = this.legBackAmount;
        float f = this.getLegSlamAmount(2.0f, 0.333f);
        float f1 = this.getLegSlamAmount(2.0f, 0.666f);
        Vec3 movement = this.m_20184_();
        float speed = (float)movement.m_82553_();
        if (this.areLegsMoving()) {
            this.walkAnimPosition += this.walkAnimSpeed;
            this.walkAnimSpeed = this.getAnimation() == ANIMATION_LEFT_WHIP || this.getAnimation() == ANIMATION_RIGHT_WHIP ? Mth.m_14121_((float)this.walkAnimSpeed, (float)4.0f, (float)0.66f) : Mth.m_14121_((float)this.walkAnimSpeed, (float)(this.m_6162_() ? 2.0f : 1.0f), (float)(this.m_6162_() ? 0.2f : 0.1f));
        } else {
            if ((double)f > 0.05) {
                this.walkAnimPosition += Math.min(f - 0.05f, this.walkAnimSpeed);
            }
            if (this.walkAnimSpeed > 0.0f) {
                this.walkAnimSpeed = Math.max(0.0f, this.walkAnimSpeed - 0.025f);
            }
        }
        if ((double)f <= 0.05 && this.walkAnimSpeed > 0.0f && this.m_20096_() && (speed > 0.003f || this.m_20160_()) && this.stepSoundCooldown <= 0) {
            this.onStep();
            this.stepSoundCooldown = 5;
        }
        if (f1 < 0.65f) {
            this.lastStompX = this.m_20185_();
            this.lastStompZ = this.m_20189_();
        }
        if (this.stepSoundCooldown > 0) {
            --this.stepSoundCooldown;
        }
        double stompX = this.m_20185_() - this.lastStompX;
        double stompZ = this.m_20189_() - this.lastStompZ;
        float stompDist = Mth.m_14116_((float)((float)(stompX * stompX + stompZ * stompZ)));
        if ((double)speed <= 0.003 || !this.areLegsMoving()) {
            stompDist = 0.0f;
        }
        if (this.getAnimation() == ANIMATION_SPEAK && this.getAnimationTick() == 2) {
            this.actuallyPlayAmbientSound();
        }
        this.legBackAmount = Mth.m_14036_((float)Mth.m_14121_((float)this.legBackAmount, (float)stompDist, (float)speed), (float)-1.0f, (float)1.0f);
    }

    protected abstract void onStep();

    public boolean shouldRaiseArms() {
        return this.isDancing() || this.getAnimation() == ANIMATION_LEFT_KICK || this.getAnimation() == ANIMATION_RIGHT_KICK || this.getAnimation() == ANIMATION_STOMP || this.getAnimation() == ANIMATION_JUMP;
    }

    private void tickMultipart() {
        if (this.yawPointer == -1) {
            for (int i = 0; i < this.yawBuffer.length; ++i) {
                this.yawBuffer[i] = this.f_20883_;
            }
        }
        if (++this.yawPointer == this.yawBuffer.length) {
            this.yawPointer = 0;
        }
        this.yawBuffer[this.yawPointer] = this.f_20883_;
        Vec3[] avector3d = new Vec3[this.allParts.length];
        for (int j = 0; j < this.allParts.length; ++j) {
            avector3d[j] = new Vec3(this.allParts[j].m_20185_(), this.allParts[j].m_20186_(), this.allParts[j].m_20189_());
        }
        float neckRotateSpeed = this.getNeckRotateSpeed();
        float tailRotateSpeed = this.getTailRotateSpeed();
        if (this.turningFast) {
            neckRotateSpeed += 30.0f;
            tailRotateSpeed += 30.0f;
        }
        this.neckXRot = this.wrapNeckDegrees(Mth.m_14148_((float)this.neckXRot, (float)this.getTargetNeckXRot(), (float)neckRotateSpeed));
        this.neckYRot = this.wrapNeckDegrees(Mth.m_14148_((float)this.neckYRot, (float)this.getTargetNeckYRot(), (float)neckRotateSpeed));
        this.tailXRot = this.wrapNeckDegrees(Mth.m_14148_((float)this.tailXRot, (float)this.getTargetTailXRot(), (float)tailRotateSpeed));
        this.tailYRot = this.wrapNeckDegrees(Mth.m_14148_((float)this.tailYRot, (float)this.getTargetTailYRot(), (float)tailRotateSpeed));
        Vec3 center = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() * 0.5f - this.getLegSolverBodyOffset()), 0.0);
        float headXStep = this.neckXRot / 4.0f;
        float headYStep = this.neckYRot / 4.0f;
        float tailXStep = this.tailXRot / 3.0f;
        float tailYStep = this.tailYRot / 3.0f;
        float neckAdditionalY = 0.0f;
        float neckAdditionalZ = 0.0f;
        if (this.getAnimation() == ANIMATION_STOMP) {
            f = ACMath.cullAnimationTick(this.getAnimationTick(), 2.0f, ANIMATION_STOMP, 1.0f, 0, 30);
            neckAdditionalY = 4.0f * f;
            neckAdditionalZ = -4.0f * f;
        } else if (this.isDancing()) {
            f = this.getDanceProgress(1.0f);
            neckAdditionalY = 4.0f * f;
            neckAdditionalZ = -4.0f * f;
            headYStep *= 1.0f - f;
        }
        this.neckPart1.setPosCenteredY(this.rotateOffsetVec(new Vec3(0.0, (double)(2.0f + neckAdditionalY), (double)(5.0f + neckAdditionalZ)).m_82490_((double)this.m_6134_()), headXStep, this.f_20883_ + headYStep).m_82549_(center));
        this.neckPart2.setPosCenteredY(this.rotateOffsetVec(new Vec3(0.0, 0.0, 2.5).m_82490_((double)this.m_6134_()), headXStep, this.f_20883_ + headYStep * 2.0f).m_82549_(this.neckPart1.centeredPosition()));
        this.neckPart3.setPosCenteredY(this.rotateOffsetVec(new Vec3(0.0, 0.0, 2.0).m_82490_((double)this.m_6134_()), headXStep, this.f_20883_ + headYStep * 3.0f).m_82549_(this.neckPart2.centeredPosition()));
        this.headPart.setPosCenteredY(this.rotateOffsetVec(new Vec3(0.0, 0.0, 2.5).m_82490_((double)this.m_6134_()), headXStep, this.f_20883_ + headYStep * 4.0f).m_82549_(this.neckPart3.centeredPosition()));
        this.tailPart1.setPosCenteredY(this.rotateOffsetVec(new Vec3(0.0, -0.5, -3.5).m_82490_((double)this.m_6134_()), tailXStep, this.f_20883_ + tailYStep).m_82549_(center));
        this.tailPart2.setPosCenteredY(this.rotateOffsetVec(new Vec3(0.0, -0.25, -3.25).m_82490_((double)this.m_6134_()), tailXStep, this.f_20883_ + tailYStep * 2.0f).m_82549_(this.tailPart1.centeredPosition()));
        this.tailPart3.setPosCenteredY(this.rotateOffsetVec(new Vec3(0.0, 0.0, -2.5).m_82490_((double)this.m_6134_()), tailXStep, this.f_20883_ + tailYStep * 3.0f).m_82549_(this.tailPart2.centeredPosition()));
        for (int l = 0; l < this.allParts.length; ++l) {
            this.allParts[l].f_19854_ = avector3d[l].f_82479_;
            this.allParts[l].f_19855_ = avector3d[l].f_82480_;
            this.allParts[l].f_19856_ = avector3d[l].f_82481_;
            this.allParts[l].f_19790_ = avector3d[l].f_82479_;
            this.allParts[l].f_19791_ = avector3d[l].f_82480_;
            this.allParts[l].f_19792_ = avector3d[l].f_82481_;
        }
    }

    private float wrapNeckDegrees(float f) {
        return f % 360.0f;
    }

    protected void crushBlocksInRing(int width, int ringStartX, int ringStartZ, float dropChance) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        float lowestFoot = 0.0f;
        for (LuxtructosaurusLegSolver.Leg leg : this.legSolver.legs) {
            float height = leg.getHeight(1.0f);
            if (!(height > lowestFoot)) continue;
            lowestFoot = height;
        }
        int feetY = this.m_20183_().m_123342_() - (int)lowestFoot;
        BlockPos center = new BlockPos(ringStartX, feetY, ringStartZ);
        if (ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this) || this.m_20160_() && this.m_6688_() instanceof Player) {
            for (int y = 0; y <= 6; ++y) {
                ArrayList<MovingBlockData> dataPerYLevel = new ArrayList<MovingBlockData>();
                int currentBlocksInChunk = 0;
                for (int i = -width - 1; i <= width + 1; ++i) {
                    for (int j = -width - 1; j <= width + 1; ++j) {
                        BlockState state;
                        mutableBlockPos.m_122178_(this.m_146903_() + i, feetY + y, this.m_146907_() + j);
                        double dist = Math.sqrt(mutableBlockPos.m_123331_((Vec3i)center));
                        if (!(dist <= (double)width) || !this.m_9236_().m_46749_((BlockPos)mutableBlockPos) || (state = this.m_9236_().m_8055_((BlockPos)mutableBlockPos)).m_204336_(ACTagRegistry.UNMOVEABLE) || state.m_60795_() || state.m_247087_() || state.m_60734_().m_7325_() > (float)((Integer)AlexsCaves.COMMON_CONFIG.atlatitanMaxExplosionResistance.get()).intValue()) continue;
                        BlockEntity te = this.m_9236_().m_7702_((BlockPos)mutableBlockPos);
                        BlockPos offset = mutableBlockPos.m_7949_().m_121996_((Vec3i)center);
                        MovingBlockData data = new MovingBlockData(state, state.m_60808_((BlockGetter)this.m_9236_(), (BlockPos)mutableBlockPos), offset, te == null ? null : te.m_187482_());
                        dataPerYLevel.add(data);
                        if (currentBlocksInChunk < 16) {
                            ++currentBlocksInChunk;
                        } else {
                            CrushedBlockEntity crushed = (CrushedBlockEntity)((EntityType)ACEntityRegistry.CRUSHED_BLOCK.get()).m_20615_(this.m_9236_());
                            crushed.m_20219_(Vec3.m_82512_((Vec3i)center.m_6630_(y)));
                            crushed.setAllBlockData(FallingTreeBlockEntity.createTagFromData(dataPerYLevel));
                            crushed.setPlacementCooldown(10);
                            crushed.setDropChance(dropChance);
                            this.m_9236_().m_7967_((Entity)crushed);
                            dataPerYLevel.clear();
                            currentBlocksInChunk = 0;
                        }
                        this.m_9236_().m_46597_((BlockPos)mutableBlockPos, Blocks.f_50016_.m_49966_());
                    }
                }
                if (dataPerYLevel.isEmpty()) continue;
                CrushedBlockEntity crushed = (CrushedBlockEntity)((EntityType)ACEntityRegistry.CRUSHED_BLOCK.get()).m_20615_(this.m_9236_());
                crushed.m_20219_(Vec3.m_82512_((Vec3i)center.m_6630_(y)));
                crushed.setAllBlockData(FallingTreeBlockEntity.createTagFromData(dataPerYLevel));
                crushed.setDropChance(dropChance);
                crushed.setPlacementCooldown(1);
                this.m_9236_().m_7967_((Entity)crushed);
            }
        }
    }

    protected Vec3 rotateOffsetVec(Vec3 offset, float xRot, float yRot) {
        return offset.m_82496_(-xRot * ((float)Math.PI / 180)).m_82524_(-yRot * ((float)Math.PI / 180));
    }

    public float getLegSolverBodyOffset() {
        float heightBackLeft = this.legSolver.backLeft.getHeight(1.0f);
        float heightBackRight = this.legSolver.backRight.getHeight(1.0f);
        float heightFrontLeft = this.legSolver.frontLeft.getHeight(1.0f);
        float heightFrontRight = this.legSolver.frontRight.getHeight(1.0f);
        float armsWalkAmount = 1.0f - this.raiseArmsAmount / 5.0f;
        return Math.max(Math.max(heightBackLeft, heightBackRight), armsWalkAmount * Math.max(heightFrontLeft, heightFrontRight)) * 0.8f;
    }

    public int m_8085_() {
        return 90;
    }

    public int m_21529_() {
        return 3;
    }

    public void m_8032_() {
        if (this.getAnimation() == NO_ANIMATION && !this.m_9236_().f_46443_) {
            this.setAnimation(ANIMATION_SPEAK);
        }
    }

    public void actuallyPlayAmbientSound() {
        SoundEvent soundevent = this.m_7515_();
        if (soundevent != null) {
            this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
        }
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.allParts;
    }

    public void m_6453_(double x, double y, double z, float yr, float xr, int steps, boolean b) {
        this.lx = x;
        this.ly = y;
        this.lz = z;
        this.lyr = yr;
        this.lxr = xr;
        this.lSteps = steps;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_6001_(double lerpX, double lerpY, double lerpZ) {
        this.lxd = lerpX;
        this.lyd = lerpY;
        this.lzd = lerpZ;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public float getYawFromBuffer(int pointer, float partialTick) {
        int i = this.yawPointer - pointer & 0x7F;
        int j = this.yawPointer - pointer - 1 & 0x7F;
        float d0 = this.yawBuffer[j];
        float d1 = this.yawBuffer[i] - d0;
        return d0 + d1 * partialTick;
    }

    public float getTargetNeckXRot() {
        if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() < 50) {
            return -140.0f;
        }
        if (this.getAnimation() == ANIMATION_EPIC_DEATH && this.getAnimationTick() < 110) {
            return -140.0f;
        }
        if (this.getAnimation() == ANIMATION_SUMMON && this.getAnimationTick() < 70) {
            return -60.0f;
        }
        if (this.getAnimation() == ANIMATION_STOMP && this.getAnimationTick() <= 30) {
            return 30.0f;
        }
        if (this.getAnimation() == ANIMATION_SPEW_FLAMES && this.getAnimationTick() < 70) {
            return 60.0f + (float)(Math.sin((float)this.animationTick * 0.4f) * 10.0);
        }
        if (this.isDancing()) {
            return 30.0f;
        }
        return -30.0f;
    }

    public float getTargetNeckYRot() {
        if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() < 50) {
            return (float)(Math.sin((float)this.animationTick * 0.2f) * 40.0);
        }
        if (this.getAnimation() == ANIMATION_EPIC_DEATH && this.getAnimationTick() < 110) {
            return (float)(Math.sin((float)this.animationTick * 0.1f) * 20.0);
        }
        if (this.getAnimation() == ANIMATION_SUMMON && this.getAnimationTick() < 50) {
            return 110.0f;
        }
        if (this.getAnimation() == ANIMATION_SPEW_FLAMES && this.getAnimationTick() < 70) {
            return (float)(Math.sin((float)this.animationTick * 0.15f) * 40.0);
        }
        float buffered = this.getYawFromBuffer(10, 1.0f) - this.f_20883_;
        return this.m_6080_() - this.f_20883_ + buffered;
    }

    private float getNeckRotateSpeed() {
        if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() < 50) {
            return 30.0f;
        }
        if (this.getAnimation() == ANIMATION_SUMMON) {
            return 2.0f;
        }
        if (this.getAnimation() == ANIMATION_SPEW_FLAMES && this.getAnimationTick() < 70) {
            return 40.0f;
        }
        if (this.getAnimation() == ANIMATION_LEFT_WHIP || this.getAnimation() == ANIMATION_RIGHT_WHIP) {
            return 30.0f;
        }
        return 10.0f;
    }

    public float getTargetTailXRot() {
        if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() < 50) {
            return -20.0f;
        }
        if (this.getAnimation() == ANIMATION_EPIC_DEATH && this.getAnimationTick() < 110) {
            return -20.0f;
        }
        if (this.getAnimation() == ANIMATION_SUMMON) {
            return -100.0f;
        }
        if (this.getAnimation() == ANIMATION_LEFT_WHIP || this.getAnimation() == ANIMATION_RIGHT_WHIP) {
            return this.getAnimationTick() > 20 ? -20.0f : 20.0f;
        }
        return 0.0f;
    }

    public float getTargetTailYRot() {
        if (this.getAnimation() == ANIMATION_LEFT_WHIP) {
            return this.getAnimationTick() > 24 ? 70.0f : -70.0f;
        }
        if (this.getAnimation() == ANIMATION_RIGHT_WHIP) {
            return this.getAnimationTick() > 24 ? -70.0f : 70.0f;
        }
        return this.getYawFromBuffer(20, 1.0f) - this.f_20883_;
    }

    private float getTailRotateSpeed() {
        return this.getAnimation() == ANIMATION_LEFT_WHIP || this.getAnimation() == ANIMATION_RIGHT_WHIP ? 30.0f : 10.0f;
    }

    public boolean areLegsMoving() {
        return ((Boolean)this.f_19804_.m_135370_(WALKING) != false || this.getAnimation() == ANIMATION_LEFT_WHIP || this.getAnimation() == ANIMATION_RIGHT_WHIP) && !this.m_6107_() && !this.m_21525_();
    }

    public float getLegSlamAmount(float speed, float offset) {
        float walkSpeed = 0.05f;
        return Math.abs((float)Math.cos((double)(this.getWalkAnimPosition(1.0f) * walkSpeed * speed) - Math.PI * (double)offset));
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public float getStepHeight() {
        return 3.2f;
    }

    public boolean hurtEntitiesAround(Vec3 center, float radius, float damageAmount, float knockbackAmount, boolean setsOnFire, boolean disablesShields) {
        AABB aabb = new AABB(center.m_82492_((double)radius, (double)radius, (double)radius), center.m_82520_((double)radius, (double)radius, (double)radius));
        boolean flag = false;
        DamageSource damageSource = this.m_269291_().m_269333_((LivingEntity)this);
        for (LivingEntity living : this.m_9236_().m_6443_(LivingEntity.class, aabb, EntitySelector.f_20406_)) {
            if (living.m_7306_((Entity)this) || living.m_7307_((Entity)this) || living.m_6095_() == this.m_6095_() || !(living.m_20275_(center.f_82479_, center.f_82480_, center.f_82481_) <= (double)(radius * radius))) continue;
            if (living.m_21275_(damageSource) && disablesShields && living instanceof Player) {
                Player player = (Player)living;
                player.m_36384_(true);
            }
            if (!living.m_6469_(damageSource, damageAmount)) continue;
            flag = true;
            if (setsOnFire) {
                living.m_20254_(10);
            }
            living.m_147240_((double)knockbackAmount, center.f_82479_ - living.m_20185_(), center.f_82481_ - living.m_20189_());
        }
        return flag;
    }

    public boolean m_6107_() {
        return super.m_6107_() || this.getAnimation() == ANIMATION_SUMMON;
    }

    @Override
    public float getScreenShakeAmount(float partialTicks) {
        if (!this.m_6084_()) {
            return 0.0f;
        }
        return this.prevScreenShakeAmount + (this.screenShakeAmount - this.prevScreenShakeAmount) * partialTicks;
    }

    public float getRaiseArmsAmount(float partialTicks) {
        return (this.prevRaiseArmsAmount + (this.raiseArmsAmount - this.prevRaiseArmsAmount) * partialTicks) * 0.2f;
    }

    public float getWalkAnimPosition(float partialTicks) {
        return this.prevWalkAnimPosition + (this.walkAnimPosition - this.prevWalkAnimPosition) * partialTicks;
    }

    public float getWalkAnimSpeed(float partialTicks) {
        return this.prevWalkAnimSpeed + (this.walkAnimSpeed - this.prevWalkAnimSpeed) * partialTicks;
    }

    public float getLegBackAmount(float partialTicks) {
        return this.prevLegBackAmount + (this.legBackAmount - this.prevLegBackAmount) * partialTicks;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SPEAK, ANIMATION_ROAR, ANIMATION_EPIC_DEATH, ANIMATION_SUMMON, ANIMATION_STOMP, ANIMATION_SPEW_FLAMES, ANIMATION_JUMP, ANIMATION_LEFT_KICK, ANIMATION_RIGHT_KICK, ANIMATION_LEFT_WHIP, ANIMATION_RIGHT_WHIP, ANIMATION_EAT_LEAVES};
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268524_)) {
            amount *= this.getProjectileDamageReduction();
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6673_(DamageSource damageSource) {
        return super.m_6673_(damageSource) || damageSource.m_276093_(DamageTypes.f_268612_);
    }

    public boolean m_6783_(double distance) {
        return Math.sqrt(distance) < 1024.0;
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82400_(2.0);
    }

    public float getProjectileDamageReduction() {
        return 0.75f;
    }

    public int getMaxNavigableDistanceToGround() {
        return 3;
    }

    private class SauropodMoveHelper
    extends MoveControl {
        public SauropodMoveHelper() {
            super((Mob)SauropodBaseEntity.this);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.WAIT) {
                SauropodBaseEntity.this.f_19804_.m_135381_(WALKING, (Object)false);
                this.f_24978_ = 0.0;
            } else {
                float threshold;
                SauropodBaseEntity.this.f_19804_.m_135381_(WALKING, (Object)true);
                float f = SauropodBaseEntity.this.getLegSlamAmount(2.0f, 0.66f);
                boolean flag = true;
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                    double d0 = this.f_24975_ - this.f_24974_.m_20185_();
                    double d1 = this.f_24977_ - this.f_24974_.m_20189_();
                    float moveToRot = (float)(Mth.m_14136_((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
                    float difference = Mth.m_14145_((float)SauropodBaseEntity.this.f_20883_, (float)moveToRot);
                    boolean bl = flag = difference < 15.0f;
                }
                if (SauropodBaseEntity.this.getAnimation() == ANIMATION_LEFT_WHIP || SauropodBaseEntity.this.getAnimation() == ANIMATION_RIGHT_WHIP) {
                    flag = true;
                }
                if (f >= (threshold = 0.65f) && flag) {
                    float f1 = (f - threshold) / (1.0f - threshold);
                    if (SauropodBaseEntity.this.m_6162_()) {
                        f1 *= 0.5f;
                    }
                    this.f_24978_ = f1;
                } else {
                    this.f_24978_ = 0.0;
                }
            }
            super.m_8126_();
        }
    }
}

