/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.item;

import com.github.alexmodguy.alexscaves.server.entity.item.CandyCaneHookEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.GumWormSegmentEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class CandyCaneHookItem
extends Item {
    public CandyCaneHookItem() {
        super(new Item.Properties().m_41503_(200));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        ItemStack itemStackOpposite = player.m_21120_(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        if (!level.f_46443_) {
            if (CandyCaneHookItem.canLaunchHook(player, itemstack, level, true, hand) && (hand == InteractionHand.MAIN_HAND || !itemStackOpposite.m_150930_((Item)this) || this.isHookLaunchedInWorld(level, itemStackOpposite))) {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ACSoundRegistry.CANDY_CANE_HOOK_LAUNCH.get(), SoundSource.NEUTRAL, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
                CandyCaneHookEntity hookEntity = new CandyCaneHookEntity(player, level, itemstack, hand == InteractionHand.OFF_HAND);
                hookEntity.m_5602_((Entity)player);
                hookEntity.setReeling(false);
                if (!level.f_46443_) {
                    level.m_7967_((Entity)hookEntity);
                }
                CandyCaneHookItem.setLastLaunchedHookUUID(itemstack, hookEntity.m_20148_());
                CandyCaneHookItem.setReelingIn(itemstack, false);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                player.m_146850_(GameEvent.f_223698_);
                player.m_6674_(hand);
                return InteractionResultHolder.m_19096_((Object)itemstack);
            }
            if (!(player.m_20201_() instanceof GumWormSegmentEntity) && (!itemStackOpposite.m_150930_((Item)this) || CandyCaneHookItem.isActive(itemStackOpposite)) && CandyCaneHookItem.isActive(itemstack)) {
                if (itemStackOpposite.m_150930_((Item)this) && CandyCaneHookItem.isActive(itemStackOpposite) && !CandyCaneHookItem.isReelingIn(itemStackOpposite)) {
                    CandyCaneHookItem.setReelingIn(itemStackOpposite, true);
                    if (!level.f_46443_) {
                        itemStackOpposite.m_41622_(1, (LivingEntity)player, stac -> stac.m_21190_(hand));
                    }
                }
                if (!CandyCaneHookItem.isReelingIn(itemstack)) {
                    CandyCaneHookItem.setReelingIn(itemstack, true);
                    if (!level.f_46443_) {
                        itemstack.m_41622_(1, (LivingEntity)player, stac -> stac.m_21190_(hand));
                    }
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ACSoundRegistry.CANDY_CANE_HOOK_REEL.get(), SoundSource.NEUTRAL, 1.0f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
                    player.m_146850_(GameEvent.f_223697_);
                    return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
                }
            }
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    private boolean isHookLaunchedInWorld(Level level, ItemStack stack) {
        if (CandyCaneHookItem.isActive(stack)) {
            CompoundTag compoundTag = stack.m_41784_();
            if (level instanceof ServerLevel) {
                Entity entity;
                ServerLevel serverLevel = (ServerLevel)level;
                if (compoundTag.m_128441_("LastLaunchedHookUUID") && compoundTag.m_128441_("LastLaunchedHookUUID") && (entity = serverLevel.m_8791_(compoundTag.m_128342_("LastLaunchedHookUUID"))) instanceof CandyCaneHookEntity) {
                    CandyCaneHookEntity candyCaneHook = (CandyCaneHookEntity)entity;
                    return candyCaneHook.m_6084_() && candyCaneHook.f_19797_ > 0;
                }
            }
        }
        return false;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean held) {
        super.m_6883_(stack, level, entity, i, held);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.f_46443_ && stack != player.m_6844_(EquipmentSlot.MAINHAND) && stack != player.m_6844_(EquipmentSlot.OFFHAND) && CandyCaneHookItem.isActive(stack)) {
                if (!CandyCaneHookItem.isReelingIn(stack)) {
                    CandyCaneHookItem.setReelingIn(stack, true);
                }
                if (CandyCaneHookItem.canLaunchHook(player, stack, level, false, InteractionHand.MAIN_HAND)) {
                    CandyCaneHookItem.setLastLaunchedHookUUID(stack, null);
                }
            }
        }
    }

    public static boolean isActive(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41783_();
        return compoundtag != null && compoundtag.m_128441_("LastLaunchedHookUUID");
    }

    @Nullable
    public static UUID getLaunchedHookUUID(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41783_();
        if (compoundtag != null && compoundtag.m_128441_("LastLaunchedHookUUID")) {
            return compoundtag.m_128342_("LastLaunchedHookUUID");
        }
        return null;
    }

    public static void setLastLaunchedHookUUID(ItemStack itemStack, @Nullable UUID uuid) {
        CompoundTag compoundtag = itemStack.m_41784_();
        if (uuid == null) {
            compoundtag.m_128473_("LastLaunchedHookUUID");
        } else {
            compoundtag.m_128362_("LastLaunchedHookUUID", uuid);
        }
        itemStack.m_41751_(compoundtag);
    }

    public static boolean isReelingIn(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41783_();
        return CandyCaneHookItem.isActive(itemStack) && compoundtag != null && compoundtag.m_128471_("Reeling");
    }

    public static void setReelingIn(ItemStack itemStack, boolean reeling) {
        CompoundTag compoundtag = itemStack.m_41784_();
        compoundtag.m_128379_("Reeling", reeling);
        itemStack.m_41751_(compoundtag);
    }

    public static boolean canLaunchHook(Player player, ItemStack itemStack, Level level, boolean checkHands, InteractionHand hand) {
        CompoundTag compoundtag = itemStack.m_41784_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (compoundtag.m_128441_("LastLaunchedHookUUID") && compoundtag.m_128441_("LastLaunchedHookUUID")) {
                Entity entity = serverLevel.m_8791_(compoundtag.m_128342_("LastLaunchedHookUUID"));
                if (entity instanceof CandyCaneHookEntity) {
                    CandyCaneHookEntity candyCaneHook = (CandyCaneHookEntity)entity;
                    return !candyCaneHook.m_6084_() || candyCaneHook.m_19749_() == null || !candyCaneHook.m_19749_().m_7306_((Entity)player) || checkHands && hand != candyCaneHook.getHandLaunchedFrom();
                }
                return true;
            }
        }
        return true;
    }

    public int m_6473_() {
        return 1;
    }

    public boolean m_8120_(ItemStack stack) {
        return stack.m_41613_() == 1;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction == ToolActions.FISHING_ROD_CAST || super.canPerformAction(stack, toolAction);
    }
}

