/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.item;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.enchantment.ACEnchantmentRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.GumballEntity;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.item.AlwaysCombinableOnAnvil;
import com.github.alexmodguy.alexscaves.server.item.UpdatesStackTags;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class ShotGumItem
extends Item
implements UpdatesStackTags,
AlwaysCombinableOnAnvil {
    public static final Predicate<ItemStack> AMMO = stack -> stack.m_41720_() == ((Item)ACItemRegistry.GUMBALL_PILE.get()).m_5456_();
    public static final int MAX_AMMO = 4;

    public ShotGumItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)AlexsCaves.PROXY.getISTERProperties());
    }

    public int m_6473_() {
        return 1;
    }

    public boolean m_8120_(ItemStack stack) {
        return stack.m_41613_() == 1;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_((Item)ACItemRegistry.SHOT_GUM.get()) || !newStack.m_150930_((Item)ACItemRegistry.SHOT_GUM.get());
    }

    public static float getLerpedShootTime(ItemStack stack, float f) {
        CompoundTag compoundtag = stack.m_41783_();
        float prev = compoundtag != null ? (float)compoundtag.m_128451_("PrevShootTime") : 0.0f;
        float current = compoundtag != null ? (float)compoundtag.m_128451_("ShootTime") : 0.0f;
        return prev + f * (current - prev);
    }

    public static float getLerpedCrankAngle(ItemStack stack, float f) {
        CompoundTag compoundtag = stack.m_41783_();
        float prev = compoundtag != null ? compoundtag.m_128457_("PrevCrankAngle") : 0.0f;
        float current = compoundtag != null ? compoundtag.m_128457_("CrankAngle") : 0.0f;
        return prev + f * (current - prev);
    }

    public static int getShootTime(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null ? compoundtag.m_128451_("ShootTime") : 0;
    }

    public static void setShootTime(ItemStack stack, int i) {
        CompoundTag compoundtag = stack.m_41784_();
        compoundtag.m_128405_("ShootTime", i);
    }

    public static float getCrankAngle(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null ? compoundtag.m_128457_("CrankAngle") : 0.0f;
    }

    public static void setCrankAngle(ItemStack stack, float angle) {
        CompoundTag compoundtag = stack.m_41784_();
        compoundtag.m_128350_("CrankAngle", angle);
    }

    public static int getGumballsLeft(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null && compoundtag.m_128441_("Gumballs") ? compoundtag.m_128451_("Gumballs") : 4;
    }

    public static void setGumballsLeft(ItemStack stack, int i) {
        CompoundTag compoundtag = stack.m_41784_();
        compoundtag.m_128405_("Gumballs", i);
    }

    public static boolean isShooting(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null && compoundtag.m_128471_("Shooting");
    }

    public static void setShooting(ItemStack stack, boolean shooting) {
        CompoundTag compoundtag = stack.m_41784_();
        compoundtag.m_128379_("Shooting", shooting);
    }

    public static boolean hasAmmo(ItemStack stack) {
        return ShotGumItem.getGumballsLeft(stack) > 0;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        if (ShotGumItem.hasAmmo(itemstack)) {
            if (ShotGumItem.getShootTime(itemstack) == 0 && !ShotGumItem.isShooting(itemstack)) {
                ShotGumItem.setShooting(itemstack, true);
            }
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        ItemStack ammo = this.findAmmo(player);
        boolean flag = player.m_7500_();
        if (!ammo.m_41619_()) {
            ammo.m_41774_(1);
            flag = true;
        }
        if (flag) {
            ShotGumItem.setGumballsLeft(itemstack, 4);
            player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ACSoundRegistry.SHOTGUM_RELOAD.get(), player.m_5720_(), 1.0f, 1.0f);
        } else {
            player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ACSoundRegistry.SHOTGUM_EMPTY.get(), player.m_5720_(), 1.0f, 1.0f);
        }
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean held) {
        super.m_6883_(stack, level, entity, i, held);
        boolean shooting = ShotGumItem.isShooting(stack);
        int shootTime = ShotGumItem.getShootTime(stack);
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128451_("PrevShootTime") != tag.m_128451_("ShootTime")) {
            tag.m_128405_("PrevShootTime", ShotGumItem.getShootTime(stack));
        }
        if (tag.m_128457_("PrevCrankAngle") != tag.m_128457_("CrankAngle")) {
            tag.m_128350_("PrevCrankAngle", ShotGumItem.getCrankAngle(stack));
        }
        if (shootTime == 5 && shooting) {
            Player player;
            level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ACSoundRegistry.SHOTGUM_SHOOT.get(), entity.m_5720_(), 1.0f, 1.0f);
            ShotGumItem.setShooting(stack, false);
            boolean leftHand = false;
            boolean ricochetEnchant = stack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.TARGETED_RICOCHET.get()) > 0;
            boolean splitEnchant = stack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.TRIPLE_SPLIT.get()) > 0;
            boolean explosiveEnchant = stack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.EXPLOSIVE_FLAVOR.get()) > 0;
            int maximumBounces = 4 + stack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.BOUNCY_BALL.get()) * 2;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                boolean mainHand = living.m_21120_(InteractionHand.MAIN_HAND) == stack;
                boolean offHand = living.m_21120_(InteractionHand.OFF_HAND) == stack;
                leftHand = mainHand && living.m_5737_() == HumanoidArm.LEFT || offHand && living.m_5737_() == HumanoidArm.RIGHT;
                for (int gumballs = 0; gumballs < (explosiveEnchant ? 1 : 2); ++gumballs) {
                    GumballEntity gumballEntity = new GumballEntity(level, living);
                    Vec3 relativePos = new Vec3((double)((explosiveEnchant ? 0.0f : (gumballs < 1 ? 0.15f : -0.15f)) + (leftHand ? 0.35f : -0.35f)), 0.0, 0.75).m_82496_(-entity.m_146909_() * ((float)Math.PI / 180)).m_82524_(-entity.m_6080_() * ((float)Math.PI / 180));
                    Vec3 gumballPos = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() * 0.8f), 0.0).m_82549_(relativePos);
                    gumballEntity.m_146884_(gumballPos);
                    gumballEntity.setTargetsOnBounce(ricochetEnchant);
                    gumballEntity.setSplitsOnHit(splitEnchant);
                    gumballEntity.setExplosive(explosiveEnchant);
                    gumballEntity.m_37251_(entity, entity.m_146909_(), entity.m_146908_(), 0.0f, explosiveEnchant ? 0.5f : 1.5f, 5.0f);
                    gumballEntity.setMaximumBounces(maximumBounces);
                    gumballEntity.setDamage(4.0f);
                    if (level.f_46443_) continue;
                    level.m_7967_((Entity)gumballEntity);
                }
            }
            if (!(entity instanceof Player) || !(player = (Player)entity).m_7500_()) {
                ShotGumItem.setGumballsLeft(stack, Math.max(ShotGumItem.getGumballsLeft(stack) - 1, 0));
            }
        }
        if (shooting && shootTime < 5) {
            ShotGumItem.setShootTime(stack, shootTime + 1);
        }
        if (!shooting && shootTime > 0) {
            ShotGumItem.setShootTime(stack, shootTime - 1);
        }
        if (shooting) {
            ShotGumItem.setCrankAngle(stack, ShotGumItem.getCrankAngle(stack) + 45.0f);
        }
    }

    public static boolean shouldBeHeldUpright(ItemStack itemStack) {
        return ShotGumItem.hasAmmo(itemStack);
    }

    private ItemStack findAmmo(Player entity) {
        if (entity.m_7500_()) {
            return ItemStack.f_41583_;
        }
        for (int i = 0; i < entity.m_150109_().m_6643_(); ++i) {
            ItemStack itemstack1 = entity.m_150109_().m_8020_(i);
            if (!AMMO.test(itemstack1)) continue;
            return itemstack1;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_142522_(ItemStack stack) {
        return ShotGumItem.getGumballsLeft(stack) != 4;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round((float)ShotGumItem.getGumballsLeft(stack) * 13.0f / 4.0f);
    }

    public int m_142159_(ItemStack stack) {
        return 0xFF9FFF;
    }
}

