/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure.piece;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.FluidState;

public abstract class UndergroundTemplateStructurePiece
extends TemplateStructurePiece {
    private boolean placedInCaveFlag;
    private BlockPos centeredPos;

    public UndergroundTemplateStructurePiece(StructurePieceType structurePieceType, int i, StructureTemplateManager structureTemplateManager, ResourceLocation resourceLocation, String id, StructurePlaceSettings settings, BlockPos blockPos) {
        super(structurePieceType, i, structureTemplateManager, resourceLocation, id, settings, blockPos);
    }

    public UndergroundTemplateStructurePiece(StructurePieceType structurePieceType, CompoundTag compoundTag, StructureTemplateManager structureTemplateManager, Function<ResourceLocation, StructurePlaceSettings> function) {
        super(structurePieceType, compoundTag, structureTemplateManager, function);
        this.placedInCaveFlag = compoundTag.m_128471_("PlacedInCave");
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        super.m_183620_(context, tag);
        tag.m_128379_("PlacedInCave", this.placedInCaveFlag);
    }

    public void m_213694_(WorldGenLevel worldGenLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos) {
        if (!this.placedInCaveFlag) {
            int originalY = this.f_73658_.m_123342_();
            BlockPos structureCenter = StructureTemplate.m_74593_((BlockPos)new BlockPos(this.f_73656_.m_163801_().m_123341_() / 2, 0, this.f_73656_.m_163801_().m_123343_() / 2), (Mirror)Mirror.NONE, (Rotation)this.f_73657_.m_74404_(), (BlockPos)BlockPos.f_121853_).m_121955_((Vec3i)this.f_73658_);
            BlockPos cavePos = this.getCaveHeight(structureCenter, worldGenLevel, randomSource);
            this.f_73658_ = new BlockPos(this.f_73658_.m_123341_(), cavePos.m_123342_(), this.f_73658_.m_123343_());
            if (this.sinkByEdges()) {
                BlockPos structureEdge = StructureTemplate.m_74593_((BlockPos)new BlockPos(this.f_73656_.m_163801_().m_123341_() - 1, 0, this.f_73656_.m_163801_().m_123343_() - 1), (Mirror)Mirror.NONE, (Rotation)this.f_73657_.m_74404_(), (BlockPos)BlockPos.f_121853_).m_121955_((Vec3i)this.f_73658_);
                this.f_73658_ = new BlockPos(this.f_73658_.m_123341_(), this.getHeight(this.f_73658_, (BlockGetter)worldGenLevel, structureEdge), this.f_73658_.m_123343_());
            }
            if (this.f_73658_.m_123342_() > chunkGenerator.m_6337_() - this.minimumDepthBeneathSurface()) {
                this.f_73658_ = this.f_73658_.m_175288_(-256);
            }
            this.f_73658_ = this.f_73658_.m_6625_(this.moveDownBy());
            this.f_73383_.m_162367_(0, this.f_73658_.m_123342_() - originalY, 0);
            this.placedInCaveFlag = true;
            this.centeredPos = structureCenter.m_175288_(this.f_73658_.m_123342_());
        }
        if (this.f_73658_.m_123342_() >= worldGenLevel.m_141937_()) {
            super.m_213694_(worldGenLevel, structureManager, chunkGenerator, randomSource, boundingBox, chunkPos, pos);
        }
    }

    private int getHeight(BlockPos leftMostCornerPos, BlockGetter level, BlockPos rightMostCornerPos) {
        int j = 512;
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)leftMostCornerPos, (BlockPos)rightMostCornerPos)) {
            int x = blockpos.m_123341_();
            int y = leftMostCornerPos.m_123342_() - 1;
            int z = blockpos.m_123343_();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(x, y, z);
            BlockState blockstate = level.m_8055_((BlockPos)blockpos$mutableblockpos);
            FluidState fluidstate = level.m_6425_((BlockPos)blockpos$mutableblockpos);
            while ((blockstate.m_60795_() || fluidstate.m_205070_(FluidTags.f_13131_) || blockstate.m_204336_(BlockTags.f_13047_)) && y > level.m_141937_() + 1) {
                blockpos$mutableblockpos.m_122178_(x, --y, z);
                blockstate = level.m_8055_((BlockPos)blockpos$mutableblockpos);
                fluidstate = level.m_6425_((BlockPos)blockpos$mutableblockpos);
            }
            j = Math.min(j, y);
        }
        return j;
    }

    protected BlockPos getCaveHeight(BlockPos currentStructureCenter, WorldGenLevel level, RandomSource randomSource) {
        ArrayList<Object> possibilities = new ArrayList<Object>();
        int j = 0;
        int seaLevel = Math.max(level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, currentStructureCenter.m_123341_(), currentStructureCenter.m_123343_()), 63);
        BlockPos.MutableBlockPos chunkCenter = new BlockPos.MutableBlockPos(currentStructureCenter.m_123341_(), level.m_141937_() + 3, currentStructureCenter.m_123343_());
        while (chunkCenter.m_123342_() < seaLevel - this.minimumDepthBeneathSurface()) {
            BlockState currentState = level.m_8055_((BlockPos)chunkCenter);
            chunkCenter.m_122184_(0, 1, 0);
            BlockState nextState = level.m_8055_((BlockPos)chunkCenter);
            if (!this.canReplace(currentState) && this.canReplace(nextState) && this.canGenerateOn(currentState)) {
                possibilities.add(chunkCenter.m_7949_().m_7495_());
            }
            ++j;
        }
        if (possibilities.isEmpty()) {
            return this.discardIfNotOnGround() ? currentStructureCenter.m_175288_(-256) : currentStructureCenter;
        }
        if (this.placeInHighestCave() && possibilities.size() > 1) {
            possibilities.sort(Comparator.comparingInt(Vec3i::m_123342_).reversed());
            return (BlockPos)possibilities.get(0);
        }
        return possibilities.size() <= 1 ? (BlockPos)possibilities.get(0) : (BlockPos)possibilities.get(randomSource.m_188503_(possibilities.size() - 1));
    }

    public boolean placeInHighestCave() {
        return false;
    }

    protected boolean canReplace(BlockState state) {
        return state.m_60795_() || state.m_247087_();
    }

    public boolean canGenerateOn(BlockState state) {
        return true;
    }

    public boolean sinkByEdges() {
        return true;
    }

    public boolean discardIfNotOnGround() {
        return false;
    }

    public int minimumDepthBeneathSurface() {
        return 15;
    }

    public int moveDownBy() {
        return 0;
    }

    public BlockPos getCenteredPos() {
        return this.centeredPos;
    }
}

