/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox;

import com.progwml6.ironshulkerbox.client.render.IronShulkerBoxRenderer;
import com.progwml6.ironshulkerbox.client.screen.IronShulkerBoxScreen;
import com.progwml6.ironshulkerbox.common.block.AbstractIronShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.CopperShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.CrystalShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.DiamondShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.GoldShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.IronShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.IronShulkerBoxesTypes;
import com.progwml6.ironshulkerbox.common.block.ObsidianShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.creativetabs.IronShulkerBoxesCreativeTabs;
import com.progwml6.ironshulkerbox.common.data.IronShulkerBoxesBlockTags;
import com.progwml6.ironshulkerbox.common.data.IronShulkerBoxesLanguageProvider;
import com.progwml6.ironshulkerbox.common.data.IronShulkerBoxesRecipeProvider;
import com.progwml6.ironshulkerbox.common.data.IronShulkerBoxesSpriteSourceProvider;
import com.progwml6.ironshulkerbox.common.data.loot.IronShulkerBoxesLootTableProvider;
import com.progwml6.ironshulkerbox.common.network.IronShulkerBoxesNetwork;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesBlockEntityTypes;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesBlocks;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesItems;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesMenuTypes;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesRecipes;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShulkerBoxDispenseBehavior;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="ironshulkerbox")
public class IronShulkerBoxes {
    public static final String MOD_ID = "ironshulkerbox";
    private static CauldronInteraction SHULKER_BOX = (blockState, level, blockPos, player, interactionHand, itemStack) -> {
        Block block = Block.m_49814_((Item)itemStack.m_41720_());
        if (!(block instanceof AbstractIronShulkerBoxBlock)) {
            return InteractionResult.PASS;
        }
        AbstractIronShulkerBoxBlock shulkerBoxBlock = (AbstractIronShulkerBoxBlock)block;
        if (!level.f_46443_) {
            IronShulkerBoxesTypes type = AbstractIronShulkerBoxBlock.getTypeFromBlock(block);
            ItemStack itemstack = new ItemStack((ItemLike)Blocks.f_50456_);
            if (type != null) {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case IRON: {
                        ItemStack itemStack2 = new ItemStack((ItemLike)IronShulkerBoxesBlocks.IRON_SHULKER_BOX.get());
                        break;
                    }
                    case GOLD: {
                        ItemStack itemStack2 = new ItemStack((ItemLike)IronShulkerBoxesBlocks.GOLD_SHULKER_BOX.get());
                        break;
                    }
                    case DIAMOND: {
                        ItemStack itemStack2 = new ItemStack((ItemLike)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOX.get());
                        break;
                    }
                    case COPPER: {
                        ItemStack itemStack2 = new ItemStack((ItemLike)IronShulkerBoxesBlocks.COPPER_SHULKER_BOX.get());
                        break;
                    }
                    case CRYSTAL: {
                        ItemStack itemStack2 = new ItemStack((ItemLike)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOX.get());
                        break;
                    }
                    case OBSIDIAN: {
                        ItemStack itemStack2 = new ItemStack((ItemLike)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOX.get());
                        break;
                    }
                    case VANILLA: {
                        ItemStack itemStack2 = itemstack = new ItemStack((ItemLike)Blocks.f_50456_);
                    }
                }
            }
            if (itemStack.m_41782_()) {
                itemstack.m_41751_(itemStack.m_41783_().m_6426_());
            }
            player.m_21008_(interactionHand, itemstack);
            player.m_36220_(Stats.f_12947_);
            LayeredCauldronBlock.m_153559_((BlockState)blockState, (Level)level, (BlockPos)blockPos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    };

    public IronShulkerBoxes() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::setup);
        modBus.addListener(this::gatherData);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modBus.addListener(this::setupClient));
        IronShulkerBoxesNetwork.setup();
        IronShulkerBoxesBlocks.BLOCKS.register(modBus);
        IronShulkerBoxesItems.ITEMS.register(modBus);
        IronShulkerBoxesBlockEntityTypes.BLOCK_ENTITIES.register(modBus);
        IronShulkerBoxesMenuTypes.MENU_TYPES.register(modBus);
        IronShulkerBoxesRecipes.RECIPE_SERIALIZERS.register(modBus);
        IronShulkerBoxesCreativeTabs.CREATIVE_MODE_TABS.register(modBus);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setupClient(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)IronShulkerBoxesMenuTypes.IRON_SHULKER_BOX.get()), IronShulkerBoxScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)IronShulkerBoxesMenuTypes.GOLD_SHULKER_BOX.get()), IronShulkerBoxScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)IronShulkerBoxesMenuTypes.DIAMOND_SHULKER_BOX.get()), IronShulkerBoxScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)IronShulkerBoxesMenuTypes.CRYSTAL_SHULKER_BOX.get()), IronShulkerBoxScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)IronShulkerBoxesMenuTypes.COPPER_SHULKER_BOX.get()), IronShulkerBoxScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)IronShulkerBoxesMenuTypes.OBSIDIAN_SHULKER_BOX.get()), IronShulkerBoxScreen::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.IRON_SHULKER_BOX.get()), IronShulkerBoxRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.GOLD_SHULKER_BOX.get()), IronShulkerBoxRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.DIAMOND_SHULKER_BOX.get()), IronShulkerBoxRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.CRYSTAL_SHULKER_BOX.get()), IronShulkerBoxRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.COPPER_SHULKER_BOX.get()), IronShulkerBoxRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)IronShulkerBoxesBlockEntityTypes.OBSIDIAN_SHULKER_BOX.get()), IronShulkerBoxRenderer::new);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            DispenserBlock.m_52672_((ItemLike)((IronShulkerBoxBlock)((Object)((Object)IronShulkerBoxesBlocks.IRON_SHULKER_BOX.get()))).m_5456_(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
            DispenserBlock.m_52672_((ItemLike)((GoldShulkerBoxBlock)((Object)((Object)IronShulkerBoxesBlocks.GOLD_SHULKER_BOX.get()))).m_5456_(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
            DispenserBlock.m_52672_((ItemLike)((DiamondShulkerBoxBlock)((Object)((Object)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOX.get()))).m_5456_(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
            DispenserBlock.m_52672_((ItemLike)((CopperShulkerBoxBlock)((Object)((Object)IronShulkerBoxesBlocks.COPPER_SHULKER_BOX.get()))).m_5456_(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
            DispenserBlock.m_52672_((ItemLike)((CrystalShulkerBoxBlock)((Object)((Object)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOX.get()))).m_5456_(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
            DispenserBlock.m_52672_((ItemLike)((ObsidianShulkerBoxBlock)((Object)((Object)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOX.get()))).m_5456_(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
            for (DyeColor color : DyeColor.values()) {
                CauldronInteraction.f_175607_.put(((IronShulkerBoxBlock)((Object)((Object)((RegistryObject)IronShulkerBoxesBlocks.IRON_SHULKER_BOXES.get((Object)color)).get()))).m_5456_(), SHULKER_BOX);
                CauldronInteraction.f_175607_.put(((GoldShulkerBoxBlock)((Object)((Object)((RegistryObject)IronShulkerBoxesBlocks.GOLD_SHULKER_BOXES.get((Object)color)).get()))).m_5456_(), SHULKER_BOX);
                CauldronInteraction.f_175607_.put(((DiamondShulkerBoxBlock)((Object)((Object)((RegistryObject)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOXES.get((Object)color)).get()))).m_5456_(), SHULKER_BOX);
                CauldronInteraction.f_175607_.put(((CopperShulkerBoxBlock)((Object)((Object)((RegistryObject)IronShulkerBoxesBlocks.COPPER_SHULKER_BOXES.get((Object)color)).get()))).m_5456_(), SHULKER_BOX);
                CauldronInteraction.f_175607_.put(((CrystalShulkerBoxBlock)((Object)((Object)((RegistryObject)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOXES.get((Object)color)).get()))).m_5456_(), SHULKER_BOX);
                CauldronInteraction.f_175607_.put(((ObsidianShulkerBoxBlock)((Object)((Object)((RegistryObject)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOXES.get((Object)color)).get()))).m_5456_(), SHULKER_BOX);
                DispenserBlock.m_52672_((ItemLike)((IronShulkerBoxBlock)((Object)((Object)((RegistryObject)IronShulkerBoxesBlocks.IRON_SHULKER_BOXES.get((Object)color)).get()))).m_5456_(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
                DispenserBlock.m_52672_((ItemLike)((GoldShulkerBoxBlock)((Object)((Object)((RegistryObject)IronShulkerBoxesBlocks.GOLD_SHULKER_BOXES.get((Object)color)).get()))).m_5456_(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
                DispenserBlock.m_52672_((ItemLike)((DiamondShulkerBoxBlock)((Object)((Object)((RegistryObject)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOXES.get((Object)color)).get()))).m_5456_(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
                DispenserBlock.m_52672_((ItemLike)((CopperShulkerBoxBlock)((Object)((Object)((RegistryObject)IronShulkerBoxesBlocks.COPPER_SHULKER_BOXES.get((Object)color)).get()))).m_5456_(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
                DispenserBlock.m_52672_((ItemLike)((CrystalShulkerBoxBlock)((Object)((Object)((RegistryObject)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOXES.get((Object)color)).get()))).m_5456_(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
                DispenserBlock.m_52672_((ItemLike)((ObsidianShulkerBoxBlock)((Object)((Object)((RegistryObject)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOXES.get((Object)color)).get()))).m_5456_(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
            }
        });
    }

    private void gatherData(GatherDataEvent event) {
        ExistingFileHelper ext = event.getExistingFileHelper();
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeServer(), (DataProvider)new IronShulkerBoxesLootTableProvider(packOutput));
        gen.addProvider(event.includeClient(), (DataProvider)new IronShulkerBoxesRecipeProvider(packOutput));
        gen.addProvider(event.includeClient(), (DataProvider)new IronShulkerBoxesSpriteSourceProvider(packOutput, ext));
        gen.addProvider(event.includeClient(), (DataProvider)new IronShulkerBoxesBlockTags(packOutput, lookupProvider, ext));
        gen.addProvider(event.includeClient(), (DataProvider)new IronShulkerBoxesLanguageProvider(packOutput, "en_us"));
    }
}

