/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.common.data;

import com.progwml6.ironshulkerbox.common.item.IronShulkerBoxesUpgradeType;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesBlocks;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesItems;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesRecipes;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class IronShulkerBoxesRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public IronShulkerBoxesRecipeProvider(PackOutput output) {
        super(output);
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        this.addDefaultShulkerBoxRecipes(consumer);
        this.addColoredShulkerBoxRecipes(consumer);
        this.addUpgradesRecipes(consumer);
        SpecialRecipeBuilder.m_245676_((RecipeSerializer)((RecipeSerializer)IronShulkerBoxesRecipes.SHULKER_BOX_COLORING.get())).m_126359_(consumer, IronShulkerBoxesRecipeProvider.location("shulker_box_coloring").toString());
    }

    private void addDefaultShulkerBoxRecipes(Consumer<FinishedRecipe> consumer) {
        String color = "default/";
        String group = "ironshulkerbox:shulker_box";
        this.registerCopperBoxRecipe(consumer, (ItemLike)IronShulkerBoxesBlocks.COPPER_SHULKER_BOX.get(), (ItemLike)Items.f_42265_, color, group);
        this.registerIronBoxRecipe(consumer, (ItemLike)IronShulkerBoxesBlocks.IRON_SHULKER_BOX.get(), (ItemLike)IronShulkerBoxesBlocks.COPPER_SHULKER_BOX.get(), (ItemLike)Items.f_42265_, color, group);
        this.registerGoldBoxRecipe(consumer, (ItemLike)IronShulkerBoxesBlocks.GOLD_SHULKER_BOX.get(), (ItemLike)IronShulkerBoxesBlocks.IRON_SHULKER_BOX.get(), color, group);
        this.registerDiamondBoxRecipe(consumer, (ItemLike)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOX.get(), (ItemLike)IronShulkerBoxesBlocks.GOLD_SHULKER_BOX.get(), color, group);
        this.registerCrystalBoxRecipe(consumer, (ItemLike)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOX.get(), (ItemLike)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOX.get(), color, group);
        this.registerObsidianBoxRecipe(consumer, (ItemLike)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOX.get(), (ItemLike)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOX.get(), color, group);
    }

    private void addColoredShulkerBoxRecipes(Consumer<FinishedRecipe> consumer) {
        for (DyeColor color : DyeColor.values()) {
            String colorName = color.name().toLowerCase(Locale.ROOT);
            String folder = colorName + "/";
            String group = "ironshulkerbox:" + colorName + "_shulker_box";
            this.registerCopperBoxRecipe(consumer, (ItemLike)((RegistryObject)IronShulkerBoxesBlocks.COPPER_SHULKER_BOXES.get((Object)color)).get(), this.getShulkerBoxItem(color), folder, group);
            this.registerIronBoxRecipe(consumer, (ItemLike)((RegistryObject)IronShulkerBoxesBlocks.IRON_SHULKER_BOXES.get((Object)color)).get(), (ItemLike)((RegistryObject)IronShulkerBoxesBlocks.COPPER_SHULKER_BOXES.get((Object)color)).get(), this.getShulkerBoxItem(color), folder, group);
            this.registerGoldBoxRecipe(consumer, (ItemLike)((RegistryObject)IronShulkerBoxesBlocks.GOLD_SHULKER_BOXES.get((Object)color)).get(), (ItemLike)((RegistryObject)IronShulkerBoxesBlocks.IRON_SHULKER_BOXES.get((Object)color)).get(), folder, group);
            this.registerDiamondBoxRecipe(consumer, (ItemLike)((RegistryObject)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOXES.get((Object)color)).get(), (ItemLike)((RegistryObject)IronShulkerBoxesBlocks.GOLD_SHULKER_BOXES.get((Object)color)).get(), folder, group);
            this.registerCrystalBoxRecipe(consumer, (ItemLike)((RegistryObject)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOXES.get((Object)color)).get(), (ItemLike)((RegistryObject)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOXES.get((Object)color)).get(), folder, group);
            this.registerObsidianBoxRecipe(consumer, (ItemLike)((RegistryObject)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOXES.get((Object)color)).get(), (ItemLike)((RegistryObject)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOXES.get((Object)color)).get(), folder, group);
        }
    }

    private void addUpgradesRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "upgrades/";
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)((RegistryObject)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.VANILLA_TO_COPPER)).get())).m_206416_(Character.valueOf('M'), Tags.Items.INGOTS_COPPER).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42748_).m_126130_("MMM").m_126130_("MSM").m_126130_("MMM").m_126132_("has_copper_ingot", (CriterionTriggerInstance)IronShulkerBoxesRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_COPPER)).m_126140_(consumer, IronShulkerBoxesRecipeProvider.prefix((ItemLike)((RegistryObject)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.VANILLA_TO_COPPER)).get(), folder));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)((RegistryObject)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.VANILLA_TO_IRON)).get())).m_206416_(Character.valueOf('M'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42748_).m_126130_("MMM").m_126130_("MSM").m_126130_("MMM").m_126132_("has_iron_ingot", (CriterionTriggerInstance)IronShulkerBoxesRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_126140_(consumer, IronShulkerBoxesRecipeProvider.prefix((ItemLike)((RegistryObject)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.VANILLA_TO_IRON)).get(), folder));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)((RegistryObject)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.COPPER_TO_IRON)).get())).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('C'), Tags.Items.INGOTS_COPPER).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_126130_("IGI").m_126130_("GCG").m_126130_("IGI").m_126132_("has_iron_ingot", (CriterionTriggerInstance)IronShulkerBoxesRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_126140_(consumer, IronShulkerBoxesRecipeProvider.prefix((ItemLike)((RegistryObject)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.COPPER_TO_IRON)).get(), folder));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)((RegistryObject)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.IRON_TO_GOLD)).get())).m_206416_(Character.valueOf('S'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('M'), Tags.Items.INGOTS_GOLD).m_126130_("MSM").m_126130_("MMM").m_126130_("MMM").m_126132_("has_iron_ingot", (CriterionTriggerInstance)IronShulkerBoxesRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_126140_(consumer, IronShulkerBoxesRecipeProvider.prefix((ItemLike)((RegistryObject)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.IRON_TO_GOLD)).get(), folder));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)((RegistryObject)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.GOLD_TO_DIAMOND)).get())).m_206416_(Character.valueOf('M'), Tags.Items.GEMS_DIAMOND).m_206416_(Character.valueOf('S'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_126130_("GMG").m_126130_("GSG").m_126130_("GMG").m_126132_("has_glass", (CriterionTriggerInstance)IronShulkerBoxesRecipeProvider.m_206406_((TagKey)Tags.Items.GLASS)).m_126140_(consumer, IronShulkerBoxesRecipeProvider.prefix((ItemLike)((RegistryObject)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.GOLD_TO_DIAMOND)).get(), folder));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)((RegistryObject)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.DIAMOND_TO_OBSIDIAN)).get())).m_126127_(Character.valueOf('M'), (ItemLike)Blocks.f_50080_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_126130_("MGM").m_126130_("MMM").m_126130_("MMM").m_126132_("has_glass", (CriterionTriggerInstance)IronShulkerBoxesRecipeProvider.m_206406_((TagKey)Tags.Items.GLASS)).m_126140_(consumer, IronShulkerBoxesRecipeProvider.prefix((ItemLike)((RegistryObject)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.DIAMOND_TO_OBSIDIAN)).get(), folder));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)((RegistryObject)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.DIAMOND_TO_CRYSTAL)).get())).m_126127_(Character.valueOf('S'), (ItemLike)Blocks.f_50080_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_126130_("GSG").m_126130_("GGG").m_126130_("GGG").m_126132_("has_glass", (CriterionTriggerInstance)IronShulkerBoxesRecipeProvider.m_206406_((TagKey)Tags.Items.GLASS)).m_126140_(consumer, IronShulkerBoxesRecipeProvider.prefix((ItemLike)((RegistryObject)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.DIAMOND_TO_CRYSTAL)).get(), folder));
    }

    protected static ResourceLocation prefix(ItemLike item, String prefix) {
        ResourceLocation loc = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()));
        return IronShulkerBoxesRecipeProvider.location(prefix + loc.m_135815_());
    }

    private static ResourceLocation location(String id) {
        return new ResourceLocation("ironshulkerbox", id);
    }

    private void registerCopperBoxRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike input, String color, String group) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result).m_126145_(group).m_206416_(Character.valueOf('M'), Tags.Items.INGOTS_COPPER).m_126127_(Character.valueOf('S'), input).m_126130_("MMM").m_126130_("MSM").m_126130_("MMM").m_126132_("has_copper", (CriterionTriggerInstance)IronShulkerBoxesRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_COPPER)).m_126140_(consumer, IronShulkerBoxesRecipeProvider.location("shulkerboxes/" + color + "copper/vanilla_copper_shulker_box"));
    }

    private void registerIronBoxRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike input, ItemLike inputTwo, String color, String group) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result).m_126145_(group).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_126127_(Character.valueOf('S'), input).m_206416_(Character.valueOf('M'), Tags.Items.INGOTS_IRON).m_126130_("MGM").m_126130_("GSG").m_126130_("MGM").m_126132_("has_gold", (CriterionTriggerInstance)IronShulkerBoxesRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_126140_(consumer, IronShulkerBoxesRecipeProvider.location("shulkerboxes/" + color + "iron/copper_iron_shulker_box"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result).m_126145_(group).m_126127_(Character.valueOf('S'), inputTwo).m_206416_(Character.valueOf('M'), Tags.Items.INGOTS_IRON).m_126130_("MMM").m_126130_("MSM").m_126130_("MMM").m_126132_("has_gold", (CriterionTriggerInstance)IronShulkerBoxesRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_GOLD)).m_126140_(consumer, IronShulkerBoxesRecipeProvider.location("shulkerboxes/" + color + "iron/vanilla_iron_shulker_box"));
    }

    private void registerGoldBoxRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike input, String color, String group) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result).m_126145_(group).m_126127_(Character.valueOf('S'), input).m_206416_(Character.valueOf('M'), Tags.Items.INGOTS_GOLD).m_126130_("MMM").m_126130_("MSM").m_126130_("MMM").m_126132_("has_gold", (CriterionTriggerInstance)IronShulkerBoxesRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_GOLD)).m_126140_(consumer, IronShulkerBoxesRecipeProvider.location("shulkerboxes/" + color + "gold/iron_gold_shulker_box"));
    }

    private void registerDiamondBoxRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike input, String color, String group) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result).m_126145_(group).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_126127_(Character.valueOf('S'), input).m_206416_(Character.valueOf('M'), Tags.Items.GEMS_DIAMOND).m_126130_("GGG").m_126130_("MSM").m_126130_("GGG").m_126132_("has_diamonds", (CriterionTriggerInstance)IronShulkerBoxesRecipeProvider.m_206406_((TagKey)Tags.Items.GEMS_DIAMOND)).m_126140_(consumer, IronShulkerBoxesRecipeProvider.location("shulkerboxes/" + color + "diamond/gold_diamond_shulker_box"));
    }

    private void registerCrystalBoxRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike input, String color, String group) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result).m_126145_(group).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_126127_(Character.valueOf('S'), input).m_126130_("GGG").m_126130_("GSG").m_126130_("GGG").m_126132_("has_glass", (CriterionTriggerInstance)IronShulkerBoxesRecipeProvider.m_206406_((TagKey)Tags.Items.GLASS)).m_126140_(consumer, IronShulkerBoxesRecipeProvider.location("shulkerboxes/" + color + "crystal/diamond_crystal_shulker_box"));
    }

    private void registerObsidianBoxRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike input, String color, String group) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result).m_126145_(group).m_126127_(Character.valueOf('M'), (ItemLike)Items.f_41999_).m_126127_(Character.valueOf('S'), input).m_126130_("MMM").m_126130_("MSM").m_126130_("MMM").m_126132_("has_obsidian", (CriterionTriggerInstance)IronShulkerBoxesRecipeProvider.m_125977_((ItemLike)Items.f_41999_)).m_126140_(consumer, IronShulkerBoxesRecipeProvider.location("shulkerboxes/" + color + "obsidian/diamond_obsidian_shulker_box"));
    }

    private ItemLike getShulkerBoxItem(DyeColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> Items.f_42266_;
            case DyeColor.ORANGE -> Items.f_42267_;
            case DyeColor.MAGENTA -> Items.f_42268_;
            case DyeColor.LIGHT_BLUE -> Items.f_42269_;
            case DyeColor.YELLOW -> Items.f_42270_;
            case DyeColor.LIME -> Items.f_42271_;
            case DyeColor.PINK -> Items.f_42272_;
            case DyeColor.GRAY -> Items.f_42273_;
            case DyeColor.LIGHT_GRAY -> Items.f_42274_;
            case DyeColor.CYAN -> Items.f_42275_;
            case DyeColor.PURPLE -> Items.f_42224_;
            case DyeColor.BLUE -> Items.f_42225_;
            case DyeColor.BROWN -> Items.f_42226_;
            case DyeColor.GREEN -> Items.f_42227_;
            case DyeColor.RED -> Items.f_42228_;
            case DyeColor.BLACK -> Items.f_42229_;
        };
    }
}

