/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.common.item;

import com.progwml6.ironshulkerbox.common.block.AbstractIronShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.CopperShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.IronShulkerBoxesTypes;
import com.progwml6.ironshulkerbox.common.block.entity.AbstractIronShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.item.IronShulkerBoxesUpgradeType;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesBlocks;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class IronShulkerBoxUpgradeItem
extends Item {
    private final IronShulkerBoxesUpgradeType type;

    public IronShulkerBoxUpgradeItem(IronShulkerBoxesUpgradeType type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player entityPlayer = context.m_43723_();
        BlockPos blockPos = context.m_8083_();
        Level world = context.m_43725_();
        ItemStack itemStack = context.m_43722_();
        boolean passed = false;
        if (world.f_46443_) {
            return InteractionResult.PASS;
        }
        if (entityPlayer == null) {
            return InteractionResult.PASS;
        }
        if (this.type.canUpgrade(IronShulkerBoxesTypes.VANILLA)) {
            if (world.m_8055_(blockPos).m_60734_() instanceof ShulkerBoxBlock) {
                passed = true;
            }
        } else {
            Block block = world.m_8055_(blockPos).m_60734_();
            if (!(block instanceof AbstractIronShulkerBoxBlock)) {
                passed = true;
            } else {
                AbstractIronShulkerBoxBlock block2 = (AbstractIronShulkerBoxBlock)block;
                if (block2.m_49966_() == IronShulkerBoxesTypes.get(this.type.source, block2.getColor()).m_49966_()) {
                    passed = true;
                }
            }
        }
        if (!passed) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = world.m_7702_(blockPos);
        if (this.type.canUpgrade(IronShulkerBoxesTypes.VANILLA) && !(blockEntity instanceof ShulkerBoxBlockEntity)) {
            return InteractionResult.PASS;
        }
        AbstractIronShulkerBoxBlockEntity newShulkerBox = null;
        Component customName = null;
        NonNullList shulkerBoxContents = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
        BlockState iBlockState = ((CopperShulkerBoxBlock)((Object)IronShulkerBoxesBlocks.COPPER_SHULKER_BOX.get())).m_49966_();
        if (blockEntity != null) {
            if (blockEntity instanceof AbstractIronShulkerBoxBlockEntity) {
                AbstractIronShulkerBoxBlockEntity shulkerBox = (AbstractIronShulkerBoxBlockEntity)blockEntity;
                BlockState shulkerBoxState = world.m_8055_(blockPos);
                if (AbstractIronShulkerBoxBlockEntity.getOpenCount((BlockGetter)world, blockPos) > 0) {
                    return InteractionResult.PASS;
                }
                if (!shulkerBox.m_7525_(entityPlayer)) {
                    return InteractionResult.PASS;
                }
                shulkerBoxContents = shulkerBox.m_7086_();
                Direction shulkerBoxFacing = (Direction)shulkerBoxState.m_61143_(AbstractIronShulkerBoxBlock.FACING);
                customName = shulkerBox.m_7770_();
                DyeColor shulkerBoxColor = shulkerBox.getColor();
                iBlockState = IronShulkerBoxesTypes.get(this.type.target, shulkerBoxColor).m_49966_();
                iBlockState = (BlockState)iBlockState.m_61124_(AbstractIronShulkerBoxBlock.FACING, (Comparable)shulkerBoxFacing);
                newShulkerBox = this.type.target.makeEntity(blockPos, iBlockState, shulkerBoxColor);
            } else if (blockEntity instanceof ShulkerBoxBlockEntity) {
                ShulkerBoxBlockEntity shulkerBox = (ShulkerBoxBlockEntity)blockEntity;
                BlockState shulkerBoxState = world.m_8055_(blockPos);
                if (!shulkerBox.m_7525_(entityPlayer)) {
                    return InteractionResult.PASS;
                }
                if (!this.type.canUpgrade(IronShulkerBoxesTypes.VANILLA)) {
                    return InteractionResult.PASS;
                }
                shulkerBoxContents = NonNullList.m_122780_((int)shulkerBox.m_6643_(), (Object)ItemStack.f_41583_);
                for (int slot = 0; slot < shulkerBoxContents.size(); ++slot) {
                    shulkerBoxContents.set(slot, (Object)shulkerBox.m_8020_(slot));
                }
                Direction shulkerBoxFacing = (Direction)shulkerBoxState.m_61143_((Property)ShulkerBoxBlock.f_56183_);
                customName = shulkerBox.m_7770_();
                DyeColor shulkerBoxColor = ((ShulkerBoxBlock)shulkerBoxState.m_60734_()).m_56261_();
                iBlockState = IronShulkerBoxesTypes.get(this.type.target, shulkerBoxColor).m_49966_();
                iBlockState = (BlockState)iBlockState.m_61124_(AbstractIronShulkerBoxBlock.FACING, (Comparable)shulkerBoxFacing);
                shulkerBox.m_6211_();
                newShulkerBox = this.type.target.makeEntity(blockPos, iBlockState, shulkerBoxColor);
            }
        }
        if (newShulkerBox == null) {
            return InteractionResult.PASS;
        }
        world.m_46747_(blockPos);
        world.m_7471_(blockPos, false);
        world.m_7731_(blockPos, iBlockState, 3);
        world.m_151523_(newShulkerBox);
        world.m_7260_(blockPos, iBlockState, iBlockState, 3);
        BlockEntity tileEntity2 = world.m_7702_(blockPos);
        if (tileEntity2 instanceof AbstractIronShulkerBoxBlockEntity) {
            if (customName != null) {
                ((AbstractIronShulkerBoxBlockEntity)tileEntity2).m_58638_(customName);
            }
            ((AbstractIronShulkerBoxBlockEntity)tileEntity2).m_6520_((NonNullList<ItemStack>)shulkerBoxContents);
        }
        if (!entityPlayer.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        MutableComponent SOURCE = Component.m_237115_((String)("ironshulkerbox." + this.type.source.getEnglishName().toLowerCase())).m_130940_(ChatFormatting.BOLD);
        MutableComponent TARGET = Component.m_237115_((String)("ironshulkerbox." + this.type.target.getEnglishName().toLowerCase())).m_130940_(ChatFormatting.BOLD);
        pTooltipComponents.add((Component)Component.m_237110_((String)"item.ironshulkerbox.shulker_box_upgrade.upgrade", (Object[])new Object[]{SOURCE, TARGET}).m_130940_(ChatFormatting.DARK_RED));
        pTooltipComponents.add((Component)Component.m_237115_((String)"item.ironshulkerbox.shulker_box_upgrade.color").m_130940_(ChatFormatting.GOLD));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

