/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.common.registraton;

import com.google.common.collect.ImmutableMap;
import com.progwml6.ironshulkerbox.common.block.CopperShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.CrystalShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.DiamondShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.GoldShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.IronShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.IronShulkerBoxesTypes;
import com.progwml6.ironshulkerbox.common.block.ObsidianShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.entity.AbstractIronShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.item.IronShulkerBoxBlockItem;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesItems;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class IronShulkerBoxesBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"ironshulkerbox");
    public static final DeferredRegister<Item> ITEMS = IronShulkerBoxesItems.ITEMS;
    static BlockBehaviour.StatePredicate positionPredicate = (state, level, pos) -> {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof AbstractIronShulkerBoxBlockEntity)) {
            return true;
        }
        AbstractIronShulkerBoxBlockEntity shulkerBoxBlockEntity = (AbstractIronShulkerBoxBlockEntity)blockEntity;
        return shulkerBoxBlockEntity.isClosed();
    };
    private static final BlockBehaviour.Properties STANDARD = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60978_(3.0f).m_60988_().m_60955_().m_60960_(positionPredicate).m_60971_(positionPredicate).m_278166_(PushReaction.DESTROY);
    private static final BlockBehaviour.Properties REINFORCED = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, 10000.0f).m_60988_().m_60955_().m_60960_(positionPredicate).m_60971_(positionPredicate).m_278166_(PushReaction.DESTROY);
    public static final RegistryObject<IronShulkerBoxBlock> IRON_SHULKER_BOX = IronShulkerBoxesBlocks.register("iron_shulker_box", () -> new IronShulkerBoxBlock(STANDARD, null), IronShulkerBoxesTypes.IRON, null);
    public static final RegistryObject<GoldShulkerBoxBlock> GOLD_SHULKER_BOX = IronShulkerBoxesBlocks.register("gold_shulker_box", () -> new GoldShulkerBoxBlock(STANDARD, null), IronShulkerBoxesTypes.GOLD, null);
    public static final RegistryObject<DiamondShulkerBoxBlock> DIAMOND_SHULKER_BOX = IronShulkerBoxesBlocks.register("diamond_shulker_box", () -> new DiamondShulkerBoxBlock(STANDARD, null), IronShulkerBoxesTypes.DIAMOND, null);
    public static final RegistryObject<CopperShulkerBoxBlock> COPPER_SHULKER_BOX = IronShulkerBoxesBlocks.register("copper_shulker_box", () -> new CopperShulkerBoxBlock(STANDARD, null), IronShulkerBoxesTypes.COPPER, null);
    public static final RegistryObject<CrystalShulkerBoxBlock> CRYSTAL_SHULKER_BOX = IronShulkerBoxesBlocks.register("crystal_shulker_box", () -> new CrystalShulkerBoxBlock(STANDARD, null), IronShulkerBoxesTypes.CRYSTAL, null);
    public static final RegistryObject<ObsidianShulkerBoxBlock> OBSIDIAN_SHULKER_BOX = IronShulkerBoxesBlocks.register("obsidian_shulker_box", () -> new ObsidianShulkerBoxBlock(REINFORCED, null), IronShulkerBoxesTypes.OBSIDIAN, null);
    public static final ImmutableMap<DyeColor, RegistryObject<IronShulkerBoxBlock>> IRON_SHULKER_BOXES = ImmutableMap.copyOf(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), type -> IronShulkerBoxesBlocks.register("iron_shulker_box_" + type.name().toLowerCase(Locale.ROOT), () -> new IronShulkerBoxBlock(STANDARD, (DyeColor)type), IronShulkerBoxesTypes.IRON, type))));
    public static final ImmutableMap<DyeColor, RegistryObject<GoldShulkerBoxBlock>> GOLD_SHULKER_BOXES = ImmutableMap.copyOf(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), type -> IronShulkerBoxesBlocks.register("gold_shulker_box_" + type.name().toLowerCase(Locale.ROOT), () -> new GoldShulkerBoxBlock(STANDARD, (DyeColor)type), IronShulkerBoxesTypes.GOLD, type))));
    public static final ImmutableMap<DyeColor, RegistryObject<DiamondShulkerBoxBlock>> DIAMOND_SHULKER_BOXES = ImmutableMap.copyOf(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), type -> IronShulkerBoxesBlocks.register("diamond_shulker_box_" + type.name().toLowerCase(Locale.ROOT), () -> new DiamondShulkerBoxBlock(STANDARD, (DyeColor)type), IronShulkerBoxesTypes.DIAMOND, type))));
    public static final ImmutableMap<DyeColor, RegistryObject<CopperShulkerBoxBlock>> COPPER_SHULKER_BOXES = ImmutableMap.copyOf(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), type -> IronShulkerBoxesBlocks.register("copper_shulker_box_" + type.name().toLowerCase(Locale.ROOT), () -> new CopperShulkerBoxBlock(STANDARD, (DyeColor)type), IronShulkerBoxesTypes.COPPER, type))));
    public static final ImmutableMap<DyeColor, RegistryObject<CrystalShulkerBoxBlock>> CRYSTAL_SHULKER_BOXES = ImmutableMap.copyOf(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), type -> IronShulkerBoxesBlocks.register("crystal_shulker_box_" + type.name().toLowerCase(Locale.ROOT), () -> new CrystalShulkerBoxBlock(STANDARD, (DyeColor)type), IronShulkerBoxesTypes.CRYSTAL, type))));
    public static final ImmutableMap<DyeColor, RegistryObject<ObsidianShulkerBoxBlock>> OBSIDIAN_SHULKER_BOXES = ImmutableMap.copyOf(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), type -> IronShulkerBoxesBlocks.register("obsidian_shulker_box_" + type.name().toLowerCase(Locale.ROOT), () -> new ObsidianShulkerBoxBlock(REINFORCED, (DyeColor)type), IronShulkerBoxesTypes.OBSIDIAN, type))));

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup, IronShulkerBoxesTypes shulkerBoxesType, @Nullable DyeColor color) {
        return IronShulkerBoxesBlocks.register(name, sup, block -> IronShulkerBoxesBlocks.item((RegistryObject<? extends Block>)block, () -> () -> shulkerBoxesType, () -> () -> color));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup, Function<RegistryObject<T>, Supplier<? extends Item>> itemCreator) {
        RegistryObject<? extends T> ret = IronShulkerBoxesBlocks.registerNoItem(name, sup);
        ITEMS.register(name, itemCreator.apply(ret));
        return ret;
    }

    private static <T extends Block> RegistryObject<T> registerNoItem(String name, Supplier<? extends T> sup) {
        return BLOCKS.register(name, sup);
    }

    private static Supplier<BlockItem> item(RegistryObject<? extends Block> block, Supplier<Callable<IronShulkerBoxesTypes>> shulkerBoxesType, Supplier<Callable<DyeColor>> color) {
        return () -> new IronShulkerBoxBlockItem((Block)block.get(), new Item.Properties(), shulkerBoxesType, color);
    }
}

