/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client;

import dev.xylonity.companions.common.blockentity.AbstractShadeAltarBlockEntity;
import dev.xylonity.companions.common.blockentity.AbstractTeslaBlockEntity;
import dev.xylonity.companions.common.entity.companion.ShadeMawEntity;
import dev.xylonity.companions.common.entity.projectile.trigger.LaserTriggerProjectile;
import dev.xylonity.companions.common.particle.BaseRibbonTrailParticle;
import dev.xylonity.companions.common.particle.CakeCreamParticle;
import dev.xylonity.companions.common.particle.ElectricArcParticle;
import dev.xylonity.companions.common.particle.GenericRibbonTrailParticle;
import dev.xylonity.companions.common.particle.GoldenAllayRibbonTrailParticle;
import dev.xylonity.companions.common.particle.RedElectricArcParticle;
import dev.xylonity.companions.common.particle.ShadeAltarRibbonParticle;
import dev.xylonity.companions.common.particle.SidedRibbonTrailParticle;
import dev.xylonity.companions.common.particle.SpiralLaserParticle;
import dev.xylonity.companions.proxy.IProxy;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.knightlib.api.camera.CameraShakeManager;
import java.util.Random;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ClientProxy
implements IProxy {
    @Override
    public void spawnElectricArc(Entity e, Entity target, Level level, float d) {
        if (target != null) {
            float distance = 1.0f + level.f_46441_.m_188501_() * d;
            float angle = (level.f_46441_.m_188501_() - 0.5f) * 60.0f;
            float finalAngle = e.m_146908_() + angle;
            double radians = Math.toRadians(finalAngle);
            double offsetX = -Math.sin(radians) * (double)distance;
            double offsetZ = Math.cos(radians) * (double)distance;
            Vec3 start = new Vec3(e.m_20182_().f_82479_, e.m_20182_().f_82480_ + (double)(e.m_20206_() * 0.5f), e.m_20182_().f_82481_);
            Vec3 end = new Vec3(e.m_20182_().f_82479_ + offsetX, (double)e.m_20183_().m_123342_(), e.m_20182_().f_82481_ + offsetZ);
            Minecraft.m_91087_().f_91061_.m_107344_((Particle)new RedElectricArcParticle((ClientLevel)level, start, end, 0.6, 0.35, true, 8));
        }
    }

    @Override
    public void spawnBaseProjectileTrail(Entity entity, float radius, float height, float r, float g, float b) {
        Level level = entity.m_9236_();
        if (!(level instanceof ClientLevel)) {
            return;
        }
        ClientLevel level2 = (ClientLevel)level;
        double x = entity.m_20185_() + (level2.f_46441_.m_188500_() - 0.5) * (double)entity.m_20205_();
        double y = entity.m_20186_() + (double)entity.m_20206_() * level2.f_46441_.m_188500_();
        double z = entity.m_20189_() + (level2.f_46441_.m_188500_() - 0.5) * (double)entity.m_20205_();
        Minecraft.m_91087_().f_91061_.m_107344_((Particle)new BaseRibbonTrailParticle(level2, x, y, z, r, g, b, radius, height, entity.m_19879_()));
    }

    @Override
    public void shakePlayerCamera(Player player, int durationTicks, float intensityX, float intensityY, float intensityZ, int fadeStartTick) {
        CameraShakeManager.shake((Player)player, (int)durationTicks, (float)intensityX, (float)intensityY, (float)intensityZ, (int)fadeStartTick);
    }

    @Override
    public void spawnGenericRibbonTrail(Entity e, Level level, double x, double y, double z, float r, float g, float b, float radius, float height) {
        Minecraft.m_91087_().f_91061_.m_107344_((Particle)new GenericRibbonTrailParticle((ClientLevel)level, x, y, z, r, g, b, radius, height, e.m_19879_()));
    }

    @Override
    public void spawnGoldenAllayRibbonTrail(Entity e, Level level, double x, double y, double z, float r, float g, float b, float radius, float height) {
        Minecraft.m_91087_().f_91061_.m_107344_((Particle)new GoldenAllayRibbonTrailParticle((ClientLevel)level, x, y, z, r, g, b, radius, height, e.m_19879_()));
    }

    @Override
    public void spawnSidedRibbonTrail(Entity e, Level level, double x, double y, double z, float r, float g, float b, float radius, float height, int side) {
        Minecraft.m_91087_().f_91061_.m_107344_((Particle)new SidedRibbonTrailParticle((ClientLevel)level, x, y, z, r, g, b, radius, height, e.m_19879_(), side));
    }

    @Override
    public void spawnShadeAltarParticles(AbstractShadeAltarBlockEntity e, Level level, float r, float g, float b, double radius) {
        Minecraft.m_91087_().f_91061_.m_107344_((Particle)new ShadeAltarRibbonParticle((ClientLevel)level, e.m_58899_().m_252807_(), r, g, b, radius));
    }

    @Override
    public void spawnPlasmaLampElectricArc(AbstractTeslaBlockEntity e, Level level, BlockPos blockPos) {
        double radius1 = 0.42;
        double y = (double)e.m_58899_().m_123342_() + 0.5;
        for (int i = 0; i < 360; i += 40) {
            double angleRadians = Math.toRadians(i);
            double x = e.m_58899_().m_252807_().m_82549_((Vec3)e.electricalChargeOriginOffset()).f_82479_ + radius1 * Math.cos(angleRadians);
            double z = e.m_58899_().m_252807_().m_82549_((Vec3)e.electricalChargeOriginOffset()).f_82481_ + radius1 * Math.sin(angleRadians);
            level.m_7106_((ParticleOptions)CompanionsParticles.DINAMO_SPARK.get(), x, y + level.f_46441_.m_188500_() * 0.7, z, 0.0, 0.35, 0.0);
        }
        double dd = (level.f_46441_.m_188500_() * 2.0 - 1.0) * 2.5;
        Vec3 start = new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5).m_82549_(e.electricalChargeOriginOffset());
        Vec3 end = new Vec3((double)(blockPos.m_123341_() + Mth.m_14107_((double)dd)) + 0.5, (double)blockPos.m_123342_(), (double)(blockPos.m_123343_() + Mth.m_14107_((double)dd)) + 0.5);
        Minecraft.m_91087_().f_91061_.m_107344_((Particle)new ElectricArcParticle((ClientLevel)level, start, end, Math.hypot(start.f_82479_ - end.f_82479_, start.f_82481_ - end.f_82481_) * 0.6, 0.35));
    }

    @Override
    public void tickLaserTriggerProjectile(LaserTriggerProjectile laser) {
        Entity e;
        if (laser.target == null && (e = laser.m_9236_().m_6815_(laser.getTargetId())) instanceof LivingEntity) {
            laser.target = (LivingEntity)e;
        }
        if (laser.target != null) {
            Vec3 start = laser.m_20182_();
            Vec3 targetPos = laser.target.m_146892_();
            ClipContext ctx = new ClipContext(start, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)laser);
            BlockHitResult hit = laser.m_9236_().m_45547_(ctx);
            Vec3 end = hit.m_6662_() == HitResult.Type.BLOCK && !laser.m_9236_().m_8055_(hit.m_82425_()).m_60812_((BlockGetter)laser.m_9236_(), hit.m_82425_()).m_83281_() ? hit.m_82450_() : targetPos;
            ClientLevel cl = (ClientLevel)laser.m_9236_();
            if (laser.f_19797_ % 2 == 0) {
                Minecraft.m_91087_().f_91061_.m_107344_((Particle)new RedElectricArcParticle(cl, start, end, 0.15f, 0.4f, false, 16));
            }
            if (laser.f_19797_ % 4 == 0 || laser.f_19797_ % 5 == 0) {
                Minecraft.m_91087_().f_91061_.m_107344_((Particle)new SpiralLaserParticle(cl, start, end, 0.3f, 0.75));
            }
            Random random = new Random();
            if (random.nextFloat() < 0.2f) {
                this.spawnElectricArc((Entity)laser, (Entity)laser.target, laser.m_9236_(), (float)start.m_82554_(end));
            }
            Random random2 = new Random();
            if (random2.nextFloat() < 0.4f) {
                laser.spawnSparks(laser.m_9236_());
            }
        }
    }

    @Override
    public void spawnLaserRingElectricArc(Entity e, Level level, float distance) {
        float distStart = 1.0f + level.f_46441_.m_188501_() * distance;
        double radStart = Math.toRadians(level.f_46441_.m_188501_() * 360.0f);
        float distEnd = 1.0f + level.f_46441_.m_188501_() * distance;
        double radEnd = Math.toRadians(level.f_46441_.m_188501_() * 360.0f);
        Vec3 start = new Vec3(e.m_20182_().f_82479_ + -Math.sin(radStart) * (double)distStart, e.m_20182_().f_82480_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 2.0f), e.m_20182_().f_82481_ + Math.cos(radStart) * (double)distStart);
        Vec3 end = new Vec3(e.m_20182_().f_82479_ + -Math.sin(radEnd) * (double)distEnd, e.m_20182_().f_82480_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 2.0f), e.m_20182_().f_82481_ + Math.cos(radEnd) * (double)distEnd);
        Minecraft.m_91087_().f_91061_.m_107344_((Particle)new RedElectricArcParticle((ClientLevel)level, start, end, 0.6, 0.35, true, 8));
    }

    @Override
    public void tickShadeMaw(ShadeMawEntity e) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_20202_() == e && Minecraft.m_91087_().f_91066_.m_92176_() != CameraType.THIRD_PERSON_BACK) {
            Minecraft.m_91087_().f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
        }
    }

    @Override
    public void updateCreamParticle(Vec3 coordinates) {
        CakeCreamParticle.setDefaultVelocity(coordinates.f_82479_ * 0.5, coordinates.f_82480_ * 0.5, coordinates.f_82481_ * 0.5);
    }
}

