/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.entity.ShadeEntity;
import dev.xylonity.companions.common.entity.projectile.ShadeAltarUpgradeHaloProjectile;
import dev.xylonity.companions.common.item.ShadowBellItem;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AbstractShadeAltarBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final int MAX_CHARGES = CompanionsConfig.SHADOW_ALTAR_MAX_CHARGES;
    private static final int MAX_BLOOD_CHARGES = CompanionsConfig.SHADOW_ALTAR_BLOOD_CHARGES_AMOUNT;
    public UUID activeShadeUUID = null;
    private int charges = 0;
    private int prevCharges = 0;

    public AbstractShadeAltarBlockEntity(BlockEntityType<?> pType, BlockPos pos, BlockState state) {
        super(pType, pos, state);
    }

    public int getCharges() {
        return this.charges;
    }

    public int getMaxCharges() {
        return MAX_CHARGES;
    }

    public int getBloodCharges() {
        return MAX_BLOOD_CHARGES;
    }

    public boolean isBloodUpgradeActive() {
        return this.getCharges() >= MAX_CHARGES - MAX_BLOOD_CHARGES;
    }

    public boolean addCharge() {
        if (this.charges >= MAX_CHARGES) {
            if (this.f_58857_ != null) {
                this.f_58857_.m_247517_(null, this.m_58899_(), CompanionsSounds.SHADE_ALTAR_FULL.get(), SoundSource.BLOCKS);
            }
            return false;
        }
        ++this.charges;
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_247517_(null, this.m_58899_(), CompanionsSounds.SHADE_ALTAR_CHARGE.get(), SoundSource.BLOCKS);
        }
        return true;
    }

    public boolean consumeCharge() {
        if (this.charges <= 0) {
            return false;
        }
        --this.charges;
        this.m_6596_();
        return true;
    }

    public void setCharges(int charges) {
        this.charges = charges;
        this.m_6596_();
    }

    public void clearCharges() {
        this.charges = 0;
        this.m_6596_();
    }

    protected boolean isImportantChargeDiff() {
        return this.prevCharges == 0 && this.charges == 1 || this.prevCharges == MAX_CHARGES - MAX_BLOOD_CHARGES - 1 && this.charges == MAX_CHARGES - MAX_BLOOD_CHARGES;
    }

    protected boolean hasIncreasedFromPrevInteraction() {
        return this.charges > this.prevCharges;
    }

    public void m_6596_() {
        ShadeAltarUpgradeHaloProjectile halo;
        super.m_6596_();
        if (this.f_58857_ != null && this.hasIncreasedFromPrevInteraction() && (halo = (ShadeAltarUpgradeHaloProjectile)((EntityType)CompanionsEntities.SHADE_ALTAR_UPGRADE_HALO.get()).m_20615_(this.f_58857_)) != null) {
            halo.m_6034_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.015, (double)this.m_58899_().m_123343_() + 0.5);
            this.f_58857_.m_7967_((Entity)halo);
        }
        this.prevCharges = this.charges;
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Charges", this.charges);
        tag.m_128405_("PrevCharges", this.prevCharges);
        if (this.activeShadeUUID != null) {
            tag.m_128362_("ActiveShadeUUID", this.activeShadeUUID);
        } else {
            tag.m_128473_("ActiveShadeUUID");
        }
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.charges = tag.m_128451_("Charges");
        this.prevCharges = tag.m_128451_("PrevCharges");
        this.activeShadeUUID = tag.m_128403_("ActiveShadeUUID") ? tag.m_128342_("ActiveShadeUUID") : null;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.charges = tag.m_128451_("Charges");
        this.prevCharges = tag.m_128451_("PrevCharges");
        this.activeShadeUUID = tag.m_128403_("ActiveShadeUUID") ? tag.m_128342_("ActiveShadeUUID") : null;
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("Charges", this.getCharges());
        tag.m_128405_("PrevCharges", this.prevCharges);
        if (this.activeShadeUUID != null) {
            tag.m_128362_("ActiveShadeUUID", this.activeShadeUUID);
        }
        return tag;
    }

    public void sync() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ClientboundBlockEntityDataPacket pkt = ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
        serverLevel.m_7726_().f_8325_.m_183262_(new ChunkPos(this.f_58858_), false).forEach(arg_0 -> AbstractShadeAltarBlockEntity.lambda$sync$0((Packet)pkt, arg_0));
    }

    @Nullable
    public abstract ShadeEntity spawnShade(@NotNull Level var1, @NotNull Player var2, @NotNull InteractionHand var3, ShadowBellItem var4);

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public double findPlaceToSpawn(@NotNull Player pPlayer, @NotNull Level pLevel, int blockX, int blockZ) {
        int baseY = Mth.m_14107_((double)pPlayer.m_20186_());
        int minY = pLevel.m_141937_();
        int maxY = pLevel.m_151558_() - 1;
        int spawnY = baseY;
        boolean found = false;
        for (int offset = 0; offset <= Math.max(baseY - minY, maxY - baseY) && !found; ++offset) {
            int yUp;
            int yDown = baseY - offset;
            if (yDown >= minY) {
                BlockPos below = new BlockPos(blockX, yDown - 1, blockZ);
                BlockPos curr = new BlockPos(blockX, yDown, blockZ);
                if (yDown - 1 >= minY && !pLevel.m_8055_(below).m_60795_() && pLevel.m_8055_(curr).m_60795_()) {
                    spawnY = yDown;
                    found = true;
                }
            }
            if (found || offset <= 0 || (yUp = baseY + offset) > maxY) continue;
            BlockPos below = new BlockPos(blockX, yUp - 1, blockZ);
            BlockPos curr = new BlockPos(blockX, yUp, blockZ);
            if (yUp - 1 < minY || pLevel.m_8055_(below).m_60795_() || !pLevel.m_8055_(curr).m_60795_()) continue;
            spawnY = yUp;
            found = true;
        }
        if (!found) {
            return Math.max(minY + 1, Math.min(maxY, baseY));
        }
        return spawnY;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private static /* synthetic */ void lambda$sync$0(Packet pkt, ServerPlayer p) {
        p.f_8906_.m_9829_(pkt);
    }
}

