/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.blockentity.AbstractTeslaBlockEntity;
import dev.xylonity.companions.common.tesla.TeslaConnectionManager;
import dev.xylonity.companions.common.tesla.behaviour.pillar.PillarPulseBehaviour;
import dev.xylonity.companions.common.util.interfaces.ITeslaNodeBehaviour;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VoltaicPillarBlockEntity
extends AbstractTeslaBlockEntity {
    private final ITeslaNodeBehaviour pulseBehaviour = new PillarPulseBehaviour();
    private boolean isTop = false;
    private boolean hasBlockOnTop = false;

    public VoltaicPillarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CompanionsBlockEntities.VOLTAIC_PILLAR.get(), pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (!(t instanceof VoltaicPillarBlockEntity)) {
            return;
        }
        VoltaicPillarBlockEntity pillar = (VoltaicPillarBlockEntity)t;
        pillar.pulseBehaviour.process(pillar, level, blockPos, blockState);
        pillar.defaultAttackBehaviour.process(pillar, level, blockPos, blockState);
        pillar.setIsTop(!(level.m_7702_(pillar.m_58899_().m_7494_()) instanceof VoltaicPillarBlockEntity));
        pillar.setHasBlockOnTop(!level.m_8055_(pillar.m_58899_().m_7494_()).m_60795_());
        BlockEntity blockEntity = level.m_7702_(pillar.m_58899_().m_7494_());
        if (blockEntity instanceof VoltaicPillarBlockEntity) {
            VoltaicPillarBlockEntity be = (VoltaicPillarBlockEntity)blockEntity;
            pillar.setOwnerUUID(be.getOwnerUUID());
        }
        pillar.sync();
    }

    public boolean isTop() {
        return this.isTop;
    }

    public void setIsTop(boolean top) {
        this.isTop = top;
    }

    public void setHasBlockOnTop(boolean hasBlockOnTop) {
        this.hasBlockOnTop = hasBlockOnTop;
    }

    public boolean hasBlockOnTop() {
        return this.hasBlockOnTop;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.setIsTop(tag.m_128471_("IsTop"));
        this.setHasBlockOnTop(tag.m_128471_("BlockOnTop"));
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("IsTop", this.isTop());
        tag.m_128379_("BlockOnTop", this.hasBlockOnTop());
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.setIsTop(tag.m_128471_("IsTop"));
        this.setHasBlockOnTop(tag.m_128471_("BlockOnTop"));
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_("IsTop", this.isTop());
        tag.m_128379_("BlockOnTop", this.hasBlockOnTop());
        return tag;
    }

    @Override
    @NotNull
    public Vec3 electricalChargeOriginOffset() {
        return new Vec3(0.0, 0.5, 0.0);
    }

    @Override
    @NotNull
    public Vec3 electricalChargeEndOffset() {
        return new Vec3(0.0, 0.5, 0.0);
    }

    @Override
    public boolean handleNodeSelection(TeslaConnectionManager.ConnectionNode thisNode, TeslaConnectionManager.ConnectionNode nodeToConnect, @Nullable UseOnContext ctx, Player player) {
        if (ctx != null && ctx.m_43725_().m_7702_(nodeToConnect.blockPos()) instanceof VoltaicPillarBlockEntity) {
            ArrayList<VoltaicPillarBlockEntity> thisList = new ArrayList<VoltaicPillarBlockEntity>();
            ArrayList<VoltaicPillarBlockEntity> otherList = new ArrayList<VoltaicPillarBlockEntity>();
            this.pillarsBelow(thisList, thisNode.blockPos());
            this.pillarsBelow(otherList, nodeToConnect.blockPos());
            if (thisList.size() == otherList.size()) {
                for (int i = 0; i < thisList.size(); ++i) {
                    this.connectionManager.addConnection(((VoltaicPillarBlockEntity)((Object)thisList.get(i))).asConnectionNode(), ((VoltaicPillarBlockEntity)((Object)otherList.get(i))).asConnectionNode());
                }
            } else {
                if (player != null) {
                    player.m_5661_((Component)Component.m_237115_((String)"voltaic_pillar.companions.client_message.wrong_amount").m_130940_(ChatFormatting.RED), true);
                }
                return false;
            }
        }
        return super.handleNodeSelection(thisNode, nodeToConnect, ctx, player);
    }

    @Override
    public boolean handleNodeRemoval(TeslaConnectionManager.ConnectionNode thisNode, TeslaConnectionManager.ConnectionNode nodeToConnect, @Nullable UseOnContext ctx, Player player) {
        if (ctx != null && ctx.m_43725_().m_7702_(nodeToConnect.blockPos()) instanceof VoltaicPillarBlockEntity) {
            ArrayList<VoltaicPillarBlockEntity> thisList = new ArrayList<VoltaicPillarBlockEntity>();
            ArrayList<VoltaicPillarBlockEntity> otherList = new ArrayList<VoltaicPillarBlockEntity>();
            this.pillarsBelow(thisList, thisNode.blockPos());
            this.pillarsBelow(otherList, nodeToConnect.blockPos());
            if (thisList.size() == otherList.size()) {
                for (int i = 0; i < thisList.size(); ++i) {
                    this.connectionManager.removeConnection(((VoltaicPillarBlockEntity)((Object)thisList.get(i))).asConnectionNode(), ((VoltaicPillarBlockEntity)((Object)otherList.get(i))).asConnectionNode());
                }
            }
        }
        return super.handleNodeRemoval(thisNode, nodeToConnect, ctx, player);
    }

    private void pillarsBelow(List<VoltaicPillarBlockEntity> pillars, BlockPos pos) {
        this.scanPillars(pillars, pos.m_123341_(), pos.m_123342_() - 1, -1, pos.m_123343_());
    }

    private void scanPillars(List<VoltaicPillarBlockEntity> pillars, int x, int startY, int step, int z) {
        BlockPos currentPos;
        BlockEntity entity;
        if (this.f_58857_ == null) {
            return;
        }
        int currentY = startY;
        while ((entity = this.f_58857_.m_7702_(currentPos = new BlockPos(x, currentY, z))) instanceof VoltaicPillarBlockEntity) {
            VoltaicPillarBlockEntity pillarEntity = (VoltaicPillarBlockEntity)entity;
            pillars.add(pillarEntity);
            currentY += step;
        }
    }
}

