/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.container;

import dev.xylonity.companions.common.recipe.SoulFurnaceRecipe;
import dev.xylonity.companions.registry.CompanionsMenuTypes;
import dev.xylonity.companions.registry.CompanionsRecipes;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

public class SoulFurnaceContainerMenu
extends AbstractContainerMenu {
    private final Container furnaceInventory;
    private final ContainerData data;
    private final Player player;

    public SoulFurnaceContainerMenu(int id, Inventory playerInventory, Container furnaceInventory, ContainerData data) {
        super((MenuType)CompanionsMenuTypes.SOUL_FURNACE.get(), id);
        this.furnaceInventory = furnaceInventory;
        this.data = data;
        this.player = playerInventory.f_35978_;
        this.m_38897_(new Slot(furnaceInventory, 0, 56, 22){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return SoulFurnaceContainerMenu.this.isValidInput(stack);
            }
        });
        this.m_38897_(new Slot(furnaceInventory, 1, 116, 40){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return false;
            }
        });
        int startX = 8;
        int startY = 97;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, startX + col * 18, startY + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, startX + col * 18, startY + 58));
        }
        this.m_38884_(data);
    }

    private boolean isValidInput(ItemStack stack) {
        if (this.player == null) {
            return false;
        }
        for (Recipe rec : this.player.m_9236_().m_7465_().m_44013_((RecipeType)CompanionsRecipes.SOUL_FURNACE_TYPE.get())) {
            SoulFurnaceRecipe r;
            if (!(rec instanceof SoulFurnaceRecipe) || !(r = (SoulFurnaceRecipe)rec).input().test(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6875_(@NotNull Player player) {
        return this.furnaceInventory.m_6542_(player);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            itemstack = stackInSlot.m_41777_();
            int containerSlotCount = 2;
            if (index < containerSlotCount ? !this.m_38903_(stackInSlot, containerSlotCount, this.f_38839_.size(), true) : !this.m_38903_(stackInSlot, 0, containerSlotCount, false)) {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public int getCharge() {
        return this.data.m_6413_(0);
    }

    public int getProgress() {
        return this.data.m_6413_(1);
    }

    public int getProcessingTime() {
        return this.data.m_6413_(2);
    }
}

