/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity;

import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.companion.CorneliusEntity;
import dev.xylonity.companions.common.util.Util;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class CompanionSummonEntity
extends TamableAnimal
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> MAIN_ACTION = SynchedEntityData.m_135353_(CompanionSummonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> NO_MOVEMENT = SynchedEntityData.m_135353_(CompanionSummonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.m_135353_(CompanionSummonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> SECOND_OWNER_UUID = SynchedEntityData.m_135353_(CompanionSummonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    protected CompanionSummonEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19811_ = true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isNoMovement()) {
            this.m_21573_().m_26573_();
            this.m_20334_(0.0, this.m_20184_().m_7098_(), 0.0);
        }
        if (this.f_19797_ % 20 == 0) {
            this.checkOwnersStatus();
        }
    }

    private void checkOwnersStatus() {
        if (!this.m_9236_().f_46443_) {
            LivingEntity owner1 = this.m_269323_();
            LivingEntity owner2 = this.getSecondOwner();
            if ((owner1 == null || !owner1.m_6084_() && !(owner1 instanceof Player)) && owner2 != null && owner2.m_6084_()) {
                this.promoteSecondOwnerToPrimary();
            }
            if (!(owner2 != null && owner2.m_6084_() || this.getSecondOwnerUUID() == null || this.m_269323_() instanceof CompanionEntity)) {
                this.setSecondOwnerUUID(null);
            }
        }
    }

    private void promoteSecondOwnerToPrimary() {
        UUID cache = this.getSecondOwnerUUID();
        if (cache != null) {
            this.m_21816_(cache);
            this.setSecondOwnerUUID(null);
            this.f_19804_.m_135381_(MAIN_ACTION, (Object)0);
            this.m_7105_(true);
        }
    }

    public UUID getSecondOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(SECOND_OWNER_UUID)).orElse(null);
    }

    public void setSecondOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(SECOND_OWNER_UUID, Optional.ofNullable(pUuid));
    }

    public void m_6667_(@NotNull DamageSource pCause) {
        CorneliusEntity e;
        LivingEntity livingEntity;
        super.m_6667_(pCause);
        if (this.m_269323_() != null && (livingEntity = this.m_269323_()) instanceof CorneliusEntity && (e = (CorneliusEntity)livingEntity).getSummonedCount() > 0) {
            e.setSummonedCount(e.getSummonedCount() - 1);
        }
    }

    public int getAttackType() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TYPE);
    }

    public void setAttackType(int type) {
        this.f_19804_.m_135381_(ATTACK_TYPE, (Object)type);
    }

    public void cycleMainAction(@Nullable Player player) {
        if (!this.canCycleOwners()) {
            return;
        }
        this.f_19804_.m_135381_(MAIN_ACTION, (Object)((this.getMainAction() + 1) % 2));
        if (player != null) {
            this.cycleOwners();
            if (this.m_269323_() instanceof Player) {
                player.m_5661_((Component)Component.m_237110_((String)"main_action_summon.companions.client_message.following_player", (Object[])new Object[]{this.m_7755_()}), true);
            } else {
                player.m_5661_((Component)Component.m_237110_((String)"main_action_summon.companions.client_message.following_companion", (Object[])new Object[]{this.m_7755_(), this.m_269323_() != null ? this.m_269323_().m_7755_() : "the companion."}), true);
            }
        }
    }

    private boolean canCycleOwners() {
        LivingEntity owner = this.m_269323_();
        LivingEntity owner2 = this.getSecondOwner();
        if (owner == null && owner2 != null && owner2.m_6084_()) {
            return true;
        }
        return owner != null && owner.m_6084_() && owner2 != null && owner2.m_6084_();
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (pHand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (Util.areEntitiesLinked((Entity)pPlayer, (Entity)this)) {
            if (this.m_9236_().f_46443_) {
                if (this.getSecondOwner() == null) {
                    return InteractionResult.PASS;
                }
                return InteractionResult.SUCCESS;
            }
            this.cycleMainAction(pPlayer);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    private void cycleOwners() {
        UUID cache = this.m_21805_();
        this.m_21816_(this.getSecondOwnerUUID());
        this.setSecondOwnerUUID(cache);
        this.m_7105_(true);
    }

    public int getMainAction() {
        return (Integer)this.f_19804_.m_135370_(MAIN_ACTION);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_7639_() != null && pSource.m_7639_().equals((Object)this.m_269323_()) & !pSource.m_7639_().m_6144_()) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("SecondaryOwnerUUID")) {
            this.setSecondOwnerUUID(pCompound.m_128342_("SecondaryOwnerUUID"));
        }
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.getSecondOwnerUUID() != null) {
            pCompound.m_128362_("SecondaryOwnerUUID", this.getSecondOwnerUUID());
        }
    }

    @Nullable
    public LivingEntity m_269323_() {
        UUID ownerUUID = this.m_21805_();
        if (ownerUUID == null) {
            return null;
        }
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Entity owner = serverLevel.m_8791_(ownerUUID);
        return owner instanceof LivingEntity ? (LivingEntity)owner : null;
    }

    @Nullable
    public LivingEntity getSecondOwner() {
        UUID secondOwnerUUID = this.getSecondOwnerUUID();
        if (secondOwnerUUID == null) {
            return null;
        }
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Entity owner = serverLevel.m_8791_(secondOwnerUUID);
        return owner instanceof LivingEntity ? (LivingEntity)owner : null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_TYPE, (Object)0);
        this.f_19804_.m_135372_(MAIN_ACTION, (Object)0);
        this.f_19804_.m_135372_(NO_MOVEMENT, (Object)false);
        this.f_19804_.m_135372_(SECOND_OWNER_UUID, Optional.empty());
    }

    public boolean isNoMovement() {
        return (Boolean)this.f_19804_.m_135370_(NO_MOVEMENT);
    }

    public void setNoMovement(boolean isNoMovement) {
        this.f_19804_.m_135381_(NO_MOVEMENT, (Object)isNoMovement);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        return null;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

