/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.hostile;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.HostileEntity;
import dev.xylonity.companions.common.entity.ai.minion.hostile.goal.HostileImpBraceAttackGoal;
import dev.xylonity.companions.common.entity.ai.minion.hostile.goal.HostileImpFireMarkAttackGoal;
import dev.xylonity.companions.common.entity.companion.MinionEntity;
import dev.xylonity.companions.common.entity.projectile.ShadeAltarUpgradeHaloProjectile;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class HostileImpEntity
extends HostileEntity {
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation THROW = RawAnimation.begin().thenPlay("throw");
    private final RawAnimation RING = RawAnimation.begin().thenPlay("ring");
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.m_135353_(HostileImpEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.m_135353_(HostileImpEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int ANGRY_MAX_TICKS = 300;
    private int angryCounter = -1;

    public HostileImpEntity(EntityType<? extends HostileEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.isAngry() && this.angryCounter == -1) {
                ++this.angryCounter;
            }
            if (this.angryCounter >= 300) {
                this.angryCounter = -1;
                this.setAngry(false);
                this.m_6710_(null);
                this.failureParticles();
            }
            if (this.angryCounter != -1) {
                ++this.angryCounter;
            }
        }
    }

    public static AttributeSupplier setAttributes() {
        return HostileEntity.m_21552_().m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new HostileImpBraceAttackGoal(this, 20, 90));
        this.f_21345_.m_25352_(1, (Goal)new HostileImpFireMarkAttackGoal(this, 20, 160));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.43));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean m_8036_() {
                return super.m_8036_() && HostileImpEntity.this.isAngry();
            }
        });
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        InteractionResult interactionResult = super.m_6071_(player, hand);
        if (!this.isAngry()) {
            if (item == CompanionsBlocks.COPPER_COIN.get().m_5456_()) {
                interactionResult = this.handleCoinInteraction(this.m_9236_().f_46441_.m_188501_() < 0.25f, player);
            } else if (item == CompanionsBlocks.NETHER_COIN.get().m_5456_()) {
                interactionResult = this.handleCoinInteraction(this.m_9236_().f_46441_.m_188501_() < 0.5f, player);
            } else if (item == CompanionsBlocks.END_COIN.get().m_5456_()) {
                interactionResult = this.handleCoinInteraction(this.m_9236_().f_46441_.m_188501_() < 0.8f, player);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"hostile_imp.companions.client_message.requires_coin"), true);
            }
        }
        return interactionResult;
    }

    private InteractionResult handleCoinInteraction(boolean tame, Player player) {
        if (this.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (tame) {
            this.tameImp(player);
            this.tameParticles();
            this.m_146870_();
        } else {
            this.setAngry(true);
            this.failureParticles();
            ShadeAltarUpgradeHaloProjectile halo = (ShadeAltarUpgradeHaloProjectile)((EntityType)CompanionsEntities.SHADE_ALTAR_UPGRADE_HALO.get()).m_20615_(this.m_9236_());
            if (halo != null) {
                halo.m_20219_(this.m_20182_());
                this.m_9236_().m_7967_((Entity)halo);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    private void tameParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (level2.f_46441_.m_188501_() < 0.65f) {
                level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20189_(), 1, dx, dy, dz, 0.1);
            }
            if (!(level2.f_46441_.m_188501_() < 0.25f)) continue;
            level2.m_8767_((ParticleOptions)CompanionsParticles.SHADE_SUMMON.get(), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20189_(), 1, dx, dy, dz, 0.2);
        }
    }

    private void failureParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (!(level2.f_46441_.m_188501_() < 0.65f)) continue;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20189_(), 1, dx, dy, dz, 0.025);
        }
    }

    private void tameImp(Player player) {
        MinionEntity minion = (MinionEntity)((EntityType)CompanionsEntities.MINION.get()).m_20615_(this.m_9236_());
        if (minion != null) {
            minion.m_20219_(this.m_20182_());
            minion.tameInteraction(player);
            this.m_9236_().m_7967_((Entity)minion);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_TYPE, (Object)0);
        this.f_19804_.m_135372_(ANGRY, (Object)false);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_7639_() != null) {
            this.setAngry(true);
        }
        return super.m_6469_(pSource, pAmount);
    }

    public int getAttackType() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TYPE);
    }

    public void setAttackType(int attacking) {
        this.f_19804_.m_135381_(ATTACK_TYPE, (Object)attacking);
    }

    public boolean isAngry() {
        return (Boolean)this.f_19804_.m_135370_(ANGRY);
    }

    public void setAngry(boolean isAngry) {
        this.f_19804_.m_135381_(ANGRY, (Object)isAngry);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getAttackType() == 1) {
            event.getController().setAnimation(this.THROW);
        } else if (this.getAttackType() == 2) {
            event.getController().setAnimation(this.RING);
        } else if (event.isMoving()) {
            event.getController().setAnimation(this.WALK);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

