/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item.book.books;

import dev.xylonity.companions.common.entity.projectile.StoneSpikeProjectile;
import dev.xylonity.companions.common.item.book.AbstractMagicBook;
import dev.xylonity.companions.common.material.ArmorMaterials;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.knightlib.api.scheduler.TickScheduler;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class StoneSpikesBook
extends AbstractMagicBook {
    public StoneSpikesBook(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected String tooltipName() {
        return "stone_spikes_book";
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        double yaw = Math.toRadians(player.f_19859_);
        Vec3 baseDir = new Vec3(-Math.sin(yaw), 0.0, Math.cos(yaw)).m_82541_();
        int spikes = 10;
        this.spawnSpikeRow(baseDir, spikes, player);
        this.spawnSpikeRow(Util.rotateHorizontalDirection(baseDir, -30.0), (int)((double)spikes * 0.3), player);
        this.spawnSpikeRow(Util.rotateHorizontalDirection(baseDir, 30.0), (int)((double)spikes * 0.3), player);
        if (!level.f_46443_) {
            player.m_36335_().m_41524_((Item)this, (int)((double)CompanionsConfig.STONE_SPIKES_COOLDOWN * (1.0 - (double)Util.hasFullSetOn(player, ArmorMaterials.MAGE) * CompanionsConfig.MAGE_SET_COOLDOWN_REDUCTION)));
        }
        return super.m_7203_(level, player, usedHand);
    }

    @Override
    protected void playSound(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, player.m_5720_(), 1.0f, 1.0f);
    }

    private void spawnSpikeRow(Vec3 direction, int count, Player player) {
        for (int i = 0; i < count; ++i) {
            Vec3 line = player.m_20182_().m_82549_(direction.m_82490_(1.5 + (double)i * 1.5));
            int ix = Mth.m_14107_((double)line.f_82479_);
            int iz = Mth.m_14107_((double)line.f_82481_);
            int iy = Mth.m_14107_((double)line.f_82480_);
            StoneSpikeProjectile spike = (StoneSpikeProjectile)((EntityType)CompanionsEntities.STONE_SPIKE_PROJECTILE.get()).m_20615_(player.m_9236_());
            if (spike == null) continue;
            spike.m_7678_((double)ix + 0.5, this.findSpikeH(player.m_9236_(), ix, iy, iz, Math.toRadians(player.m_146909_()) < 0.0) + 1, (double)iz + 0.5, player.m_146908_(), 0.0f);
            spike.m_5602_((Entity)player);
            if (i == 0) {
                player.m_9236_().m_7967_((Entity)spike);
                continue;
            }
            TickScheduler.scheduleBoth((Level)player.m_9236_(), () -> player.m_9236_().m_7967_((Entity)spike), (int)(i * 2));
        }
    }

    private int findSpikeH(Level level, int x, int yStart, int z, boolean shouldCheckUp) {
        BiPredicate<Level, BlockPos> solid = (level1, pos) -> !level1.m_8055_(pos).m_60812_((BlockGetter)level1, pos).m_83281_();
        if (shouldCheckUp) {
            BlockPos pos2;
            int y;
            for (y = yStart; y <= level.m_151558_(); ++y) {
                pos2 = new BlockPos(x, y, z);
                if (!solid.test(level, pos2)) continue;
                return y;
            }
            for (y = yStart; y >= level.m_141937_(); --y) {
                pos2 = new BlockPos(x, y, z);
                if (!solid.test(level, pos2)) continue;
                return y;
            }
        } else {
            BlockPos pos3;
            int y;
            for (y = yStart; y >= level.m_141937_(); --y) {
                pos3 = new BlockPos(x, y, z);
                if (!solid.test(level, pos3)) continue;
                return y;
            }
            for (y = yStart; y <= level.m_151558_(); ++y) {
                pos3 = new BlockPos(x, y, z);
                if (!solid.test(level, pos3)) continue;
                return y;
            }
        }
        return yStart;
    }
}

