/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.particle;

import dev.xylonity.knightlib.client.particle.AbstractRibbonTrailParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;

public class ShadeAltarRibbonParticle
extends AbstractRibbonTrailParticle {
    private static final ResourceLocation TEXTURE = new ResourceLocation("companions", "textures/particle/trail2.png");
    private static final Vec3 DARK_RED = new Vec3((double)0.2901961f, 0.0, 0.0);
    private final float RED_;
    private final float GREEN_;
    private final float BLUE_;

    public ShadeAltarRibbonParticle(ClientLevel level, Vec3 targetId, float r, float g, float b, double radius) {
        super(level, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, r, g, b);
        this.RED_ = r;
        this.GREEN_ = g;
        this.BLUE_ = b;
        this.f_107225_ = 30;
        this.f_107226_ = 0.0f;
        Vec3 spawnPos = targetId.m_82549_(ShadeAltarRibbonParticle.randomOffsetAbove(level.f_46441_, radius));
        this.m_107264_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        Vec3 dir = targetId.m_82546_(spawnPos);
        Vec3 vel = dir.m_82541_().m_82490_(dir.m_82553_() / (double)(this.f_107225_ - 2));
        this.f_107215_ = vel.f_82479_;
        this.f_107216_ = vel.f_82480_;
        this.f_107217_ = vel.f_82481_;
        this.savePosInBuffer();
    }

    private static Vec3 randomOffsetAbove(RandomSource rand, double radius) {
        double theta1 = 2.0 * rand.m_188500_() - 1.0;
        double theta2 = Math.sqrt(1.0 - theta1 * theta1);
        double phi = Math.PI * 2 * rand.m_188500_();
        double r = Math.cbrt(rand.m_188500_()) * radius;
        double x = theta2 * Math.cos(phi) * r;
        double y = Math.abs(theta1 * r);
        double z = theta2 * Math.sin(phi) * r;
        return new Vec3(x, y, z);
    }

    public void m_5989_() {
        super.m_5989_();
        float lifeFrac = (float)this.f_107224_ / (float)this.f_107225_;
        float fadeIn = Math.min(lifeFrac * 2.0f, 1.0f);
        float fadeOut = 1.0f - lifeFrac;
        this.ribbonAlpha = fadeIn * fadeOut;
        float t = 1.0f - fadeOut;
        this.r = this.RED_ * (1.0f - t) + (float)ShadeAltarRibbonParticle.DARK_RED.f_82479_ * t;
        this.g = this.GREEN_ * (1.0f - t) + (float)ShadeAltarRibbonParticle.DARK_RED.f_82480_ * t;
        this.b = this.BLUE_ * (1.0f - t) + (float)ShadeAltarRibbonParticle.DARK_RED.f_82481_ * t;
    }

    protected float getRibbonHeight() {
        return 0.2f;
    }

    protected ResourceLocation getRibbonSprite() {
        return TEXTURE;
    }

    protected int totalSegments() {
        return 6;
    }
}

