/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.tesla.behaviour.dinamo;

import dev.xylonity.companions.common.entity.companion.DinamoEntity;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.common.util.interfaces.ITeslaGeneratorBehaviour;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEffects;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;

public class DinamoAttackBehaviour
implements ITeslaGeneratorBehaviour {
    @Override
    public void tick(DinamoEntity dinamo) {
        if (dinamo.getAttackCycleCounter() == 0) {
            this.searchForTargets(dinamo);
        }
        if (dinamo.getAttackCycleCounter() < 8) {
            dinamo.setAnimationStartTick(dinamo.getAttackCycleCounter());
            dinamo.setActiveForAttack(true);
        } else if (dinamo.getAttackCycleCounter() == 8) {
            dinamo.setActiveForAttack(false);
            dinamo.setAnimationStartTick(0);
        }
        if (dinamo.isActiveForAttack() && !dinamo.entitiesToAttack.isEmpty()) {
            if (dinamo.m_9236_().m_5776_()) {
                double radius = 0.42;
                double initialY = dinamo.m_20182_().f_82480_ + (double)dinamo.m_20206_() - 0.6;
                for (int i = 0; i < 360; i += 120) {
                    double angleRadians = Math.toRadians(i);
                    double particleX = dinamo.m_20182_().f_82479_ + radius * Math.cos(angleRadians);
                    double particleZ = dinamo.m_20182_().f_82481_ + radius * Math.sin(angleRadians);
                    dinamo.m_9236_().m_7106_((ParticleOptions)CompanionsParticles.DINAMO_SPARK.get(), particleX, initialY, particleZ, 0.0, 0.35, 0.0);
                }
            }
            if (dinamo.getAttackCycleCounter() == 3) {
                for (LivingEntity target : dinamo.entitiesToAttack) {
                    if (!(target.m_20280_((Entity)target) <= 64.0)) continue;
                    target.m_6469_(dinamo.m_269291_().m_269548_(), (float)CompanionsConfig.ELECTRICITY_DAMAGE);
                    if (!(target.m_217043_().m_188501_() < 0.4f)) continue;
                    target.m_7292_(new MobEffectInstance(CompanionsEffects.ELECTROSHOCK.get(), 50, 0, false, true, true));
                }
            }
            if (dinamo.getAttackCycleCounter() == 0) {
                dinamo.m_5496_(CompanionsSounds.DINAMO_ATTACK.get(), 0.45f, 1.0f);
            }
        }
        if (dinamo.getAttackCycleCounter() >= 60) {
            dinamo.setAttackCycleCounter(0);
            dinamo.entitiesToAttack.clear();
            dinamo.setTargetIds("");
            return;
        }
        dinamo.setAttackCycleCounter(dinamo.getAttackCycleCounter() + 1);
    }

    private void searchForTargets(DinamoEntity dinamo) {
        List list = dinamo.m_9236_().m_6443_(LivingEntity.class, dinamo.m_20191_().m_82400_(10.0), e -> {
            if (Util.areEntitiesLinked((Entity)e, (Entity)dinamo)) {
                return false;
            }
            return e instanceof Monster;
        }).stream().filter(arg_0 -> ((DinamoEntity)dinamo).m_142582_(arg_0)).collect(Collectors.toCollection(ArrayList::new));
        for (LivingEntity m : list) {
            if (dinamo.entitiesToAttack.contains(m)) continue;
            dinamo.entitiesToAttack.add(m);
            dinamo.setTargetIds(dinamo.getTargetIds() + m.m_19879_() + ";");
        }
        if (dinamo.m_5448_() != null) {
            dinamo.entitiesToAttack.add(dinamo.m_5448_());
            dinamo.setTargetIds(dinamo.getTargetIds() + dinamo.m_5448_().m_19879_() + ";");
        }
    }
}

