/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat.crafttweaker;

import com.blakebr0.mysticalagriculture.api.crafting.ISouliumSpawnerRecipe;
import com.blakebr0.mysticalagriculture.crafting.recipe.SouliumSpawnerRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.ForgeRegistries;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.mysticalagriculture.SouliumSpawnerCrafting")
@ZenRegister
public final class SouliumSpawnerCrafting
implements IRecipeManager<ISouliumSpawnerRecipe> {
    private static final SouliumSpawnerCrafting INSTANCE = new SouliumSpawnerCrafting();

    public RecipeType<ISouliumSpawnerRecipe> getRecipeType() {
        return (RecipeType)ModRecipeTypes.SOULIUM_SPAWNER.get();
    }

    @ZenCodeType.Method
    public static void addRecipe(String name, IIngredient input, int inputCount, String[] entities) {
        ResourceLocation id = CraftTweakerConstants.rl((String)INSTANCE.fixRecipeName(name));
        SouliumSpawnerRecipe recipe = new SouliumSpawnerRecipe(id, input.asVanillaIngredient(), inputCount, SouliumSpawnerCrafting.toEntityTypeList(entities));
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)INSTANCE, (Recipe)recipe));
    }

    @ZenCodeType.Method
    public static void remove(String entity) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)INSTANCE, recipe -> recipe.getEntityTypes().m_146338_().stream().anyMatch(e -> {
            ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)e.m_146310_()));
            return id != null && id.toString().equals(entity);
        })));
    }

    private static WeightedRandomList<WeightedEntry.Wrapper<EntityType<?>>> toEntityTypeList(String[] entities) {
        ArrayList<WeightedEntry.Wrapper> entityTypes = new ArrayList<WeightedEntry.Wrapper>();
        for (String entity : entities) {
            int weight;
            String[] entityIDParts = entity.split("@");
            ResourceLocation entityTypeID = new ResourceLocation(entityIDParts[0]);
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityTypeID);
            if (entityType != null) {
                weight = 1;
                if (entityIDParts.length > 1) {
                    weight = Integer.parseInt(entityIDParts[1]);
                }
            } else {
                throw new RuntimeException("Unknown entity type: " + entityTypeID);
            }
            entityTypes.add(WeightedEntry.m_146290_((Object)entityType, (int)weight));
        }
        return WeightedRandomList.m_146328_(entityTypes);
    }
}

