/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.common.block.regular.entity;

import com.progwml6.ironchest.common.block.IronChestsTypes;
import com.progwml6.ironchest.common.block.regular.AbstractIronChestBlock;
import com.progwml6.ironchest.common.inventory.IronChestMenu;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractIronChestBlockEntity
extends RandomizableContainerBlockEntity
implements LidBlockEntity {
    private static final int EVENT_SET_OPEN_COUNT = 1;
    private NonNullList<ItemStack> items;
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState blockState) {
            AbstractIronChestBlockEntity.playSound(level, pos, blockState, SoundEvents.f_11749_);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState blockState) {
            AbstractIronChestBlockEntity.playSound(level, pos, blockState, SoundEvents.f_11747_);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState blockState, int previousCount, int newCount) {
            AbstractIronChestBlockEntity.this.signalOpenCount(level, pos, blockState, previousCount, newCount);
        }

        protected boolean m_142718_(Player player) {
            if (!(player.f_36096_ instanceof IronChestMenu)) {
                return false;
            }
            Container container = ((IronChestMenu)player.f_36096_).getContainer();
            return container instanceof AbstractIronChestBlockEntity || container instanceof CompoundContainer && ((CompoundContainer)container).m_18927_((Container)AbstractIronChestBlockEntity.this);
        }
    };
    private final ChestLidController chestLidController = new ChestLidController();
    private final IronChestsTypes chestType;
    private final Supplier<Block> blockToUse;

    protected AbstractIronChestBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState, IronChestsTypes chestTypeIn, Supplier<Block> blockToUseIn) {
        super(blockEntityType, blockPos, blockState);
        this.items = NonNullList.m_122780_((int)chestTypeIn.size, (Object)ItemStack.f_41583_);
        this.chestType = chestTypeIn;
        this.blockToUse = blockToUseIn;
    }

    public int m_6643_() {
        return this.m_7086_().size();
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)("ironchest.container." + this.chestType.getId() + "_chest"));
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(compoundTag)) {
            ContainerHelper.m_18980_((CompoundTag)compoundTag, this.items);
        }
    }

    public void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        if (!this.m_59634_(compoundTag)) {
            ContainerHelper.m_18973_((CompoundTag)compoundTag, this.items);
        }
    }

    public static void lidAnimateTick(Level level, BlockPos blockPos, BlockState blockState, AbstractIronChestBlockEntity chestBlockEntity) {
        chestBlockEntity.chestLidController.m_155374_();
    }

    static void playSound(Level level, BlockPos blockPos, BlockState blockState, SoundEvent soundEvent) {
        double d0 = (double)blockPos.m_123341_() + 0.5;
        double d1 = (double)blockPos.m_123342_() + 0.5;
        double d2 = (double)blockPos.m_123343_() + 0.5;
        level.m_6263_((Player)null, d0, d1, d2, soundEvent, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.chestLidController.m_155377_(type > 0);
            return true;
        }
        return super.m_7531_(id, type);
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    public void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.items = NonNullList.m_122780_((int)this.getChestType().size, (Object)ItemStack.f_41583_);
        for (int i = 0; i < itemsIn.size(); ++i) {
            if (i >= this.items.size()) continue;
            this.m_7086_().set(i, (Object)((ItemStack)itemsIn.get(i)));
        }
    }

    public float m_6683_(float partialTicks) {
        return this.chestLidController.m_155375_(partialTicks);
    }

    public static int getOpenCount(BlockGetter blockGetter, BlockPos blockPos) {
        BlockEntity blockentity;
        BlockState blockstate = blockGetter.m_8055_(blockPos);
        if (blockstate.m_155947_() && (blockentity = blockGetter.m_7702_(blockPos)) instanceof AbstractIronChestBlockEntity) {
            return ((AbstractIronChestBlockEntity)blockentity).openersCounter.m_155450_();
        }
        return 0;
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    protected void signalOpenCount(Level level, BlockPos blockPos, BlockState blockState, int previousCount, int newCount) {
        Block block = blockState.m_60734_();
        level.m_7696_(blockPos, block, 1, newCount);
    }

    public void wasPlaced(@Nullable LivingEntity livingEntity, ItemStack stack) {
    }

    public void removeAdornments() {
    }

    public IronChestsTypes getChestType() {
        IronChestsTypes typeFromBlock;
        IronChestsTypes type = IronChestsTypes.IRON;
        if (this.m_58898_() && (typeFromBlock = AbstractIronChestBlock.getTypeFromBlock(this.m_58900_().m_60734_())) != null) {
            type = typeFromBlock;
        }
        return type;
    }

    public Block getBlockToUse() {
        return this.blockToUse.get();
    }
}

