/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.widgets.relic;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.ITickingWidget;
import it.hurts.sskirillss.relics.client.screen.description.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.data.ExperienceParticleData;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;

public class RelicExperienceWidget
extends AbstractDescriptionWidget
implements IHoverableWidget,
ITickingWidget {
    private static final int FILLER_WIDTH = 125;
    private final RelicDescriptionScreen screen;

    public RelicExperienceWidget(int x, int y, RelicDescriptionScreen screen) {
        super(x, y, 139, 15);
        this.screen = screen;
    }

    public void m_87963_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Item item;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !((item = this.screen.stack.m_41720_()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        float color = (float)((double)1.025f + Math.sin((float)player.f_19797_ * 0.5f) * (double)0.05f);
        RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
        RenderSystem.enableBlend();
        guiGraphics.m_280163_(DescriptionTextures.EXPERIENCE_FILLER, this.m_252754_() + 3, this.m_252907_() + 2, 0.0f, 0.0f, this.calculateFillerWidth(relic), 11, 125, 11);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.m_274382_()) {
            guiGraphics.m_280163_(DescriptionTextures.EXPERIENCE_OUTLINE, this.m_252754_() - 1, this.m_252907_() - 6, 0.0f, 0.0f, 141, 23, 141, 23);
        }
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        MutableComponent percentage = Component.m_237113_((String)(relic.isMaxLevel(this.screen.stack) ? "MAX" : MathUtils.round(this.calculateFillerPercentage(relic), 1) + "%")).m_130940_(ChatFormatting.BOLD);
        guiGraphics.m_280614_(this.MC.f_91062_, (Component)percentage, (this.m_252754_() + 67) * 2 - this.MC.f_91062_.m_92852_((FormattedText)percentage) / 2, (this.m_252907_() + 6) * 2, 6696723, false);
        poseStack.m_85849_();
    }

    @Override
    public void onTick() {
        IRelicItem relic;
        block6: {
            block5: {
                Item item = this.screen.stack.m_41720_();
                if (!(item instanceof IRelicItem)) break block5;
                relic = (IRelicItem)item;
                if (this.MC.f_91074_ != null) break block6;
            }
            return;
        }
        RandomSource random = this.MC.f_91074_.m_217043_();
        int fillerWidth = this.calculateFillerWidth(relic);
        if (this.MC.f_91074_.f_19797_ % 5 == 0) {
            for (float i = 0.0f; i < (float)fillerWidth / 40.0f; i += 1.0f) {
                ParticleStorage.addParticle(this.screen, new ExperienceParticleData(new Color(200, 255, 0), this.m_252754_() + 5 + random.m_188503_(fillerWidth), this.m_252907_() + random.m_188503_(2), 1.0f + random.m_188501_() * 0.25f, 50 + random.m_188503_(50)));
            }
        }
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Item item = this.screen.stack.m_41720_();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        PoseStack poseStack = guiGraphics.m_280168_();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 150;
        int renderWidth = 0;
        int level = relic.getLevel(this.screen.stack);
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.m_237113_((String)"").m_7220_((Component)Component.m_237115_((String)"tooltip.relics.researching.relic.experience.title").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.UNDERLINE)).m_130946_(" " + (String)(relic.isMaxLevel(this.screen.stack) ? "MAX" : relic.getExperience(this.screen.stack) + "/" + relic.getExperienceBetweenLevels(level, level + 1))), Component.m_237113_((String)" ")});
        if (Screen.m_96638_()) {
            entries.add(Component.m_237115_((String)"tooltip.relics.researching.relic.experience.extra_info").m_130940_(ChatFormatting.ITALIC));
        } else {
            entries.add(Component.m_237115_((String)"tooltip.relics.researching.general.extra_info"));
        }
        for (MutableComponent entry : entries) {
            int entryWidth = this.MC.f_91062_.m_92852_((FormattedText)entry) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth + 2, maxWidth);
            }
            tooltip.addAll(this.MC.f_91062_.m_92923_((FormattedText)entry, maxWidth * 2));
        }
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 100.0f);
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, tooltip.size() * 5, mouseX - 9 - renderWidth / 2, mouseY);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        int yOff = 0;
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.m_280649_(this.MC.f_91062_, entry, (mouseX - renderWidth / 2 + 1) * 2, (mouseY + yOff + 9) * 2, 6696723, false);
            yOff += 5;
        }
        poseStack.m_85849_();
    }

    @Override
    public void m_7435_(SoundManager handler) {
    }

    private float calculateFillerPercentage(IRelicItem relic) {
        int level = relic.getLevel(this.screen.stack);
        return (float)relic.getExperience(this.screen.stack) / ((float)relic.getExperienceBetweenLevels(level, level + 1) / 100.0f);
    }

    private int calculateFillerWidth(IRelicItem relic) {
        return relic.isMaxLevel(this.screen.stack) ? 125 : (int)Math.ceil(this.calculateFillerPercentage(relic) / 100.0f * 125.0f);
    }
}

