/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.data.model;

import com.google.common.base.Preconditions;
import dev.felnull.otyacraftengine.data.model.impl.FileTextureImpl;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public interface FileTexture {
    @NotNull
    public static FileTexture of(@NotNull ResourceLocation textureLocation) {
        Preconditions.checkNotNull((Object)textureLocation, (Object)"TextureLocation is Null");
        return new FileTextureImpl(textureLocation, true);
    }

    @NotNull
    public static FileTexture ofUncheck(@NotNull ResourceLocation textureLocation) {
        Preconditions.checkNotNull((Object)textureLocation, (Object)"TextureLocation is Null");
        return new FileTextureImpl(textureLocation, false);
    }

    @NotNull
    public static FileTexture of(@NotNull ResourceLocation textureLocation, boolean existingCheck) {
        Preconditions.checkNotNull((Object)textureLocation, (Object)"TextureLocation is Null");
        return new FileTextureImpl(textureLocation, existingCheck);
    }

    @NotNull
    public ResourceLocation getLocation();

    public boolean isExistingCheck();
}

