/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.include.dev.felnull.fnjl.math;

import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.math.FNVec2d;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNMath;
import java.util.Objects;

public class FN2dLine {
    private FNVec2d from;
    private FNVec2d to;

    public FN2dLine(FNVec2d from, FNVec2d to) {
        this.from = from;
        this.to = to;
    }

    public FN2dLine(double fromX, double fromY, double toX, double toY) {
        this(new FNVec2d(fromX, fromY), new FNVec2d(toX, toY));
    }

    public FNVec2d getFrom() {
        return this.from;
    }

    public FNVec2d getTo() {
        return this.to;
    }

    public void setFrom(FNVec2d from) {
        this.from = from;
    }

    public void setTo(FNVec2d to) {
        this.to = to;
    }

    public double getFromX() {
        return this.from.getX();
    }

    public double getFromY() {
        return this.from.getY();
    }

    public double getToX() {
        return this.to.getX();
    }

    public double getToY() {
        return this.to.getY();
    }

    public FNVec2d getIntersectPoint(FN2dLine line) {
        return FNMath.getLinesIntersectPoint(this, line);
    }

    public boolean isOnPoint(FNVec2d point) {
        return FNMath.isPointOnLine(this, point);
    }

    public String toString() {
        return "FN2dLine{from=" + this.from + ", to=" + this.to + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FN2dLine fn2dLine = (FN2dLine)o;
        return Objects.equals(this.from, fn2dLine.from) && Objects.equals(this.to, fn2dLine.to);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }
}

