/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.item.location;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import dev.felnull.otyacraftengine.item.location.PlayerItemLocation;
import dev.felnull.otyacraftengine.item.location.factory.HandItemLocationFactory;
import dev.felnull.otyacraftengine.item.location.factory.PlayerItemLocationFactory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class PlayerItemLocations {
    private static final BiMap<ResourceLocation, PlayerItemLocationFactory<? extends PlayerItemLocation>> FACTORS = HashBiMap.create();
    public static final HandItemLocationFactory HAND_ITEM = new HandItemLocationFactory();

    public static void init() {
        PlayerItemLocations.register(new ResourceLocation("otyacraftengine", "hand"), HAND_ITEM);
    }

    private static void register(ResourceLocation location, PlayerItemLocationFactory<? extends PlayerItemLocation> factory) {
        FACTORS.put((Object)location, factory);
    }

    public static ResourceLocation getResourceLocationByFactory(PlayerItemLocationFactory<? extends PlayerItemLocation> factory) {
        return (ResourceLocation)FACTORS.inverse().get(factory);
    }

    public static CompoundTag saveToTag(PlayerItemLocation location) {
        ResourceLocation rl = location.getFactory().getLocation();
        if (rl == null) {
            throw new IllegalArgumentException("Unregistered player item location");
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", rl.toString());
        tag.m_128365_("data", (Tag)location.createTag());
        return tag;
    }

    public static PlayerItemLocation loadFromTag(CompoundTag tag) {
        ResourceLocation rl = new ResourceLocation(tag.m_128461_("id"));
        PlayerItemLocationFactory factory = (PlayerItemLocationFactory)FACTORS.get((Object)rl);
        if (factory == null) {
            throw new IllegalArgumentException("Unregistered player item location");
        }
        return factory.create(tag.m_128469_("data"));
    }
}

