/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.mixin.client;

import dev.felnull.otyacraftengine.client.event.OEClientEventHooks;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class})
public class HumanoidModelMixin<T extends LivingEntity> {
    @Inject(method={"poseRightArm"}, at={@At(value="HEAD")}, cancellable=true)
    private void poseRightArm(T livingEntity, CallbackInfo ci) {
        InteractionHand hand;
        InteractionHand interactionHand = hand = livingEntity.m_5737_() == HumanoidArm.RIGHT ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        if (!OEClientEventHooks.onPoseHumanoidArm(HumanoidArm.RIGHT, hand, (HumanoidModel<? extends LivingEntity>)((HumanoidModel)this), livingEntity)) {
            ci.cancel();
        }
    }

    @Inject(method={"poseLeftArm"}, at={@At(value="HEAD")}, cancellable=true)
    private void poseLeftArm(T livingEntity, CallbackInfo ci) {
        InteractionHand hand;
        InteractionHand interactionHand = hand = livingEntity.m_5737_() == HumanoidArm.LEFT ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        if (!OEClientEventHooks.onPoseHumanoidArm(HumanoidArm.LEFT, hand, (HumanoidModel<? extends LivingEntity>)((HumanoidModel)this), livingEntity)) {
            ci.cancel();
        }
    }

    @Inject(method={"poseRightArm"}, at={@At(value="TAIL")})
    private void poseRightArmPost(T livingEntity, CallbackInfo ci) {
        InteractionHand hand = livingEntity.m_5737_() == HumanoidArm.RIGHT ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        OEClientEventHooks.onPoseHumanoidArmPost(HumanoidArm.RIGHT, hand, (HumanoidModel<? extends LivingEntity>)((HumanoidModel)this), livingEntity);
    }

    @Inject(method={"poseLeftArm"}, at={@At(value="TAIL")})
    private void poseLeftArmPost(T livingEntity, CallbackInfo ci) {
        InteractionHand hand = livingEntity.m_5737_() == HumanoidArm.LEFT ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        OEClientEventHooks.onPoseHumanoidArmPost(HumanoidArm.LEFT, hand, (HumanoidModel<? extends LivingEntity>)((HumanoidModel)this), livingEntity);
    }

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="TAIL")})
    private void setupAnim(T livingEntity, float f, float g, float h, float i, float j, CallbackInfo ci) {
        OEClientEventHooks.onSetupHumanoidAnimPost((HumanoidModel<? extends LivingEntity>)((HumanoidModel)this), livingEntity, f, g, h, i, j);
    }
}

