/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.shape;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import dev.felnull.otyacraftengine.client.shape.ClientIVShapeManager;
import dev.felnull.otyacraftengine.shape.IkisugiVoxelShape;
import dev.felnull.otyacraftengine.shape.RotateAngledAxis;
import dev.felnull.otyacraftengine.shape.VoxelEdge;
import dev.felnull.otyacraftengine.shape.VoxelEntry;
import dev.felnull.otyacraftengine.shape.VoxelPose;
import dev.felnull.otyacraftengine.util.OEVoxelShapeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.ArrayUtils;

public class IkisugiVoxelShapes {
    private static final IkisugiVoxelShapes INSTANCE = new IkisugiVoxelShapes();

    public static IkisugiVoxelShapes getInstance() {
        return INSTANCE;
    }

    public VoxelShape getShapeFromJson(JsonObject shapeJson, ResourceLocation location) {
        JsonElement version = shapeJson.get("version");
        if (version != null && version.isJsonPrimitive()) {
            if (version.getAsInt() == 2) {
                return this.getShapeFromJsonV2(shapeJson, location);
            }
            if (version.getAsInt() == 3) {
                return this.getShapeFromJsonV3(shapeJson, location);
            }
            if (version.getAsInt() >= 4) {
                throw new IllegalStateException("Not support ikisugi voxel shape version: " + version.getAsInt());
            }
        }
        return this.getShapeFromJsonV1(shapeJson);
    }

    private VoxelShape getShapeFromJsonV1(JsonObject shapeJ) {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        for (JsonElement jshape : shapeJ.getAsJsonArray("shapes")) {
            JsonArray ja = jshape.getAsJsonArray();
            VoxelShape shape = OEVoxelShapeUtils.makeBox(ja.get(0).getAsDouble(), ja.get(1).getAsDouble(), ja.get(2).getAsDouble(), ja.get(3).getAsDouble(), ja.get(4).getAsDouble(), ja.get(5).getAsDouble());
            shapes.add(shape);
        }
        return OEVoxelShapeUtils.uniteBox(shapes);
    }

    private VoxelShape getShapeFromJsonV2(JsonObject shapeJ, ResourceLocation location) {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        for (JsonElement jshape : shapeJ.getAsJsonArray("shapes")) {
            JsonArray ja = jshape.getAsJsonArray();
            VoxelShape shape = OEVoxelShapeUtils.makeBox(ja.get(0).getAsDouble() * 16.0, ja.get(1).getAsDouble() * 16.0, ja.get(2).getAsDouble() * 16.0, ja.get(3).getAsDouble() * 16.0, ja.get(4).getAsDouble() * 16.0, ja.get(5).getAsDouble() * 16.0);
            shapes.add(shape);
        }
        VoxelShape shape = OEVoxelShapeUtils.uniteBox(shapes);
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> {
            HashSet<VoxelEdge> edges = new HashSet<VoxelEdge>();
            for (JsonElement jshape : shapeJ.getAsJsonArray("edges")) {
                VoxelEdge ed = VoxelEdge.parse(jshape.getAsJsonArray());
                if (ed == null) continue;
                edges.add(ed);
            }
            ClientIVShapeManager.getInstance().addLegacyShapes(location, edges);
        });
        ((IkisugiVoxelShape)shape).setRenderEdges(new VoxelEntry(location));
        return shape;
    }

    private VoxelShape getShapeFromJsonV3(JsonObject shapeJ, ResourceLocation location) {
        ResourceLocation relocation;
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        for (JsonElement jshape : shapeJ.getAsJsonArray("shapes")) {
            JsonArray ja = jshape.getAsJsonArray();
            VoxelShape shape = OEVoxelShapeUtils.makeBox(ja.get(0).getAsDouble() * 16.0, ja.get(1).getAsDouble() * 16.0, ja.get(2).getAsDouble() * 16.0, ja.get(3).getAsDouble() * 16.0, ja.get(4).getAsDouble() * 16.0, ja.get(5).getAsDouble() * 16.0);
            shapes.add(shape);
        }
        VoxelShape shape = OEVoxelShapeUtils.uniteBox(shapes);
        if (shapeJ.has("render_edges") && shapeJ.get("render_edges").isJsonPrimitive()) {
            String reloc = shapeJ.get("render_edges").getAsString();
            relocation = new ResourceLocation(reloc);
        } else {
            relocation = location;
        }
        ((IkisugiVoxelShape)shape).setRenderEdges(new VoxelEntry(relocation));
        return shape;
    }

    public VoxelShape copy(VoxelShape target, IkisugiVoxelShape source) {
        ((IkisugiVoxelShape)target).setRenderEdges(source.getRenderEdges());
        return target;
    }

    public VoxelShape unite(VoxelShape target, VoxelShape ... shapes) {
        Object[] voxelEntries = ((IkisugiVoxelShape)target).getRenderEdges();
        for (VoxelShape shape : shapes) {
            Object[] ve = ((IkisugiVoxelShape)shape).getRenderEdges();
            if (ve == null) continue;
            voxelEntries = (VoxelEntry[])ArrayUtils.addAll((Object[])voxelEntries, (Object[])ve);
        }
        ((IkisugiVoxelShape)target).setRenderEdges((VoxelEntry[])voxelEntries);
        return target;
    }

    public VoxelShape unite(VoxelShape target, List<IkisugiVoxelShape> shapes) {
        Object[] voxelEntries = ((IkisugiVoxelShape)target).getRenderEdges();
        for (IkisugiVoxelShape shape : shapes) {
            Object[] ve = shape.getRenderEdges();
            if (ve == null) continue;
            voxelEntries = (VoxelEntry[])ArrayUtils.addAll((Object[])voxelEntries, (Object[])ve);
        }
        ((IkisugiVoxelShape)target).setRenderEdges((VoxelEntry[])voxelEntries);
        return target;
    }

    public VoxelShape move(VoxelShape target, IkisugiVoxelShape source, double x, double y, double z) {
        if (source.getRenderEdges() == null) {
            return target;
        }
        x /= 16.0;
        y /= 16.0;
        z /= 16.0;
        VoxelEntry[] voxelEntries = null;
        for (VoxelEntry renderEdge : source.getRenderEdges()) {
            VoxelPose pp = renderEdge.getPose();
            voxelEntries = (VoxelEntry[])ArrayUtils.addAll(voxelEntries, (Object[])new VoxelEntry[]{new VoxelEntry(renderEdge.getLocation(), new VoxelPose(pp.x() + x, pp.y() + y, pp.z() + z, pp.axis()))});
        }
        ((IkisugiVoxelShape)target).setRenderEdges(voxelEntries);
        return target;
    }

    public VoxelShape rotate(VoxelShape target, IkisugiVoxelShape source, RotateAngledAxis angledAxis) {
        VoxelEntry[] voxelEntries = null;
        for (VoxelEntry renderEdge : source.getRenderEdges()) {
            VoxelPose pp = renderEdge.getPose();
            voxelEntries = (VoxelEntry[])ArrayUtils.addAll(voxelEntries, (Object[])new VoxelEntry[]{new VoxelEntry(renderEdge.getLocation(), new VoxelPose(pp.x(), pp.y(), pp.z(), (RotateAngledAxis[])ArrayUtils.add((Object[])pp.axis(), (Object)((Object)angledAxis))))});
        }
        ((IkisugiVoxelShape)target).setRenderEdges(voxelEntries);
        return target;
    }
}

