/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery.client.gui.screen;

import immersive_aircraft.client.gui.VehicleScreen;
import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.screen.VehicleScreenHandler;
import immersive_machinery.Common;
import immersive_machinery.client.gui.screen.widgets.ToggleImageButton;
import immersive_machinery.entity.BambooBee;
import immersive_machinery.network.c2s.BambooBeeConfigurationUpdate;
import java.net.URI;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class BambooBeeScreen
extends VehicleScreen {
    private final BambooBee bee;
    private static final ResourceLocation TEXTURE = Common.locate("textures/gui/container/inventory.png");
    private static final Component TEXT_HELP = Component.m_237115_((String)"gui.immersive_machinery.bamboo_bee.help");
    private static final Component TEXT_WHITELIST = Component.m_237115_((String)"gui.immersive_machinery.bamboo_bee.whitelist");
    private static final Component TEXT_BLACKLIST = Component.m_237115_((String)"gui.immersive_machinery.bamboo_bee.blacklist");
    private static final Component TEXT_FILTER_NAME = Component.m_237115_((String)"gui.immersive_machinery.bamboo_bee.filter.name");
    private static final Component TEXT_FILTER_TAG = Component.m_237115_((String)"gui.immersive_machinery.bamboo_bee.filter.tag");

    public BambooBeeScreen(BambooBee bee, VehicleScreenHandler handler, Inventory inventory, Component title) {
        super(handler, inventory, title);
        this.bee = bee;
    }

    protected void addImageButton(int x, int y, int u, int v, Button.OnPress onPress, Component text, boolean pressed) {
        ToggleImageButton b = new ToggleImageButton(this.getX() + x, this.getY() + y, 16, 16, u, v, 16, TEXTURE, 128, 128, onPress, text);
        b.m_257544_(Tooltip.m_257550_((Component)text));
        b.setPressed(pressed);
        this.m_142416_((GuiEventListener)b);
    }

    public void m_7379_() {
        super.m_7379_();
        BambooBee.Configuration c = this.bee.getConfiguration();
        if (c.isDirty()) {
            NetworkHandler.sendToServer((Message)new BambooBeeConfigurationUpdate(this.bee));
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        BambooBee.Configuration c = this.bee.getConfiguration();
        this.addImageButton(50, 20, c.blacklist ? 48 : 64, 80, b -> {
            c.blacklist = !c.blacklist;
            c.setDirty();
            this.m_7856_();
        }, c.blacklist ? TEXT_BLACKLIST : TEXT_WHITELIST, false);
        this.addImageButton(50, 38, c.compareTag ? 0 : 16, 80, b -> {
            c.compareTag = !c.compareTag;
            c.setDirty();
            this.m_7856_();
        }, c.compareTag ? TEXT_FILTER_TAG : TEXT_FILTER_NAME, false);
        this.addImageButton(50, 56, c.order.ordinal() * 16 + 64, 80, b -> {
            c.order = c.order.next();
            c.setDirty();
            this.m_7856_();
        }, (Component)Component.m_237115_((String)("gui.immersive_machinery.bamboo_bee.order." + c.order.name().toLowerCase(Locale.ROOT))), false);
        ImageButton help = new ImageButton(this.getX() + 160, this.getY() + 5, 10, 10, 64, 0, 10, TEXTURE, 128, 128, b -> this.openHelp(), TEXT_HELP);
        help.m_257544_(Tooltip.m_257550_((Component)TEXT_HELP));
        this.m_142416_((GuiEventListener)help);
    }

    private void openHelp() {
        try {
            Util.m_137581_().m_137648_(URI.create("https://github.com/Luke100000/ImmersiveMachinery/wiki/Bamboo-Bee"));
        }
        catch (Exception e) {
            Common.LOGGER.error("Failed to open help page", (Throwable)e);
        }
    }

    public void updateConfigurations() {
        this.m_7856_();
    }
}

