/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.energy;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.IHasTranslationKey;

@NothingNullByDefault
public interface IEnergyConversion
extends IHasTranslationKey {
    public boolean isEnabled();

    default public FloatingLong convertFrom(long energy) {
        if (energy <= 0L) {
            return FloatingLong.ZERO;
        }
        return this.convertInPlaceFrom(FloatingLong.create(energy));
    }

    public FloatingLong convertFrom(FloatingLong var1);

    public FloatingLong convertInPlaceFrom(FloatingLong var1);

    default public int convertToAsInt(FloatingLong joules) {
        return this.convertTo(joules).intValue();
    }

    default public long convertToAsLong(FloatingLong joules) {
        return this.convertTo(joules).longValue();
    }

    public FloatingLong convertTo(FloatingLong var1);

    public FloatingLong convertInPlaceTo(FloatingLong var1);
}

