/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.common.inventory.GuiComponents;
import mekanism.common.registries.MekanismSounds;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GuiDropdown<TYPE extends Enum<TYPE>>
extends GuiTexturedElement {
    private final Consumer<TYPE> handler;
    private final Supplier<TYPE> curType;
    private final TYPE[] options;
    private boolean isOpen;
    private boolean isHolding;

    public GuiDropdown(IGuiWrapper gui, int x, int y, int width, Class<TYPE> enumClass, Supplier<TYPE> curType, Consumer<TYPE> handler) {
        super(GuiInnerScreen.SCREEN, gui, x, y, width, 12);
        this.curType = curType;
        this.handler = handler;
        this.options = (Enum[])enumClass.getEnumConstants();
        this.f_93623_ = true;
        this.clickSound = MekanismSounds.BEEP;
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        super.onClick(mouseX, mouseY, button);
        this.isHolding = true;
        this.setOpen(!this.isOpen || mouseY > (double)(this.m_252907_() + 11));
    }

    @Override
    public void m_7691_(double mouseX, double mouseY) {
        super.m_7691_(mouseX, mouseY);
        if (this.isHolding) {
            this.isHolding = false;
            if (this.isOpen && mouseY > (double)(this.m_252907_() + 11)) {
                this.handler.accept(this.options[this.getHoveredIndex(mouseX, mouseY)]);
                this.setOpen(false);
            }
        }
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        int maxWidth = this.f_93618_ - 11;
        Enum current = (Enum)this.curType.get();
        this.drawScaledTextScaledBound(guiGraphics, ((GuiComponents.IDropdownEnum)((Object)current)).getShortName(), this.relativeX + 4, this.relativeY + 2, this.screenTextColor(), maxWidth, 0.8f);
        if (this.isOpen) {
            for (int i = 0; i < this.options.length; ++i) {
                this.drawScaledTextScaledBound(guiGraphics, ((GuiComponents.IDropdownEnum)this.options[i]).getShortName(), this.relativeX + 4, this.relativeY + 11 + 2 + 10 * i, this.screenTextColor(), maxWidth, 0.8f);
            }
        }
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Enum current;
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_(0.0f, 0.0f, 1.0f);
        this.renderBackgroundTexture(guiGraphics, this.getResource(), GuiInnerScreen.SCREEN_SIZE, GuiInnerScreen.SCREEN_SIZE);
        int index = this.getHoveredIndex(mouseX, mouseY);
        if (index != -1) {
            GuiUtils.drawOutline(guiGraphics, this.relativeX + 1, this.relativeY + 12 + index * 10, this.f_93618_ - 2, 10, this.screenTextColor());
        }
        if (((GuiComponents.IDropdownEnum)((Object)(current = (Enum)this.curType.get()))).getIcon() != null) {
            guiGraphics.m_280163_(((GuiComponents.IDropdownEnum)((Object)current)).getIcon(), this.relativeX + this.f_93618_ - 9, this.relativeY + 3, 0.0f, 0.0f, 6, 6, 6, 6);
        }
        if (this.isOpen) {
            for (int i = 0; i < this.options.length; ++i) {
                ResourceLocation icon = ((GuiComponents.IDropdownEnum)this.options[i]).getIcon();
                if (icon == null) continue;
                guiGraphics.m_280163_(icon, this.relativeX + this.f_93618_ - 9, this.relativeY + 12 + 2 + 10 * i, 0.0f, 0.0f, 6, 6, 6, 6);
            }
        }
        pose.m_85849_();
    }

    @Override
    public void renderToolTip(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Component text;
        super.renderToolTip(guiGraphics, mouseX, mouseY);
        int index = this.getHoveredIndex(mouseX, mouseY);
        if (index != -1 && (text = ((GuiComponents.IDropdownEnum)this.options[index]).getTooltip()) != null) {
            this.displayTooltips(guiGraphics, mouseX, mouseY, ((GuiComponents.IDropdownEnum)this.options[index]).getTooltip());
        }
    }

    private int getHoveredIndex(double mouseX, double mouseY) {
        if (this.isOpen && mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)(this.m_252907_() + 11) && mouseY < (double)(this.m_252907_() + this.f_93619_)) {
            return Math.max(0, Math.min(this.options.length - 1, (int)((mouseY - (double)this.m_252907_() - 11.0) / 10.0)));
        }
        return -1;
    }

    private void setOpen(boolean open) {
        if (this.isOpen != open) {
            this.f_93619_ = open ? (this.f_93619_ += this.options.length * 10 + 1) : (this.f_93619_ -= this.options.length * 10 + 1);
        }
        this.isOpen = open;
    }
}

