/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.text.EnumColor;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.lib.inventory.TileTransitRequest;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.EnergySlotInfo;
import mekanism.common.tile.component.config.slot.FluidSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporterBase;
import mekanism.common.util.CableUtils;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileComponentEjector
implements ITileComponent,
MekanismContainer.ISpecificContainerTracker {
    private final TileEntityMekanism tile;
    private final Map<TransmissionType, ConfigInfo> configInfo = new EnumMap<TransmissionType, ConfigInfo>(TransmissionType.class);
    private final EnumColor[] inputColors = new EnumColor[6];
    private final LongSupplier chemicalEjectRate;
    private final IntSupplier fluidEjectRate;
    @Nullable
    private final FloatingLongSupplier energyEjectRate;
    @Nullable
    private Predicate<TransmissionType> canEject;
    @Nullable
    private Predicate<IChemicalTank<?, ?>> canTankEject;
    private boolean strictInput;
    private EnumColor outputColor;
    private int tickDelay = 0;

    public TileComponentEjector(TileEntityMekanism tile) {
        this(tile, MekanismConfig.general.chemicalAutoEjectRate);
    }

    public TileComponentEjector(TileEntityMekanism tile, LongSupplier chemicalEjectRate) {
        this(tile, chemicalEjectRate, MekanismConfig.general.fluidAutoEjectRate);
    }

    public TileComponentEjector(TileEntityMekanism tile, LongSupplier chemicalEjectRate, IntSupplier fluidEjectRate) {
        this(tile, chemicalEjectRate, fluidEjectRate, null);
    }

    public TileComponentEjector(TileEntityMekanism tile, FloatingLongSupplier energyEjectRate) {
        this(tile, MekanismConfig.general.chemicalAutoEjectRate, MekanismConfig.general.fluidAutoEjectRate, energyEjectRate);
    }

    public TileComponentEjector(TileEntityMekanism tile, LongSupplier chemicalEjectRate, IntSupplier fluidEjectRate, @Nullable FloatingLongSupplier energyEjectRate) {
        this.tile = tile;
        this.chemicalEjectRate = chemicalEjectRate;
        this.fluidEjectRate = fluidEjectRate;
        this.energyEjectRate = energyEjectRate;
        tile.addComponent(this);
    }

    public TileComponentEjector setOutputData(TileComponentConfig config, TransmissionType ... types) {
        for (TransmissionType type : types) {
            ConfigInfo info = config.getConfig(type);
            if (info == null) continue;
            this.configInfo.put(type, info);
        }
        return this;
    }

    public TileComponentEjector setCanEject(Predicate<TransmissionType> canEject) {
        this.canEject = canEject;
        return this;
    }

    public TileComponentEjector setCanTankEject(Predicate<IChemicalTank<?, ?>> canTankEject) {
        this.canTankEject = canTankEject;
        return this;
    }

    public boolean isEjecting(ConfigInfo info, TransmissionType type) {
        return info.isEjecting() && (this.canEject == null || this.canEject.test(type));
    }

    public void tickServer() {
        for (Map.Entry<TransmissionType, ConfigInfo> entry : this.configInfo.entrySet()) {
            TransmissionType type = entry.getKey();
            ConfigInfo info = entry.getValue();
            if (!this.isEjecting(info, type)) continue;
            if (type == TransmissionType.ITEM) {
                if (this.tickDelay == 0) {
                    this.outputItems(info);
                    continue;
                }
                --this.tickDelay;
                continue;
            }
            if (type == TransmissionType.HEAT) continue;
            this.eject(type, info);
        }
    }

    private void eject(TransmissionType type, ConfigInfo info) {
        HashMap<Object, Set> outputData = null;
        for (DataType dataType : info.getSupportedDataTypes()) {
            Set<Direction> outputSides;
            ISlotInfo slotInfo;
            if (!dataType.canOutput() || (slotInfo = info.getSlotInfo(dataType)) == null || (outputSides = info.getSidesForData(dataType)).isEmpty()) continue;
            if (outputData == null) {
                outputData = new HashMap<Object, Set>();
            }
            if (type.isChemical() && slotInfo instanceof ChemicalSlotInfo) {
                ChemicalSlotInfo chemicalSlotInfo = (ChemicalSlotInfo)slotInfo;
                for (IChemicalTank iChemicalTank : chemicalSlotInfo.getTanks()) {
                    if (iChemicalTank.isEmpty() || this.canTankEject != null && !this.canTankEject.test(iChemicalTank)) continue;
                    outputData.computeIfAbsent(iChemicalTank, t -> EnumSet.noneOf(Direction.class)).addAll(outputSides);
                }
                continue;
            }
            if (type == TransmissionType.FLUID && slotInfo instanceof FluidSlotInfo) {
                FluidSlotInfo fluidSlotInfo = (FluidSlotInfo)slotInfo;
                for (IExtendedFluidTank iExtendedFluidTank : fluidSlotInfo.getTanks()) {
                    if (iExtendedFluidTank.isEmpty()) continue;
                    outputData.computeIfAbsent(iExtendedFluidTank, t -> EnumSet.noneOf(Direction.class)).addAll(outputSides);
                }
                continue;
            }
            if (type != TransmissionType.ENERGY || !(slotInfo instanceof EnergySlotInfo)) continue;
            EnergySlotInfo energySlotInfo = (EnergySlotInfo)slotInfo;
            for (IEnergyContainer iEnergyContainer : energySlotInfo.getContainers()) {
                if (iEnergyContainer.isEmpty()) continue;
                outputData.computeIfAbsent(iEnergyContainer, t -> EnumSet.noneOf(Direction.class)).addAll(outputSides);
            }
        }
        if (outputData != null && !outputData.isEmpty()) {
            for (Map.Entry entry : outputData.entrySet()) {
                if (type.isChemical()) {
                    ChemicalUtil.emit((Set)entry.getValue(), (IChemicalTank)entry.getKey(), this.tile, this.chemicalEjectRate.getAsLong());
                    continue;
                }
                if (type == TransmissionType.FLUID) {
                    FluidUtils.emit((Set)entry.getValue(), (IExtendedFluidTank)entry.getKey(), this.tile, this.fluidEjectRate.getAsInt());
                    continue;
                }
                if (type != TransmissionType.ENERGY) continue;
                IEnergyContainer container = (IEnergyContainer)entry.getKey();
                CableUtils.emit((Set)entry.getValue(), container, this.tile, this.energyEjectRate == null ? container.getMaxEnergy() : this.energyEjectRate.get());
            }
        }
    }

    private void outputItems(ConfigInfo info) {
        block0: for (DataType dataType : info.getSupportedDataTypes()) {
            EjectTransitRequest ejectMap;
            ISlotInfo slotInfo;
            if (!dataType.canOutput() || !((slotInfo = info.getSlotInfo(dataType)) instanceof InventorySlotInfo)) continue;
            InventorySlotInfo inventorySlotInfo = (InventorySlotInfo)slotInfo;
            Set<Direction> outputs = info.getSidesForData(dataType);
            if (outputs.isEmpty() || (ejectMap = InventoryUtils.getEjectItemMap(new EjectTransitRequest(this.tile, outputs.iterator().next()), inventorySlotInfo.getSlots())).isEmpty()) continue;
            for (Direction side : outputs) {
                TransitRequest.TransitResponse response;
                BlockEntity target = WorldUtils.getTileEntity((BlockGetter)this.tile.m_58904_(), this.tile.m_58899_().m_121945_(side));
                if (target == null) continue;
                ejectMap.side = side;
                if (target instanceof TileEntityLogisticalTransporterBase) {
                    TileEntityLogisticalTransporterBase transporter = (TileEntityLogisticalTransporterBase)target;
                    response = transporter.getTransmitter().insert((BlockEntity)this.tile, (TransitRequest)ejectMap, this.outputColor, true, 0);
                } else {
                    response = ejectMap.addToInventory(target, side, 0, false);
                }
                if (response.isEmpty()) continue;
                response.useAll();
                if (!ejectMap.isEmpty()) continue;
                continue block0;
            }
        }
        this.tickDelay = 10;
    }

    @ComputerMethod
    public boolean hasStrictInput() {
        return this.strictInput;
    }

    public void setStrictInput(boolean strict) {
        if (this.strictInput != strict) {
            this.strictInput = strict;
            this.tile.markForSave();
        }
    }

    @ComputerMethod
    public EnumColor getOutputColor() {
        return this.outputColor;
    }

    public void setOutputColor(EnumColor color) {
        if (this.outputColor != color) {
            this.outputColor = color;
            this.tile.markForSave();
        }
    }

    public boolean isInputSideEnabled(@NotNull RelativeSide side) {
        ConfigInfo info = this.configInfo.get(TransmissionType.ITEM);
        return info == null || info.isSideEnabled(side);
    }

    public void setInputColor(RelativeSide side, EnumColor color) {
        int ordinal;
        if (this.isInputSideEnabled(side) && this.inputColors[ordinal = side.ordinal()] != color) {
            this.inputColors[ordinal] = color;
            this.tile.markForSave();
        }
    }

    @ComputerMethod
    public EnumColor getInputColor(RelativeSide side) {
        return this.inputColors[side.ordinal()];
    }

    @Override
    public void read(CompoundTag nbtTags) {
        NBTUtils.setCompoundIfPresent(nbtTags, "componentEjector", ejectorNBT -> {
            this.strictInput = ejectorNBT.m_128471_("strictInput");
            NBTUtils.setEnumIfPresent(ejectorNBT, "color", TransporterUtils::readColor, color -> {
                this.outputColor = color;
            });
            int i = 0;
            while (i < EnumUtils.DIRECTIONS.length) {
                int index = i++;
                NBTUtils.setEnumIfPresent(ejectorNBT, "color" + index, TransporterUtils::readColor, color -> {
                    this.inputColors[index] = color;
                });
            }
        });
    }

    @Override
    public void write(CompoundTag nbtTags) {
        CompoundTag ejectorNBT = new CompoundTag();
        ejectorNBT.m_128379_("strictInput", this.strictInput);
        if (this.outputColor != null) {
            ejectorNBT.m_128405_("color", TransporterUtils.getColorIndex(this.outputColor));
        }
        for (int i = 0; i < EnumUtils.DIRECTIONS.length; ++i) {
            ejectorNBT.m_128405_("color" + i, TransporterUtils.getColorIndex(this.inputColors[i]));
        }
        nbtTags.m_128365_("componentEjector", (Tag)ejectorNBT);
    }

    @Override
    public List<ISyncableData> getSpecificSyncableData() {
        ArrayList<ISyncableData> list = new ArrayList<ISyncableData>();
        list.add(SyncableBoolean.create(this::hasStrictInput, input -> {
            this.strictInput = input;
        }));
        list.add(SyncableInt.create(() -> TransporterUtils.getColorIndex(this.outputColor), index -> {
            this.outputColor = TransporterUtils.readColor(index);
        }));
        int i = 0;
        while (i < EnumUtils.DIRECTIONS.length) {
            int idx = i++;
            list.add(SyncableInt.create(() -> TransporterUtils.getColorIndex(this.inputColors[idx]), index -> {
                this.inputColors[idx] = TransporterUtils.readColor(index);
            }));
        }
        return list;
    }

    @ComputerMethod(nameOverride="setStrictInput", requiresPublicSecurity=true)
    void computerSetStrictInput(boolean strict) throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.setStrictInput(strict);
    }

    private void validateInputSide(RelativeSide side) throws ComputerException {
        if (!this.isInputSideEnabled(side)) {
            throw new ComputerException("Side '%s' is disabled and can't be configured.", side);
        }
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void clearInputColor(RelativeSide side) throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.validateInputSide(side);
        this.setInputColor(side, null);
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void incrementInputColor(RelativeSide side) throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.validateInputSide(side);
        int ordinal = side.ordinal();
        this.inputColors[ordinal] = TransporterUtils.increment(this.inputColors[ordinal]);
        this.tile.markForSave();
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void decrementInputColor(RelativeSide side) throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.validateInputSide(side);
        int ordinal = side.ordinal();
        this.inputColors[ordinal] = TransporterUtils.decrement(this.inputColors[ordinal]);
        this.tile.markForSave();
    }

    @ComputerMethod(nameOverride="setInputColor", requiresPublicSecurity=true)
    void computerSetInputColor(RelativeSide side, EnumColor color) throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.validateInputSide(side);
        if (!TransporterUtils.colors.contains(color)) {
            throw new ComputerException("Color '%s' is not a supported transporter color.", color);
        }
        this.setInputColor(side, color);
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void clearOutputColor() throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.setOutputColor(null);
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void incrementOutputColor() throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.outputColor = TransporterUtils.increment(this.outputColor);
        this.tile.markForSave();
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void decrementOutputColor() throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.outputColor = TransporterUtils.decrement(this.outputColor);
        this.tile.markForSave();
    }

    @ComputerMethod(nameOverride="setOutputColor", requiresPublicSecurity=true)
    void computerSetOutputColor(EnumColor color) throws ComputerException {
        this.tile.validateSecurityIsPublic();
        if (!TransporterUtils.colors.contains(color)) {
            throw new ComputerException("Color '%s' is not a supported transporter color.", color);
        }
        this.setOutputColor(color);
    }

    private static class EjectTransitRequest
    extends TileTransitRequest {
        public Direction side;

        public EjectTransitRequest(BlockEntity tile, Direction side) {
            super(tile, side);
            this.side = side;
        }

        @Override
        public Direction getSide() {
            return this.side;
        }
    }
}

