/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import mekanism.api.math.MathUtils;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.content.qio.filter.QIOItemStackFilter;
import mekanism.common.content.qio.filter.QIOModIDFilter;
import mekanism.common.content.qio.filter.QIOTagFilter;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.qio.TileEntityQIOFilterHandler;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class TileEntityQIOExporter
extends TileEntityQIOFilterHandler {
    private static final int MAX_DELAY = 10;
    private int delay = 0;
    private boolean exportWithoutFilter;
    private final EfficientEjector<Object2LongMap.Entry<HashedItem>> filterEjector = new EfficientEjector<Object2LongMap.Entry>(Map.Entry::getKey, e -> MathUtils.clampToInt(e.getLongValue()), freq -> this.getFilterEjectMap((QIOFrequency)freq).object2LongEntrySet());
    private final EfficientEjector<Map.Entry<HashedItem, QIOFrequency.QIOItemTypeData>> filterlessEjector = new EfficientEjector<Map.Entry>(Map.Entry::getKey, e -> MathUtils.clampToInt(((QIOFrequency.QIOItemTypeData)e.getValue()).getCount()), freq -> freq.getItemDataMap().entrySet());

    public TileEntityQIOExporter(BlockPos pos, BlockState state) {
        super(MekanismBlocks.QIO_EXPORTER, pos, state);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (MekanismUtils.canFunction(this)) {
            if (this.delay > 0) {
                --this.delay;
                return;
            }
            this.tryEject();
            this.delay = 10;
        }
    }

    private void tryEject() {
        EfficientEjector<Object> ejector;
        QIOFrequency freq = this.getQIOFrequency();
        if (freq == null) {
            return;
        }
        Direction direction = this.getDirection();
        BlockEntity back = WorldUtils.getTileEntity((BlockGetter)this.m_58904_(), this.f_58858_.m_121945_(direction.m_122424_()));
        LazyOptional backHandler = CapabilityUtils.getCapability((ICapabilityProvider)back, ForgeCapabilities.ITEM_HANDLER, direction);
        if (!backHandler.isPresent()) {
            return;
        }
        if (this.getFilterManager().hasEnabledFilters()) {
            ejector = this.filterEjector;
        } else if (this.exportWithoutFilter) {
            ejector = this.filterlessEjector;
        } else {
            return;
        }
        ejector.eject(freq, (IItemHandler)backHandler.orElseThrow(MekanismUtils.MISSING_CAP_ERROR));
    }

    private Object2LongMap<HashedItem> getFilterEjectMap(QIOFrequency freq) {
        Object2LongOpenHashMap map = new Object2LongOpenHashMap();
        for (QIOFilter filter : this.getFilterManager().getEnabledFilters()) {
            if (filter instanceof QIOItemStackFilter) {
                QIOItemStackFilter itemFilter = (QIOItemStackFilter)filter;
                if (itemFilter.fuzzyMode) {
                    map.putAll(freq.getStacksByItem(itemFilter.getItemStack().m_41720_()));
                    continue;
                }
                HashedItem type = HashedItem.create(itemFilter.getItemStack());
                map.put((Object)type, freq.getStored(type));
                continue;
            }
            if (filter instanceof QIOTagFilter) {
                QIOTagFilter tagFilter = (QIOTagFilter)filter;
                String tagName = tagFilter.getTagName();
                map.putAll(freq.getStacksByTagWildcard(tagName));
                continue;
            }
            if (!(filter instanceof QIOModIDFilter)) continue;
            QIOModIDFilter modIDFilter = (QIOModIDFilter)filter;
            String modID = modIDFilter.getModID();
            map.putAll(freq.getStacksByModIDWildcard(modID));
        }
        return map;
    }

    @ComputerMethod
    public boolean getExportWithoutFilter() {
        return this.exportWithoutFilter;
    }

    public void toggleExportWithoutFilter() {
        this.exportWithoutFilter = !this.exportWithoutFilter;
        this.markForSave();
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(this::getExportWithoutFilter, value -> {
            this.exportWithoutFilter = value;
        }));
    }

    @Override
    public void writeSustainedData(CompoundTag dataMap) {
        super.writeSustainedData(dataMap);
        dataMap.m_128379_("auto", this.exportWithoutFilter);
    }

    @Override
    public void readSustainedData(CompoundTag dataMap) {
        super.readSustainedData(dataMap);
        NBTUtils.setBooleanIfPresent(dataMap, "auto", value -> {
            this.exportWithoutFilter = value;
        });
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Map<String, String> remap = super.getTileDataRemap();
        remap.put("auto", "auto");
        return remap;
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setExportsWithoutFilter(boolean value) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.exportWithoutFilter != value) {
            this.toggleExportWithoutFilter();
        }
    }

    private final class EfficientEjector<T> {
        private static final double MAX_EJECT_ATTEMPTS = 100.0;
        private final Function<QIOFrequency, Collection<T>> ejectMapCalculator;
        private final Function<T, HashedItem> typeSupplier;
        private final ToIntFunction<T> countSupplier;

        private EfficientEjector(Function<T, HashedItem> typeSupplier, ToIntFunction<T> countSupplier, Function<QIOFrequency, Collection<T>> ejectMapCalculator) {
            this.typeSupplier = typeSupplier;
            this.countSupplier = countSupplier;
            this.ejectMapCalculator = ejectMapCalculator;
        }

        private void eject(QIOFrequency freq, IItemHandler inventory) {
            int slots = inventory.getSlots();
            if (slots == 0) {
                return;
            }
            Collection<T> ejectMap = this.ejectMapCalculator.apply(freq);
            if (ejectMap.isEmpty()) {
                return;
            }
            RandomSource random = TileEntityQIOExporter.this.m_58904_().m_213780_();
            double ejectChance = Math.min(1.0, 100.0 / (double)ejectMap.size());
            int maxTypes = TileEntityQIOExporter.this.getMaxTransitTypes();
            int maxCount = TileEntityQIOExporter.this.getMaxTransitCount();
            Object2IntOpenHashMap removed = new Object2IntOpenHashMap();
            int amountRemoved = 0;
            for (T obj : ejectMap) {
                if (amountRemoved == maxCount || removed.size() == maxTypes) break;
                if (random.m_188500_() > ejectChance) continue;
                HashedItem type = this.typeSupplier.apply(obj);
                ItemStack origInsert = type.createStack(Math.min(maxCount - amountRemoved, this.countSupplier.applyAsInt(obj)));
                ItemStack toInsert = origInsert.m_41777_();
                for (int i = 0; i < slots && !(toInsert = inventory.insertItem(i, toInsert, false)).m_41619_(); ++i) {
                }
                ItemStack toUse = TransporterManager.getToUse(origInsert, toInsert);
                if (toUse.m_41619_()) continue;
                amountRemoved += toUse.m_41613_();
                removed.merge((Object)type, toUse.m_41613_(), Integer::sum);
            }
            for (Object2IntMap.Entry entry : removed.object2IntEntrySet()) {
                int amount = entry.getIntValue();
                ItemStack ret = freq.removeByType((HashedItem)entry.getKey(), amount);
                if (ret.m_41613_() == amount) continue;
                Mekanism.logger.error("QIO ejection item removal didn't line up with prediction: removed {}, expected {}", (Object)ret.m_41613_(), (Object)amount);
            }
        }
    }
}

