/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.event;

import com.brutalbosses.entity.capability.BossCapability;
import com.brutalbosses.event.ClientBossEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEventHandler {
    private static Map<Entity, ClientBossUI> bossInfoMap = new HashMap<Entity, ClientBossUI>();

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        bossInfoMap.clear();
        Minecraft.m_91087_().f_91065_.m_93090_().f_93699_.clear();
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.m_9236_().m_5776_() || event.player.m_9236_().m_46467_() % 5L != 0L) {
            return;
        }
        Entity target = Minecraft.m_91087_().f_91077_ != null && Minecraft.m_91087_().f_91077_ instanceof EntityHitResult ? ((EntityHitResult)Minecraft.m_91087_().f_91077_).m_82443_() : null;
        ClientEventHandler.checkEntity(target);
        Iterator<Map.Entry<Entity, ClientBossUI>> iterator = bossInfoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Entity, ClientBossUI> entry = iterator.next();
            entry.getValue().bossInfo.update((LivingEntity)entry.getKey(), entry.getValue().cap);
            if (!entry.getKey().m_6084_() || entry.getValue().timeOut < entry.getKey().m_9236_().m_46467_()) {
                Minecraft.m_91087_().f_91065_.m_93090_().f_93699_.remove(entry.getValue().bossInfo.m_18860_());
                iterator.remove();
                continue;
            }
            if (!event.player.m_142582_(entry.getKey())) continue;
            entry.getValue().timeOut = event.player.m_9236_().m_46467_() + 600L;
        }
    }

    private static ClientBossUI createBossGUI(LivingEntity target, BossCapability cap) {
        ClientBossUI ui = new ClientBossUI(new ClientBossEvent(target, cap), (Entity)target, cap);
        Minecraft.m_91087_().f_91065_.m_93090_().f_93699_.put(ui.bossInfo.m_18860_(), ui.bossInfo);
        return ui;
    }

    public static void checkEntity(Entity target) {
        BossCapability cap;
        if (target instanceof LivingEntity && (cap = (BossCapability)target.getCapability(BossCapability.BOSS_CAP).orElse(null)) != null && cap.isBoss() && cap.getBossType().showBossBar()) {
            if (bossInfoMap.containsKey(target)) {
                ClientBossUI ui = bossInfoMap.get(target);
                ui.timeOut = target.m_9236_().m_46467_() + 600L;
            } else {
                bossInfoMap.put(target, ClientEventHandler.createBossGUI((LivingEntity)target, cap));
            }
        }
    }

    private static class ClientBossUI {
        private ClientBossEvent bossInfo;
        private long timeOut;
        private Entity boss;
        private BossCapability cap;

        private ClientBossUI(ClientBossEvent bossEVent, Entity boss, BossCapability cap) {
            this.bossInfo = bossEVent;
            this.timeOut = boss.m_9236_().m_46467_() + 600L;
            this.boss = boss;
            this.cap = cap;
        }
    }
}

