/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.element.effect;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.tooltips.client.element.QuadPalette;
import dev.obscuria.tooltips.client.element.effect.TooltipEffect;
import dev.obscuria.tooltips.client.particle.GraphicUtils;
import dev.obscuria.tooltips.client.renderer.TooltipContext;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import org.joml.Matrix4f;

public record RimLightEffect(QuadPalette outerPalette, QuadPalette innerPalette) implements TooltipEffect
{
    public static final Codec<RimLightEffect> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)QuadPalette.CODEC.fieldOf("outer_palette").forGetter(RimLightEffect::outerPalette), (App)QuadPalette.CODEC.fieldOf("inner_palette").forGetter(RimLightEffect::innerPalette)).apply((Applicative)codec, RimLightEffect::new));

    public Codec<RimLightEffect> codec() {
        return CODEC;
    }

    @Override
    public boolean canApply(List<TooltipEffect> effects) {
        return effects.stream().noneMatch(it -> it instanceof RimLightEffect);
    }

    @Override
    public void renderBack(GuiGraphics graphics, TooltipContext context, int x, int y, int width, int height) {
        float pX = (float)x - 3.0f;
        float pY = (float)y - 3.0f;
        float pWidth = (float)width + 6.0f;
        float pHeight = (float)height + 6.0f;
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        VertexConsumer buffer = graphics.m_280091_().m_6299_(RenderType.m_286086_());
        float scale = 0.8f + 0.4f * (float)Math.cos(context.timeInSeconds());
        float offset = Math.min(pWidth, pHeight) * 0.25f * scale;
        GraphicUtils.color(buffer.m_252986_(matrix, pX, pY, 0.0f), this.outerPalette.topLeft()).m_5752_();
        GraphicUtils.color(buffer.m_252986_(matrix, pX + offset, pY + offset, 0.0f), this.innerPalette.topLeft()).m_5752_();
        GraphicUtils.color(buffer.m_252986_(matrix, pX + pWidth - offset, pY + offset, 0.0f), this.innerPalette.topRight()).m_5752_();
        GraphicUtils.color(buffer.m_252986_(matrix, pX + pWidth, pY, 0.0f), this.outerPalette.topRight()).m_5752_();
        GraphicUtils.color(buffer.m_252986_(matrix, pX + offset, pY + pHeight - offset, 0.0f), this.innerPalette.bottomLeft()).m_5752_();
        GraphicUtils.color(buffer.m_252986_(matrix, pX, pY + pHeight, 0.0f), this.outerPalette.bottomLeft()).m_5752_();
        GraphicUtils.color(buffer.m_252986_(matrix, pX + pWidth, pY + pHeight, 0.0f), this.outerPalette.bottomRight()).m_5752_();
        GraphicUtils.color(buffer.m_252986_(matrix, pX + pWidth - offset, pY + pHeight - offset, 0.0f), this.innerPalette.bottomRight()).m_5752_();
        GraphicUtils.color(buffer.m_252986_(matrix, pX, pY, 0.0f), this.outerPalette.topLeft()).m_5752_();
        GraphicUtils.color(buffer.m_252986_(matrix, pX, pY + pHeight, 0.0f), this.outerPalette.bottomLeft()).m_5752_();
        GraphicUtils.color(buffer.m_252986_(matrix, pX + offset, pY + pHeight - offset, 0.0f), this.innerPalette.bottomLeft()).m_5752_();
        GraphicUtils.color(buffer.m_252986_(matrix, pX + offset, pY + offset, 0.0f), this.innerPalette.topLeft()).m_5752_();
        GraphicUtils.color(buffer.m_252986_(matrix, pX + pWidth - offset, pY + offset, 0.0f), this.innerPalette.topRight()).m_5752_();
        GraphicUtils.color(buffer.m_252986_(matrix, pX + pWidth - offset, pY + pHeight - offset, 0.0f), this.innerPalette.bottomRight()).m_5752_();
        GraphicUtils.color(buffer.m_252986_(matrix, pX + pWidth, pY + pHeight, 0.0f), this.outerPalette.bottomRight()).m_5752_();
        GraphicUtils.color(buffer.m_252986_(matrix, pX + pWidth, pY, 0.0f), this.outerPalette.topRight()).m_5752_();
    }
}

