/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.filter;

import com.mojang.serialization.Codec;
import dev.obscuria.tooltips.client.filter.AllOfFilter;
import dev.obscuria.tooltips.client.filter.AlwaysFilter;
import dev.obscuria.tooltips.client.filter.AnyOfFilter;
import dev.obscuria.tooltips.client.filter.EnchantmentFilter;
import dev.obscuria.tooltips.client.filter.ItemOrTagFilter;
import dev.obscuria.tooltips.client.filter.ModFilter;
import dev.obscuria.tooltips.client.filter.NbtFilter;
import dev.obscuria.tooltips.client.filter.NeverFilter;
import dev.obscuria.tooltips.client.filter.NoneOfFilter;
import dev.obscuria.tooltips.client.filter.PropertyFilter;
import dev.obscuria.tooltips.client.filter.RarityFilter;
import dev.obscuria.tooltips.registry.TooltipsRegistries;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;

public interface ItemFilter {
    public static final Codec<ItemFilter> CODEC = TooltipsRegistries.ITEM_FILTER_TYPE.byNameCodec().dispatch(ItemFilter::codec, Function.identity());

    public Codec<? extends ItemFilter> codec();

    public boolean test(ItemStack var1);

    public static void bootstrap(BiConsumer<String, Supplier<Codec<? extends ItemFilter>>> registrar) {
        registrar.accept("always", () -> AlwaysFilter.CODEC);
        registrar.accept("never", () -> NeverFilter.CODEC);
        registrar.accept("all_of", () -> AllOfFilter.CODEC);
        registrar.accept("any_of", () -> AnyOfFilter.CODEC);
        registrar.accept("none_of", () -> NoneOfFilter.CODEC);
        registrar.accept("item", () -> ItemOrTagFilter.CODEC);
        registrar.accept("mod", () -> ModFilter.CODEC);
        registrar.accept("enchantment", () -> EnchantmentFilter.CODEC);
        registrar.accept("rarity", () -> RarityFilter.CODEC);
        registrar.accept("nbt", () -> NbtFilter.CODEC);
        registrar.accept("property", () -> PropertyFilter.CODEC);
    }
}

