/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.data.AffixCategory;
import top.theillusivec4.champions.api.data.AffixSetting;
import top.theillusivec4.champions.common.affix.core.AffixData;
import top.theillusivec4.champions.common.affix.core.BasicAffix;
import top.theillusivec4.champions.common.affix.core.GoalCombatAffix;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.rank.RankManager;
import top.theillusivec4.champions.common.registry.ModEntityTypes;

public class InfestedAffix
extends GoalCombatAffix {
    private static void spawnParasites(LivingEntity livingEntity, int amount, @Nullable LivingEntity target, ServerLevel world) {
        boolean isEnder = livingEntity.m_6095_().m_204039_(ModEntityTypes.Tags.IS_ENDER);
        EntityType<?> type = isEnder ? ChampionsConfig.infestedEnderParasite : ChampionsConfig.infestedParasite;
        for (int i = 0; i < amount; ++i) {
            Entity entity = type.m_262451_(world, null, null, livingEntity.m_20183_(), MobSpawnType.MOB_SUMMONED, false, false);
            if (!(entity instanceof LivingEntity)) continue;
            ChampionCapability.getCapability(entity).ifPresent(champion -> champion.getServer().setRank(RankManager.getLowestRank()));
            livingEntity.m_9236_().m_7967_(entity);
            if (!(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            mob.m_21373_();
            mob.m_6703_(target);
            mob.m_6710_(target);
        }
    }

    @Override
    public AffixSetting createDefaultSetting() {
        return AffixSetting.builder().withDefault().setCategory(AffixCategory.OFFENSE).build();
    }

    @Override
    public void onInitialSpawn(IChampion champion) {
        AffixData.IntegerData buffer = AffixData.getData(champion, this.toString(), AffixData.IntegerData.class);
        buffer.num = Math.min(ChampionsConfig.infestedTotal, Math.max(1, (int)((double)champion.getLivingEntity().m_21233_() * ChampionsConfig.infestedPerHealth)));
        buffer.saveData();
    }

    @Override
    public float onHeal(IChampion champion, float amount, float newAmount) {
        if (newAmount > 0.0f && champion.getLivingEntity().m_217043_().m_188501_() < 0.5f) {
            AffixData.IntegerData buffer = AffixData.getData(champion, this.toString(), AffixData.IntegerData.class);
            buffer.num = Math.min(ChampionsConfig.infestedTotal, buffer.num + 2);
            buffer.saveData();
            return Math.max(0.0f, newAmount - 1.0f);
        }
        return newAmount;
    }

    @Override
    public boolean onDeath(IChampion champion, DamageSource source) {
        Level world;
        AffixData.IntegerData buffer = AffixData.getData(champion, this.toString(), AffixData.IntegerData.class);
        LivingEntity target = null;
        if (source.m_7640_() instanceof LivingEntity) {
            target = (LivingEntity)source.m_7640_();
        }
        if ((world = champion.getLivingEntity().m_9236_()) instanceof ServerLevel) {
            InfestedAffix.spawnParasites(champion.getLivingEntity(), buffer.num, target, (ServerLevel)world);
        }
        return true;
    }

    @Override
    public List<Tuple<Integer, Goal>> getGoals(IChampion champion) {
        return Collections.singletonList(new Tuple((Object)0, (Object)new SpawnParasiteGoal((Mob)champion.getLivingEntity())));
    }

    @Override
    public boolean canApply(IChampion champion) {
        EntityType type = champion.getLivingEntity().m_6095_();
        return type != ChampionsConfig.infestedParasite && type != ChampionsConfig.infestedEnderParasite && super.canApply(champion);
    }

    private class SpawnParasiteGoal
    extends Goal {
        private final Mob mobEntity;
        private int attackTime;

        public SpawnParasiteGoal(Mob mobEntity) {
            this.mobEntity = mobEntity;
        }

        public void m_8056_() {
            this.attackTime = ChampionsConfig.infestedInterval * 20;
        }

        public void m_8037_() {
            --this.attackTime;
            if (this.attackTime <= 0) {
                ChampionCapability.getCapability((LivingEntity)this.mobEntity).ifPresent(champion -> {
                    AffixData.IntegerData buffer = AffixData.getData(champion, InfestedAffix.this.toString(), AffixData.IntegerData.class);
                    if (buffer.num > 0 && this.mobEntity.m_9236_() instanceof ServerLevel) {
                        this.attackTime = ChampionsConfig.infestedInterval * 20 + this.mobEntity.m_217043_().m_188503_(5) * 10;
                        int amount = ChampionsConfig.infestedAmount;
                        InfestedAffix.spawnParasites((LivingEntity)this.mobEntity, amount, this.mobEntity.m_5448_(), (ServerLevel)this.mobEntity.m_9236_());
                        buffer.num = Math.max(0, buffer.num - amount);
                        buffer.saveData();
                    }
                });
            }
        }

        public boolean m_8036_() {
            return BasicAffix.canTarget((LivingEntity)this.mobEntity, this.mobEntity.m_5448_(), true);
        }
    }
}

